/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.NameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.RuleAnalysis2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.RuleAnalysis2TraceGroup;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsageAnalysis;

public abstract class TransformationAnalysis2TracePackage {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull NameGenerator nameGenerator;
    protected final @NonNull TransformationAnalysis transformationAnalysis;
    protected final @NonNull Transformation transformation;
    private final @NonNull Package tracePackage;
    protected final @NonNull Map<@NonNull String, @NonNull RuleAnalysis2MiddleType> name2ruleAnalysis2middleType = new HashMap<String, RuleAnalysis2MiddleType>();
    protected final @NonNull Map<@NonNull Rule, @NonNull RuleAnalysis2TraceGroup> rule2relationAnalysis2traceGroup = new HashMap<Rule, RuleAnalysis2TraceGroup>();
    private @NonNull Map<@NonNull Type, @NonNull RuleAnalysis2MiddleType> middleClass2ruleAnalysis2middleType = new HashMap<Type, RuleAnalysis2MiddleType>();
    private boolean frozen = false;

    protected TransformationAnalysis2TracePackage(@NonNull ScheduleManager scheduleManager, @NonNull TransformationAnalysis transformationAnalysis) {
        this.scheduleManager = scheduleManager;
        this.nameGenerator = scheduleManager.getNameGenerator();
        this.transformationAnalysis = transformationAnalysis;
        this.transformation = transformationAnalysis.getTransformation();
        this.tracePackage = this.createTracePackage();
    }

    public void analyzeTraceElements() throws CompilerChainException {
        for (RuleAnalysis2TraceGroup relationAnalysis2traceGroup : this.getOrderedRuleAnalysis2TraceGroups()) {
            relationAnalysis2traceGroup.analyzeTraceElements();
        }
    }

    public @Nullable Property basicGetTraceProperty(@NonNull Type aClass, @NonNull VariableDeclaration rVariable) {
        RuleAnalysis2MiddleType relation2TraceClass = this.middleClass2ruleAnalysis2middleType.get(aClass);
        if (relation2TraceClass == null) {
            return null;
        }
        return relation2TraceClass.basicGetTraceProperty(rVariable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Class createClass(@NonNull RuleAnalysis2MiddleType ruleAnalysis2middleType, @NonNull String className) {
        @NonNull List traceClasses = QVTbaseUtil.Internal.getOwnedClassesList((Package)this.tracePackage);
        String uniqueName = NameGenerator.getUniqueName(this.name2ruleAnalysis2middleType, className, ruleAnalysis2middleType);
        Class traceClass = PivotUtil.createClass((String)uniqueName);
        traceClasses.add(traceClass);
        this.middleClass2ruleAnalysis2middleType.put((Type)traceClass, ruleAnalysis2middleType);
        this.name2ruleAnalysis2middleType.put(uniqueName, ruleAnalysis2middleType);
        return traceClass;
    }

    public void createRuleAnalysis2TraceGroups() {
        for (Rule rule : QVTbaseUtil.getOwnedRules((Transformation)this.transformation)) {
            RuleAnalysis ruleAnalysis = this.transformationAnalysis.getRuleAnalysis(rule);
            RuleAnalysis2TraceGroup relationAnalysis2traceGroup = this.scheduleManager.createRuleAnalysis2TraceGroup(ruleAnalysis);
            RuleAnalysis2TraceGroup oldRelationAnalysis2traceGroup = this.rule2relationAnalysis2traceGroup.put(rule, relationAnalysis2traceGroup);
            assert (oldRelationAnalysis2traceGroup == null);
        }
    }

    protected @NonNull Package createTracePackage() {
        Package rPackage = this.transformation.getOwningPackage();
        Package tracePackage = PivotFactory.eINSTANCE.createPackage();
        tracePackage.setName("trace_" + this.transformation.getName());
        tracePackage.setNsPrefix("P" + this.transformation.getName());
        StringBuilder sURI = new StringBuilder();
        this.getURI(rPackage, sURI);
        tracePackage.setURI(String.valueOf(sURI.toString()) + "/" + this.transformation.getName());
        return tracePackage;
    }

    public void freeze() {
        this.frozen = true;
    }

    public @NonNull Class getBagType(@NonNull Class traceClass) {
        return this.scheduleManager.getEnvironmentFactory().getCompleteEnvironment().getBagType((Type)traceClass, true, null, null);
    }

    public @NonNull Class getBooleanType() {
        return this.scheduleManager.getStandardLibrary().getBooleanType();
    }

    public @NonNull DomainUsageAnalysis getDomainUsageAnalysis() {
        return this.scheduleManager.getDomainUsageAnalysis();
    }

    public @NonNull NameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull RuleAnalysis2TraceGroup> getOrderedRuleAnalysis2TraceGroups() {
        @NonNull ArrayList relationAnalysis2traceGroups = Lists.newArrayList(this.rule2relationAnalysis2traceGroup.values());
        Collections.sort(relationAnalysis2traceGroups, OverrideDepthComparator.INSTANCE);
        return relationAnalysis2traceGroups;
    }

    protected @NonNull Property getProperty(Type aClass, String name) throws CompilerChainException {
        assert (aClass != null && name != null);
        CompleteClass completeClass = this.scheduleManager.getEnvironmentFactory().getCompleteModel().getCompleteClass(aClass);
        Property p = completeClass.getProperty(name);
        if (p != null) {
            return p;
        }
        throw new CompilerChainException("No property '" + name + "' in '" + aClass + "::" + "'", new Object[0]);
    }

    public @NonNull RuleAnalysis2TraceGroup getRuleAnalysis2TraceGroup(@NonNull Rule rule) {
        return (RuleAnalysis2TraceGroup)ClassUtil.nonNullState((Object)this.rule2relationAnalysis2traceGroup.get(rule));
    }

    public @NonNull Property getSignatureProperty(@NonNull Rule invokedRule, @NonNull VariableDeclaration variable) {
        throw new UnsupportedOperationException();
    }

    public @NonNull Class getTraceClass(@NonNull Rule rule) {
        return this.getRuleAnalysis2TraceGroup(rule).getTraceClass();
    }

    public @NonNull Package getTracePackage() {
        return this.tracePackage;
    }

    public @NonNull Property getTraceProperty(@NonNull Type aClass, @NonNull VariableDeclaration rVariable) throws CompilerChainException {
        Property property = this.basicGetTraceProperty(aClass, rVariable);
        if (property != null) {
            return property;
        }
        property = this.getProperty(aClass, rVariable.getName());
        if (rVariable instanceof Property) assert (rVariable == property);
        return property;
    }

    public @NonNull TransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    private String getURI(Package rPackage, @NonNull StringBuilder s) {
        if (rPackage == null) {
            s.append("http://www.eclipse.org/qvtd-example");
        } else if (rPackage.getURI() != null) {
            s.append(rPackage.getURI());
        } else {
            this.getURI(rPackage.getOwningPackage(), s);
            s.append("/");
            s.append(rPackage.getName());
        }
        return null;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public @NonNull Package synthesizeTraceModel() throws CompilerChainException {
        for (RuleAnalysis2TraceGroup relationAnalysis2traceGroup : this.getOrderedRuleAnalysis2TraceGroups()) {
            relationAnalysis2traceGroup.synthesizeTraceModel();
        }
        CompilerUtil.normalizeNameables(QVTbaseUtil.Internal.getOwnedClassesList((Package)this.tracePackage));
        for (Class traceClass : QVTbaseUtil.getOwnedClasses((Package)this.tracePackage)) {
            CompilerUtil.normalizeNameables(QVTbaseUtil.Internal.getOwnedPropertiesList((Class)traceClass));
        }
        return this.tracePackage;
    }

    public void synthesizeTraceElements() throws CompilerChainException {
        for (RuleAnalysis2TraceGroup relationAnalysis2traceGroup : this.getOrderedRuleAnalysis2TraceGroups()) {
            relationAnalysis2traceGroup.synthesizeTraceElements();
        }
    }

    public @NonNull String toString() {
        return String.valueOf(this.transformation);
    }

    static class OverrideDepthComparator
    implements Comparator<RuleAnalysis2TraceGroup> {
        public static final @NonNull OverrideDepthComparator INSTANCE = new OverrideDepthComparator();

        OverrideDepthComparator() {
        }

        @Override
        public int compare(@NonNull RuleAnalysis2TraceGroup o1, @NonNull RuleAnalysis2TraceGroup o2) {
            int d2;
            int d1 = this.getDepth(o1);
            if (d1 != (d2 = this.getDepth(o2))) {
                return d1 - d2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }

        private int getDepth(@NonNull RuleAnalysis2TraceGroup ruleAnalysis2TraceGroup) {
            int depth = 0;
            Rule aRule = ruleAnalysis2TraceGroup.getRule();
            while ((aRule = aRule.getOverridden()) != null) {
                ++depth;
            }
            return depth;
        }
    }
}

