/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvt.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.internal.EcoreForeignMethods;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.qvt.declarative.ecore.QVTBase.Function;
import org.eclipse.qvt.declarative.ecore.QVTBase.FunctionParameter;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.parser.environment.CSTChildEnvironment;
import org.eclipse.qvt.declarative.parser.plugin.QVTParserPlugin;
import org.eclipse.qvt.declarative.parser.qvt.environment.IQVTEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.environment.IQVTNodeEnvironment;
import org.eclipse.qvt.declarative.parser.utils.OCLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QVTEnvironment<E extends IQVTNodeEnvironment, P extends IQVTNodeEnvironment, AST extends Notifier, CST extends CSTNode>
extends CSTChildEnvironment<E, P, AST, CST>
implements IQVTEnvironment {
    protected QVTEnvironment(P parent, AST astNode, CST cstNode) {
        super(parent, astNode, cstNode);
    }

    protected void addedVariable(String name, org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> variable, boolean isExplicit) {
        if (variable == null) {
            return;
        }
        if (!(variable instanceof Variable)) {
            QVTParserPlugin.logError("non-derived Variable in " + this.getClass().getName() + ".addedVariable", null);
        }
    }

    public List<Function> findMatchingQueries(Transformation transformation, String queryName, List<OCLExpression> args) {
        ArrayList<Function> queries = new ArrayList<Function>();
        int iMax = args.size();
        for (EOperation eOperation : transformation.getEAllOperations()) {
            EList params;
            if (!(eOperation instanceof Function) || !queryName.equals(eOperation.getName()) || (params = eOperation.getEParameters()).size() != iMax) continue;
            int i = 0;
            while (i < iMax) {
                OCLExpression arg = args.get(i);
                EParameter param = (EParameter)params.get(i);
                EClassifier paramType = param.getEType();
                if (!this.isAssignableTo(paramType, arg)) break;
                ++i;
            }
            if (i < iMax) continue;
            queries.add((Function)eOperation);
        }
        return queries;
    }

    public Function findMatchingQuery(Transformation transformation, String name, List<FunctionParameter> parameters) {
        Function match = null;
        int iMax = parameters.size();
        for (EOperation candidateOperation : transformation.getEOperations()) {
            EList params;
            if (!(candidateOperation instanceof Function) || !name.equals(candidateOperation.getName()) || (params = candidateOperation.getEParameters()).size() != iMax) continue;
            int i = 0;
            while (i < iMax) {
                EClassifier queryType;
                EParameter candidateParameter = (EParameter)candidateOperation.getEParameters().get(i);
                EParameter queryParameter = (EParameter)parameters.get(i);
                EClassifier candidateType = candidateParameter.getEType();
                if (candidateType != (queryType = queryParameter.getEType())) break;
                ++i;
            }
            if (i < iMax) continue;
            if (match != null) {
                QVTParserPlugin.logError("Duplicate match for query '" + this.formatName(match) + "'", null);
            }
            match = (Function)candidateOperation;
        }
        return match;
    }

    public String getModelName(EObject object) {
        return ((IQVTNodeEnvironment)this.getParentEnvironment()).getModelName(object);
    }

    protected boolean getPackagedClassifiers(List<EClassifier> resolutions, EPackage currentPackage, List<String> names, boolean hasScope) {
        int namesSize = names.size();
        if (namesSize <= 0) {
            return false;
        }
        if (namesSize == 1) {
            String classifierName = names.get(0);
            EClassifier eClassifier = this.getPackagedClassifier(currentPackage, classifierName);
            if (eClassifier != null) {
                if (!resolutions.contains(eClassifier)) {
                    resolutions.add(eClassifier);
                }
                return true;
            }
            if (hasScope) {
                return false;
            }
        } else {
            String packageName = names.get(0);
            EPackage searchPackage = currentPackage;
            while (searchPackage != null) {
                EPackage ePackage = EcoreForeignMethods.getESubpackage((EPackage)searchPackage, (String)packageName);
                if (ePackage != null && this.getPackagedClassifiers(resolutions, ePackage, names.subList(1, namesSize), true)) {
                    return true;
                }
                if (hasScope) {
                    return false;
                }
                if (EcoreForeignMethods.isNamed((String)packageName, (ENamedElement)currentPackage) && this.getPackagedClassifiers(resolutions, currentPackage, names.subList(1, namesSize), true)) {
                    return true;
                }
                searchPackage = searchPackage.getESuperPackage();
            }
        }
        boolean found = false;
        for (EPackage ePackage : currentPackage.getESubpackages()) {
            if (!this.getPackagedClassifiers(resolutions, ePackage, names, false)) continue;
            found = true;
        }
        return found;
    }

    protected String getOppositeName(EReference reference) {
        EReference eOpposite = reference.getEOpposite();
        if (eOpposite != null) {
            return eOpposite.getName();
        }
        EAnnotation annotation = reference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
        if (annotation != null) {
            return (String)annotation.getDetails().get((Object)"body");
        }
        return this.initialLower(reference.getEContainingClass());
    }

    protected EClassifier getPackagedClassifier(EPackage currentPackage, String classifierName) {
        if (currentPackage instanceof EClassifier && classifierName.equals(currentPackage.getName())) {
            return (EClassifier)currentPackage;
        }
        return EcoreForeignMethods.getEClassifier((EPackage)currentPackage, (String)classifierName);
    }

    public Transformation getTransformation() {
        return ((IQVTNodeEnvironment)this.getParentEnvironment()).getTransformation();
    }

    public boolean isAssignableTo(EClassifier featureType, OCLExpression oclExpression) {
        if (featureType == null) {
            return false;
        }
        if (!this.isResolved((EObject)featureType)) {
            return false;
        }
        EClassifier expressionType = (EClassifier)this.getUMLReflection().getOCLType(oclExpression.getType());
        if (expressionType == null) {
            return false;
        }
        if (!this.isResolved((EObject)expressionType)) {
            return false;
        }
        if (featureType == expressionType) {
            return true;
        }
        if (featureType instanceof EEnum) {
            EEnumLiteral enumLiteral;
            String enumLiteralText = oclExpression.toString();
            if (enumLiteralText.length() >= 2) {
                enumLiteralText = enumLiteralText.substring(1, enumLiteralText.length() - 1);
            }
            if ((enumLiteral = ((EEnum)featureType).getEEnumLiteral(enumLiteralText)) != null) {
                return true;
            }
        } else if (featureType instanceof CollectionType) {
            CollectionKind featureKind = ((CollectionType)featureType).getKind();
            EClassifier featureElementType = (EClassifier)((CollectionType)featureType).getElementType();
            CollectionKind expressionKind = null;
            EClassifier expressionElementType = expressionType;
            if (expressionType instanceof CollectionType) {
                expressionKind = ((CollectionType)expressionType).getKind();
                expressionElementType = (EClassifier)((CollectionType)expressionType).getElementType();
            }
            if (expressionElementType == null) {
                return false;
            }
            if (!this.isResolved((EObject)expressionElementType)) {
                return false;
            }
            if (expressionElementType instanceof EClass && ((EClass)featureElementType).isSuperTypeOf((EClass)expressionElementType) && (expressionKind == null || !OCLUtils.isUnique(featureKind) || OCLUtils.isUnique(expressionKind))) {
                return true;
            }
        } else if (!(featureType instanceof EDataType) && !(featureType instanceof TupleType) && featureType instanceof EClass && expressionType instanceof EClass && ((EClass)featureType).isSuperTypeOf((EClass)expressionType)) {
            return true;
        }
        return false;
    }

    public Transformation lookupImportedTransformation(String name) {
        return ((IQVTNodeEnvironment)this.getParentEnvironment()).lookupImportedTransformation(name);
    }

    public Variable lookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> params) {
        return ((IQVTNodeEnvironment)this.getParentEnvironment()).lookupImplicitSourceForOperation(name, params);
    }

    public Variable lookupImplicitSourceForProperty(String name) {
        return ((IQVTNodeEnvironment)this.getParentEnvironment()).lookupImplicitSourceForProperty(name);
    }

    @Override
    protected void removedVariable(String name, org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> variable, boolean isExplicit) {
    }

    @Override
    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        return (EClassifier)((IQVTNodeEnvironment)this.getParentEnvironment()).tryLookupClassifier(names);
    }

    public EClassifier tryLookupClassifier(Collection<EPackage> contextPackages, List<String> names) throws LookupException {
        if (contextPackages.isEmpty()) {
            return null;
        }
        ArrayList<EClassifier> resolutions = new ArrayList<EClassifier>(2);
        for (EPackage contextPackage : contextPackages) {
            this.getPackagedClassifiers(resolutions, contextPackage, names, false);
        }
        if (resolutions.size() <= 0) {
            return null;
        }
        if (resolutions.size() == 1) {
            return (EClassifier)resolutions.get(0);
        }
        throw new LookupException("Ambiguous name '" + this.formatPath(names) + "'", resolutions);
    }

    public Transformation tryLookupTransformation(List<String> pathName) throws LookupException {
        return ((IQVTNodeEnvironment)this.getParentEnvironment()).tryLookupTransformation(pathName);
    }

    public EReference tryLookupOppositeProperty(EClass eClass, String propertyName) throws LookupException {
        return ((IQVTNodeEnvironment)this.getParentEnvironment()).tryLookupOppositeProperty(eClass, propertyName);
    }

    public Variable tryLookupVariable(String name) throws LookupException {
        return ((IQVTNodeEnvironment)this.getParentEnvironment()).tryLookupVariable(name);
    }

    public void validatorError(String problemMessage, String problemContext, Object problemObject) {
        if (problemObject instanceof OperationCallExp && ((OperationCallExp)problemObject).getReferredOperation() instanceof Function && problemMessage.startsWith("Null source in operation call ")) {
            return;
        }
        super.validatorError(problemMessage, problemContext, problemObject);
    }
}

