/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtrelation.unparser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.qvt.declarative.ecore.QVTBase.Domain;
import org.eclipse.qvt.declarative.ecore.QVTBase.Function;
import org.eclipse.qvt.declarative.ecore.QVTBase.Pattern;
import org.eclipse.qvt.declarative.ecore.QVTBase.Predicate;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTRelation.DomainPattern;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Key;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Relation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomain;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationDomainAssignment;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationImplementation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.CollectionTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.ObjectTemplateExp;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.PropertyTemplateItem;
import org.eclipse.qvt.declarative.ecore.QVTTemplate.TemplateExp;
import org.eclipse.qvt.declarative.parser.qvt.environment.QVTReflectionImpl;
import org.eclipse.qvt.declarative.parser.qvtrelation.unparser.QVTrExpressionUnparser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTrUnparser
extends QVTrExpressionUnparser {
    protected Set<String> reservedKeywords = new HashSet<String>();

    public QVTrUnparser(Resource resource) {
        super(resource, (UMLReflection<?, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)QVTReflectionImpl.INSTANCE);
        this.reservedKeywords.add("domain");
        this.reservedKeywords.add("key");
        this.reservedKeywords.add("when");
        this.reservedKeywords.add("where");
    }

    protected String formatName(Object object) {
        String formatName = super.formatName(object);
        if (this.reservedKeywords.contains(formatName)) {
            return "_" + formatName;
        }
        return formatName;
    }

    protected void getPatternVariables(Set<Variable> patternVariables, Relation relation) {
        for (Domain domain : relation.getDomain()) {
            if (!(domain instanceof RelationDomain)) continue;
            patternVariables.add(((RelationDomain)domain).getRootVariable());
            DomainPattern pattern = ((RelationDomain)domain).getPattern();
            if (pattern == null) continue;
            this.getPatternVariables(patternVariables, pattern.getTemplateExpression());
        }
    }

    protected void getPatternVariables(Set<Variable> patternVariables, TemplateExp templateExpression) {
        block4: {
            block3: {
                if (templateExpression == null) {
                    return;
                }
                patternVariables.add(templateExpression.getBindsTo());
                if (!(templateExpression instanceof ObjectTemplateExp)) break block3;
                for (PropertyTemplateItem part : ((ObjectTemplateExp)templateExpression).getPart()) {
                    OCLExpression value = part.getValue();
                    if (!(value instanceof TemplateExp)) continue;
                    this.getPatternVariables(patternVariables, (TemplateExp)value);
                }
                break block4;
            }
            if (!(templateExpression instanceof CollectionTemplateExp)) break block4;
            for (OCLExpression value : ((CollectionTemplateExp)templateExpression).getMember()) {
                if (!(value instanceof TemplateExp)) continue;
                this.getPatternVariables(patternVariables, (TemplateExp)value);
            }
        }
    }

    public void unparse() {
        this.initialize();
        for (EObject eObject : this.resource.getContents()) {
            if (eObject instanceof RelationalTransformation) {
                this.unparseRelationalTransformation((RelationalTransformation)eObject);
                continue;
            }
            this.append("\n***" + ((Object)((Object)this)).getClass().getSimpleName() + "-Unsupported-" + eObject.getClass().getSimpleName() + "***\n");
        }
    }

    protected void unparseDomainPattern(DomainPattern pattern) {
        if (pattern == null) {
            return;
        }
        this.doExpressionSwitch((ETypedElement)pattern.getTemplateExpression());
        EList predicates = pattern.getPredicate();
        if (predicates.size() > 0) {
            this.append("\n{\n");
            this.indent();
            for (Predicate predicate : predicates) {
                this.unparsePredicate(predicate);
            }
            this.exdent();
            this.append("}");
        }
    }

    protected void unparseKey(Key key) {
        if (key == null) {
            return;
        }
        this.append("key ");
        this.appendQualifiedName(key.getIdentifies());
        this.append(" { ");
        boolean first = true;
        for (EStructuralFeature property : key.getPart()) {
            if (!first) {
                this.append(", ");
            }
            this.appendName(property);
            first = false;
        }
        for (EStructuralFeature property : key.getOppositePart()) {
            if (!first) {
                this.append(", ");
            }
            this.append(this.getNameForOpposite(property));
            first = false;
        }
        this.append(" };\n");
    }

    protected void unparseParameter(EParameter parameter) {
        if (parameter == null) {
            return;
        }
        this.appendName(parameter);
        this.append(" : ");
        this.appendName(parameter.getEType());
    }

    protected void unparsePattern(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        for (Predicate predicate : pattern.getPredicate()) {
            this.unparsePredicate(predicate);
        }
    }

    protected void unparsePredicate(Predicate predicate) {
        this.doExpressionSwitch((ETypedElement)predicate.getConditionExpression());
        this.append(";\n");
    }

    protected void unparseQuery(Function query) {
        if (query == null) {
            return;
        }
        this.append("query ");
        this.appendName(query);
        this.append("(");
        boolean first = true;
        for (EParameter eParameter : query.getEParameters()) {
            if (!first) {
                this.append(", ");
            }
            this.unparseParameter(eParameter);
            first = false;
        }
        this.append(") : ");
        this.appendName(query.getEType());
        OCLExpression body = query.getQueryExpression();
        if (body != null) {
            this.append(" {\n");
            this.indent();
            this.doExpressionSwitch((ETypedElement)body);
            this.append("\n");
            this.exdent();
            this.append("}\n");
        } else {
            this.append(";\n");
        }
    }

    protected void unparseRelation(Relation relation) {
        Pattern where;
        if (relation == null) {
            return;
        }
        if (relation.isIsTopLevel()) {
            this.append("top ");
        }
        this.append("relation ");
        this.appendName(relation);
        this.append(" {\n");
        this.indent();
        HashSet<Variable> patternVariables = new HashSet<Variable>();
        this.getPatternVariables(patternVariables, relation);
        EList variables = relation.getVariable();
        if (variables.size() > 0) {
            for (Variable variable : variables) {
                if (patternVariables.contains(variable) || "_".equals(variable.getName())) continue;
                this.unparseVariable(variable);
                this.append(";\n");
            }
        }
        for (Domain domain : relation.getDomain()) {
            if (!(domain instanceof RelationDomain)) continue;
            this.unparseRelationDomain((RelationDomain)domain);
        }
        Pattern when = relation.getWhen();
        if (when != null) {
            this.append("when {\n");
            this.indent();
            this.unparsePattern(when);
            this.exdent();
            this.append("}\n");
        }
        if ((where = relation.getWhere()) != null) {
            this.append("where {\n");
            this.indent();
            this.unparsePattern(where);
            this.exdent();
            this.append("}\n");
        }
        this.exdent();
        this.append("}\n");
    }

    protected void unparseRelationDomain(RelationDomain domain) {
        DomainPattern domainPattern;
        if (domain == null) {
            return;
        }
        if (!domain.isIsEnforceable() && domain.isIsCheckable()) {
            this.append("checkonly ");
        }
        if (!domain.isIsCheckable() && domain.isIsEnforceable()) {
            this.append("enforce ");
        }
        if ((domainPattern = domain.getPattern()) == null) {
            this.append("primitive ");
        }
        this.append("domain ");
        if (domainPattern == null) {
            this.unparseVariable(domain.getRootVariable());
            this.append(";\n");
        } else {
            this.appendName(domain);
            this.append("\n");
            this.indent();
            this.unparseDomainPattern(domain.getPattern());
            this.exdent();
            Relation relation = (Relation)domain.getRule();
            TypedModel typedModel = domain.getTypedModel();
            for (RelationImplementation implementation : relation.getOperationalImpl()) {
                if (implementation.getInDirectionOf() != typedModel) continue;
                this.append("\n");
                this.append("implementedby ");
                this.doExpressionSwitch((ETypedElement)implementation.getImpl());
                this.append("()");
            }
            EList domainInitializers = domain.getDefaultAssignment();
            if (domainInitializers.size() > 0) {
                this.append("\n");
                this.append("default_values {\n");
                this.indent();
                for (RelationDomainAssignment domainInitializer : domainInitializers) {
                    this.appendName(domainInitializer.getVariable());
                    this.append(" = ");
                    this.doExpressionSwitch((ETypedElement)domainInitializer.getValueExp());
                    this.append(";\n");
                }
                this.exdent();
                this.append("}");
            }
            this.append(";\n");
        }
    }

    protected void unparseRelationalTransformation(RelationalTransformation transformation) {
        EList relations;
        EList queries;
        if (transformation == null) {
            return;
        }
        this.append("transformation ");
        this.appendName(transformation);
        this.append("(");
        boolean first = true;
        for (TypedModel typedModel : transformation.getModelParameter()) {
            if (!first) {
                this.append(", ");
            }
            this.unparseTypedModel(typedModel);
            first = false;
        }
        this.append(")\n");
        this.append("{\n");
        this.indent();
        EList keys = transformation.getOwnedKey();
        if (keys.size() > 0) {
            for (Key key : keys) {
                this.unparseKey(key);
            }
        }
        if ((queries = transformation.getEOperations()).size() > 0) {
            for (EOperation query : queries) {
                if (!(query instanceof Function)) continue;
                this.append("\n");
                this.unparseQuery((Function)query);
            }
        }
        if ((relations = transformation.getRule()).size() > 0) {
            for (Rule relation : relations) {
                if (!(relation instanceof Relation)) continue;
                this.append("\n");
                this.unparseRelation((Relation)relation);
            }
        }
        this.exdent();
        this.append("}\n");
    }

    protected void unparseTypedModel(TypedModel typedModel) {
        if (typedModel == null) {
            return;
        }
        this.appendName(typedModel);
        this.append(":");
        EList usedPackages = typedModel.getUsedPackage();
        if (usedPackages.size() > 1) {
            this.append("{");
        }
        boolean first = true;
        for (EPackage ePackage : usedPackages) {
            if (!first) {
                this.append(",");
            }
            this.appendName(ePackage);
            first = false;
        }
        if (usedPackages.size() > 1) {
            this.append("}");
        }
    }
}

