/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTBase.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.qvt.declarative.ecore.QVTBase.Function;
import org.eclipse.qvt.declarative.ecore.QVTBase.FunctionParameter;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.AbstractQVTBaseOperations;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.QVTBaseMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionOperations
extends AbstractQVTBaseOperations {
    public static FunctionOperations INSTANCE = new FunctionOperations();

    public boolean checkEveryFunctionParameterIsAFunctionParameter(Function function, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        for (EParameter parameter : function.getEParameters()) {
            if (parameter instanceof FunctionParameter) continue;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)parameter, context)};
            this.appendError(diagnostics, parameter, QVTBaseMessages._UI_Function_ParameterIsNotAFunctionParameter, messageSubstitutions);
            allOk = false;
        }
        return allOk;
    }

    public boolean checkIsSideEffectFree(Function function, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        TreeIterator i = function.eAllContents();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            String reason = this.mayHaveSideEffect(eObject);
            if (reason == null) continue;
            Object[] messageSubstitutions = new Object[]{reason, this.getObjectLabel((EObject)function, context)};
            this.appendWarning(diagnostics, function, QVTBaseMessages._UI_Function_MayHaveASideEffect, messageSubstitutions);
            allOk = false;
        }
        return allOk;
    }

    protected String mayHaveSideEffect(EObject eObject) {
        if (!(eObject instanceof OCLExpression)) {
            return null;
        }
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == ExpressionsPackage.eINSTANCE || ePackage == EcorePackage.eINSTANCE) {
            return null;
        }
        return eClass.getName();
    }
}

