/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import org.eclipse.imp.preferences.ConfigurationPreferencesTab;
import org.eclipse.imp.preferences.DefaultPreferencesTab;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.InstancePreferencesTab;
import org.eclipse.imp.preferences.PreferencesInitializer;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.ProjectPreferencesTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class TabbedPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    PreferencesTab[] tabs = new PreferencesTab[4];
    protected IPreferencesService prefService = null;

    public TabbedPreferencesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 0;
        gd.heightHint = -1;
        gd.horizontalSpan = 1;
        tabFolder.setLayoutData((Object)gd);
        this.tabs = this.createTabs(this.prefService, this, tabFolder);
        this.setInitialStateForTabs();
        this.notifyState(true);
        Dialog.applyDialogFont((Control)parent);
        if (this.tabs.length > 1) {
            int idx = -1;
            int i = 0;
            while (i < this.tabs.length) {
                if (this.tabs[i].getLevel().equals("instance")) {
                    idx = i;
                }
                ++i;
            }
            if (idx > 0) {
                tabFolder.setSelection(idx);
            }
        }
        return tabFolder;
    }

    protected void setInitialStateForTabs() {
        int i = 0;
        while (i < this.tabs.length) {
            if (this.tabs[i] instanceof DefaultPreferencesTab) {
                this.tabs[i].performDefaults();
                this.tabs[i].performApply();
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.tabs.length) {
            if (this.tabs[i] instanceof ConfigurationPreferencesTab) {
                this.tabs[i].performApply();
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.tabs.length) {
            if (this.tabs[i] instanceof InstancePreferencesTab) {
                this.tabs[i].performApply();
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.tabs.length) {
            if (this.tabs[i] instanceof ProjectPreferencesTab) {
                this.tabs[i].performDefaults();
                this.tabs[i].performApply();
                break;
            }
            ++i;
        }
    }

    protected abstract PreferencesTab[] createTabs(IPreferencesService var1, TabbedPreferencesPage var2, TabFolder var3);

    public boolean notifyState(boolean state) {
        boolean allValid = true;
        int i = 0;
        while (i < this.tabs.length && allValid) {
            allValid = allValid && this.tabs[i] != null && this.tabs[i].isValid();
            ++i;
        }
        this.setValid(allValid);
        return allValid;
    }

    public void performApply() {
        int i = 0;
        while (i < this.tabs.length) {
            this.tabs[i].performApply();
            ++i;
        }
    }

    public boolean performCancel() {
        boolean result = true;
        int i = 0;
        while (i < this.tabs.length) {
            if (this.tabs[i] != null) {
                result = result && this.tabs[i].performCancel();
            }
            ++i;
        }
        return result;
    }

    public void performDefaults() {
        int i = 0;
        while (i < this.tabs.length) {
            if (this.tabs[i].getTabItem().getControl().isVisible()) {
                this.tabs[i].performDefaults();
            }
            ++i;
        }
    }

    public boolean performOk() {
        boolean result = true;
        int i = this.tabs.length - 1;
        while (i >= 0) {
            result = result && this.tabs[i].performOk();
            --i;
        }
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected PreferencesTab[] getTabs() {
        return this.tabs;
    }

    public PreferencesInitializer getPreferenceInitializer() {
        System.out.println("TabbedPreferencesPage.getPreferenceInitializar():  unimplemented; should be overridden with language-specific implementation");
        return null;
    }
}

