/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.core.IMPMessages;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    public static boolean isEditorInput(Object element, IEditorPart editor) {
        if (editor != null) {
            return editor.getEditorInput().equals(EditorUtility.getEditorInput(element));
        }
        return false;
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        input = EditorUtility.getEditorInput(inputElement);
        if (input != null && (p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws PartInitException {
        ISourceEntity editorCU;
        IEditorPart editor;
        IWorkbenchPage page;
        ICompilationUnit cu;
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        if (inputElement instanceof ISourceEntity && (cu = (ICompilationUnit)((ISourceEntity)inputElement).getAncestor(ICompilationUnit.class)) != null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null && (editor = page.getActiveEditor()) != null && (editorCU = EditorUtility.getEditorInputModelElement(editor, false)) == cu) {
            EditorUtility.revealInEditor(editor, (ISourceEntity)inputElement);
            return editor;
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, ISourceEntity element) {
        if (element == null) {
            return;
        }
        if (part instanceof UniversalEditor) {
            return;
        }
    }

    public static void revealInEditor(IEditorPart part, IRegion region) {
        if (part != null && region != null) {
            EditorUtility.revealInEditor(part, region.getOffset(), region.getLength());
        }
    }

    public static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                final IGotoMarker gotoMarkerTarget = (IGotoMarker)editor;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            String[] attributeNames = new String[]{"charStart", "charEnd"};
                            Object[] values = new Object[]{offset, offset + length};
                            marker.setAttributes(attributeNames, values);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (editor != null && editor.getEditorSite().getSelectionProvider() != null) {
            IEditorSite site = editor.getEditorSite();
            if (site == null) {
                return;
            }
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            provider.setSelection((ISelection)new TextSelection(offset, length));
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            boolean enable;
            IAction toggleAction = editorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl = enable = toggleAction != null;
            if (enable && editorPart instanceof UniversalEditor) {
                enable = false;
            } else {
                boolean bl2 = enable = enable && toggleAction.isEnabled() && toggleAction.isChecked();
            }
            if (enable) {
                if (toggleAction instanceof TextEditorAction) {
                    ((TextEditorAction)toggleAction).setEditor(null);
                    ((TextEditorAction)toggleAction).setEditor((ITextEditor)editorPart);
                } else {
                    toggleAction.run();
                    toggleAction.run();
                }
            }
        }
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        IEditorDescriptor editorDescriptor;
        try {
            editorDescriptor = input instanceof IFileEditorInput ? IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile()) : IDE.getEditorDescriptor((String)input.getName());
        }
        catch (PartInitException partInitException) {
            return null;
        }
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return null;
    }

    public static ISourceEntity getEditorInputModelElement(IEditorPart editor, boolean primaryOnly) {
        Assert.isNotNull((Object)editor);
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        ISourceEntity se = EditorUtility.getEditorInputModelElement(editorInput);
        if (se != null || primaryOnly) {
            return se;
        }
        return null;
    }

    private static IEditorInput getEditorInput(ISourceEntity element) {
        while (element != null) {
            if (element instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)element;
                IFile file = unit.getFile();
                return new FileEditorInput(file);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) {
        if (input instanceof ISourceEntity) {
            return EditorUtility.getEditorInput((ISourceEntity)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof IPath) {
            IPath path = (IPath)input;
            if (path.isAbsolute()) {
                try {
                    IFileSystem fileSystem = EFS.getFileSystem((String)"file");
                    IFileStore fileStore = fileSystem.getStore((IPath)input);
                    return new FileStoreEditorInput(fileStore);
                }
                catch (CoreException e) {
                    RuntimePlugin.getInstance().logException(e.getLocalizedMessage(), e);
                }
            } else {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                return new FileEditorInput(ws.getRoot().getFile(path));
            }
        }
        return null;
    }

    public static ISourceEntity getEditorInputModelElement(IEditorInput editorInput) {
        return (ISourceEntity)editorInput.getAdapter(ISourceEntity.class);
    }

    public static ISourceEntity getActiveEditorModelInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            return EditorUtility.getEditorInputModelElement(editorInput);
        }
        return null;
    }

    public static int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return IMPMessages.format(IMPMessages.EditorUtility_concatModifierStrings, new String[]{modifierString, newModifierString});
    }

    public static ISourceProject getSourceProject(IEditorInput input) {
        IProject project;
        ISourceProject srcProject = null;
        if (input instanceof IFileEditorInput && (project = ((IFileEditorInput)input).getFile().getProject()) != null) {
            try {
                srcProject = ModelFactory.open(project);
            }
            catch (ModelFactory.ModelException e) {
                RuntimePlugin.getInstance().logException("Error getting source project for " + project.getName(), e);
            }
        }
        return srcProject;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }
}

