/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.builder.CommonNature;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractToggleNatureAction
implements IObjectActionDelegate {
    protected final ICreationFactory creationFactory;
    private ISelection selection;

    protected AbstractToggleNatureAction(ICreationFactory creationFactory) {
        this.creationFactory = creationFactory;
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                String natureId = this.creationFactory.getNatureId();
                try {
                    CommonNature nature = this.creationFactory.createNature();
                    if (nature.removeFromProject(project)) continue;
                    nature.addToProject(project);
                }
                catch (CoreException e) {
                    this.creationFactory.getPlugin().logException("Failed to toggle nature " + natureId, e);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

