/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.model.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.model.IPathEntry;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.model.ISourceFolder;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.IWorkspaceModel;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.model.internal.PathEntry;
import org.eclipse.imp.model.internal.ResourceUtility;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceProject
implements ISourceProject {
    private static final String CONFIG_FILE_NAME = ".projectConfig";
    private final IProject fProject;
    private final List<IPathEntry> fBuildPath = new ArrayList<IPathEntry>();

    public SourceProject(IProject project) {
        this.fProject = project;
        this.readMetaData();
    }

    @Override
    public void setBuildPath(List<IPathEntry> buildPath) {
        this.fBuildPath.clear();
        this.fBuildPath.addAll(buildPath);
    }

    @Override
    public String getName() {
        return this.fProject.getName();
    }

    private void saveMetaData(IProgressMonitor monitor) {
        IFile file = this.fProject.getFile(CONFIG_FILE_NAME);
        String metaData = this.createProjectMetaData();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(metaData.getBytes(file.getCharset()));
            file.setContents((InputStream)is, true, true, monitor);
        }
        catch (CoreException e) {
            ErrorHandler.reportError(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            ErrorHandler.reportError(e.getMessage(), e);
        }
    }

    private String createProjectMetaData() {
        StringBuffer buff = new StringBuffer();
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buff.append("<project>\n");
        buff.append("  <searchPath>\n");
        for (IPathEntry path : this.fBuildPath) {
            buff.append("    <pathEntry type=\"" + (Object)((Object)path.getEntryType()) + "\"\n");
            buff.append("               loc=\"" + path.getPath().toPortableString() + "\"/>\n");
        }
        buff.append("  </searchPath>\n");
        buff.append("</project>\n");
        return buff.toString();
    }

    private boolean readMetaData() {
        IFile file = this.fProject.getFile(CONFIG_FILE_NAME);
        if (file.exists()) {
            try {
                InputStream contents = file.getContents();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(contents);
                NodeList children = document.getChildNodes();
                Node project = children.item(0);
                NodeList configItems = project.getChildNodes();
                int i = 0;
                while (i < configItems.getLength()) {
                    Node configItem = configItems.item(i);
                    String itemName = configItem.getNodeName();
                    if (itemName.equals("searchPath")) {
                        NodeList pathItems = configItem.getChildNodes();
                        int p = 0;
                        while (p < pathItems.getLength()) {
                            Node pathItem = pathItems.item(p);
                            String nodeName = pathItem.getNodeName();
                            if (!nodeName.equals("#text")) {
                                if (!nodeName.equals("pathEntry")) {
                                    ErrorHandler.reportError("Unexpected child " + nodeName + " of <searchPath> in " + this.fProject.getFullPath().toPortableString() + "/" + CONFIG_FILE_NAME);
                                } else {
                                    NamedNodeMap attribs = pathItem.getAttributes();
                                    Node typeNode = attribs.getNamedItem("type");
                                    Node locNode = attribs.getNamedItem("loc");
                                    if (typeNode == null || locNode == null) {
                                        ErrorHandler.reportError("<pathEntry> missing type or location in " + this.fProject.getFullPath().toPortableString() + "/" + CONFIG_FILE_NAME);
                                    } else {
                                        String pathType = typeNode.getNodeValue();
                                        String pathLoc = locNode.getNodeValue();
                                        PathEntry entry = new PathEntry(IPathEntry.PathEntryType.valueOf(pathType), (IPath)new Path(pathLoc));
                                        this.fBuildPath.add(entry);
                                    }
                                }
                            }
                            ++p;
                        }
                    } else if (!itemName.equals("#text")) {
                        ErrorHandler.reportError("Unrecognized project configuration item: " + itemName);
                    }
                    ++i;
                }
                return true;
            }
            catch (CoreException e) {
                ErrorHandler.reportError(e.getMessage(), e);
            }
            catch (ParserConfigurationException e) {
                ErrorHandler.reportError(e.getMessage(), e);
            }
            catch (SAXException e) {
                ErrorHandler.reportError(e.getMessage(), e);
            }
            catch (IOException e) {
                ErrorHandler.reportError(e.getMessage(), e);
            }
        }
        return false;
    }

    @Override
    public IPath resolvePath(IPath path) {
        List<IPathEntry> buildPath = this.getBuildPath();
        IProject rawProject = this.fProject;
        if (path.isAbsolute()) {
            return path;
        }
        IFile projRelFile = rawProject.getFile(path);
        if (projRelFile.exists()) {
            return rawProject.getFullPath().append(path);
        }
        for (IPathEntry pathEntry : buildPath) {
            IPath entryPath = pathEntry.getPath();
            IPathEntry.PathEntryType type = pathEntry.getEntryType();
            if (type == IPathEntry.PathEntryType.SOURCE_FOLDER) {
                File f;
                IPath filePath;
                IFile file;
                if (!(!entryPath.isAbsolute() ? (file = rawProject.getFile(filePath = entryPath.removeFirstSegments(1).append(path))).exists() : (f = new File((filePath = entryPath.append(path)).toOSString())).exists())) continue;
                return filePath;
            }
            if (type != IPathEntry.PathEntryType.PROJECT) continue;
            try {
                IProject defProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entryPath.toPortableString());
                ISourceProject defSrcProject = ModelFactory.open(defProject);
                IPath defPath = this.scanSourceFoldersFor(defSrcProject, path);
                if (defPath == null) continue;
                return defPath;
            }
            catch (ModelFactory.ModelException e) {
                ErrorHandler.reportError(e.getMessage());
            }
        }
        return null;
    }

    private IPath scanSourceFoldersFor(ISourceProject srcProject, IPath path) {
        List<IPathEntry> buildPath = srcProject.getBuildPath();
        IProject rawProject = srcProject.getRawProject();
        for (IPathEntry pathEntry : buildPath) {
            IPath filePath;
            IFile f;
            IPath entryPath = pathEntry.getPath();
            IPathEntry.PathEntryType type = pathEntry.getEntryType();
            if (type != IPathEntry.PathEntryType.SOURCE_FOLDER || !(f = rawProject.getFile(filePath = (entryPath = entryPath.removeFirstSegments(1)).append(path))).exists()) continue;
            return filePath;
        }
        return null;
    }

    @Override
    public List<IPathEntry> getBuildPath() {
        return this.fBuildPath;
    }

    @Override
    public IProject getRawProject() {
        return this.fProject;
    }

    @Override
    public IResource getResource() {
        return this.fProject;
    }

    @Override
    public ISourceFolder[] getSourceRoots() {
        HashSet<ISourceFolder> result = new HashSet<ISourceFolder>();
        Set<IResource> children = ResourceUtility.getImmediateChildren((IResource)this.fProject);
        for (IResource child : children) {
            if (!(child instanceof IFolder)) continue;
            try {
                result.add(ModelFactory.open((IFolder)child));
            }
            catch (ModelFactory.ModelException e) {
                RuntimePlugin.getInstance().logException(e.getMessage(), e);
            }
        }
        return result.toArray(new ISourceFolder[result.size()]);
    }

    @Override
    public ISourceEntity getParent() {
        return ModelFactory.getModelRoot();
    }

    @Override
    public ISourceEntity getAncestor(Class ofType) {
        if (ofType == ISourceProject.class) {
            return this;
        }
        if (ofType == IWorkspaceModel.class) {
            return ModelFactory.getModelRoot();
        }
        return null;
    }

    @Override
    public ISourceEntity[] getChildren() {
        HashSet<ISourceEntity> result = new HashSet<ISourceEntity>();
        Set<IResource> children = ResourceUtility.getImmediateChildren((IResource)this.fProject);
        for (IResource child : children) {
            try {
                result.add(ModelFactory.open(child));
            }
            catch (ModelFactory.ModelException e) {
                RuntimePlugin.getInstance().logException(e.getMessage(), e);
            }
        }
        return result.toArray(new ISourceEntity[result.size()]);
    }

    @Override
    public void commit(IProgressMonitor monitor) {
        this.saveMetaData(monitor);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceProject)) {
            return false;
        }
        SourceProject other = (SourceProject)obj;
        return this.fProject.equals((Object)other.fProject);
    }

    public int hashCode() {
        int result = 6607;
        result = result * 7451 + this.fProject.hashCode();
        return result;
    }

    public String toString() {
        return "<project: " + this.fProject.getName() + ">";
    }
}

