/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.ConstantTargetCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.MultipleEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NavigableEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NonNullInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.PredicateEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.SpeculationCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.FallibilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractFallibilityAnalysis
implements FallibilityAnalysis {
    protected final @NonNull PartitionAnalysis partitionAnalysis;
    protected final @NonNull Partition partition;
    protected final @NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull Set<@NonNull SuccessEdge> checkedSuccessHeadEdges = new HashSet<SuccessEdge>();
    protected final @NonNull Set<@NonNull SuccessEdge> realizedSuccessHeadEdges = new HashSet<SuccessEdge>();
    protected final @NonNull Set<@NonNull SuccessEdge> predicatedSuccessNonHeadEdges = new HashSet<SuccessEdge>();
    protected final @NonNull Set<@NonNull SuccessEdge> speculatedSuccessNonHeadEdges = new HashSet<SuccessEdge>();

    public AbstractFallibilityAnalysis(@NonNull PartitionAnalysis partitionAnalysis) {
        this.partitionAnalysis = partitionAnalysis;
        this.partition = partitionAnalysis.getPartition();
        this.partitionedTransformationAnalysis = partitionAnalysis.getPartitionedTransformationAnalysis();
        this.scheduleManager = this.partitionedTransformationAnalysis.getScheduleManager();
    }

    public void analyze(@NonNull AbstractFallibilityAnalysis nestedFallibilityAnalysis) {
        this.checkedSuccessHeadEdges.addAll(nestedFallibilityAnalysis.checkedSuccessHeadEdges);
        this.realizedSuccessHeadEdges.addAll(nestedFallibilityAnalysis.realizedSuccessHeadEdges);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void analyzeSuccessEdges(@NonNull Partition partition) {
        this.analyzeSuccessHeadEdges(partition);
        @NonNull Iterable headNodes = QVTscheduleUtil.getHeadNodes((Partition)partition);
        for (Edge edge : partition.getPartialEdges()) {
            boolean targetValue;
            if (!(edge instanceof SuccessEdge)) continue;
            Role edgeRole = partition.getRole(edge);
            assert (edgeRole != null);
            SuccessEdge successEdge = (SuccessEdge)edge;
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            if (Iterables.contains((Iterable)headNodes, (Object)sourceNode) || !edgeRole.isChecked() || !(targetNode instanceof BooleanLiteralNode) || !(targetValue = ((BooleanLiteralNode)targetNode).isBooleanValue())) continue;
            if (edgeRole.isPredicated()) {
                this.predicatedSuccessNonHeadEdges.add(successEdge);
                continue;
            }
            this.speculatedSuccessNonHeadEdges.add(successEdge);
        }
    }

    private void analyzeSuccessHeadEdges(@NonNull Partition partition) {
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Partition)partition)) {
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)headNode)) {
                Role edgeRole;
                if (!(edge instanceof SuccessEdge) || (edgeRole = partition.getRole(edge)) == null) continue;
                SuccessEdge successEdge = (SuccessEdge)edge;
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
                if (edgeRole.isChecked()) {
                    if (!(targetNode instanceof SuccessNode)) continue;
                    this.checkedSuccessHeadEdges.add(successEdge);
                    continue;
                }
                if (!edgeRole.isRealized() || !(targetNode instanceof SuccessNode)) continue;
                this.realizedSuccessHeadEdges.add(successEdge);
            }
        }
    }

    public String toString() {
        return this.partition.toString();
    }

    protected static abstract class AbstractCheckedConditionVisitor
    implements CheckedConditionVisitor<Boolean> {
        protected AbstractCheckedConditionVisitor() {
        }

        @Override
        public @NonNull Boolean visitCastEdgeCheckedCondition(@NonNull CastEdgeCheckedCondition castEdgeCheckedCondition) {
            return false;
        }

        @Override
        public @NonNull Boolean visitCastInitializerCheckedCondition(@NonNull CastInitializerCheckedCondition castInitializerCheckedCondition) {
            return false;
        }

        @Override
        public @NonNull Boolean visitConstantTargetCheckedCondition(@NonNull ConstantTargetCheckedCondition constantTargetCheckedCondition) {
            return false;
        }

        @Override
        public @NonNull Boolean visitMultipleEdgeCheckedCondition(@NonNull MultipleEdgeCheckedCondition multipleEdgeCheckedCondition) {
            return false;
        }

        @Override
        public @NonNull Boolean visitNavigableEdgeCheckedCondition(@NonNull NavigableEdgeCheckedCondition navigableEdgeCheckedCondition) {
            return false;
        }

        @Override
        public @NonNull Boolean visitNonNullInitializerCheckedCondition(@NonNull NonNullInitializerCheckedCondition nonNullInitializerCheckedCondition) {
            return false;
        }

        @Override
        public @NonNull Boolean visitPredicateEdgeCheckedCondition(@NonNull PredicateEdgeCheckedCondition predicateEdgeCheckedCondition) {
            return false;
        }

        @Override
        public @NonNull Boolean visitSpeculationCheckedCondition(@NonNull SpeculationCheckedCondition speculationCheckedCondition) {
            return false;
        }
    }
}

