/**
 * This file was copied and re-packaged automatically by
 *     org.eclipse.qvtd.doc.miniocl.build.MiniOCLBuildEverything
 * from 
 *     ..\..\plugins\org.eclipse.qvtd.runtime\src\org\eclipse\qvtd\runtime\evaluation\Connection.java
 *
 * Do not edit this file. 
 */
/*******************************************************************************
 * Copyright (c) 2016, 2019 Willink Transformations and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 *******************************************************************************/
package org.eclipse.qvtd.doc.minioclcs.xtext.tx;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.Nameable;

/**
 * A Connection maintains the values between one or more sources, typically Mappings, that
 * invoke append() and one or more consumers that consume each value.
 *
 * The AbstractConnection may optionally enforce uniqueness on the internal values where the overall
 * application is unable to do so automatically.
 *
 * Incremental update is supported by a revoke() or an append(), or a replace() of an appended value.
 *
 * @noimplement clients should derive from AbstractConnection
 */
public interface Connection extends ExecutionVisitable, Nameable
{
	public interface Incremental extends Connection
	{
		void check();

		/**
		 * Remove the revoked entries and update the internal indexes accordingly.
		 */
		void cleanup();

		void consume(int elementIndex, @NonNull Invocation mapping);

		@NonNull Iterable<@NonNull InvocationConstructor> getAppenders();

		/**
		 * Remove, inverse append, the old anElement.
		 *
		 * If the old value is a multiple value in a unique value connection, the multi-value count is decremented.
		 *
		 * Otherwise the old value is removed, its consumingInvocations are revoked
		 * so that their appends are also revoked.
		 */
		void removeElement(@NonNull Object anElement);

		/**
		 * Replace the old value at connectionKey by newValue.
		 *
		 * If the old value is a multiple value in a unique value connection, the multi-value count is decremented
		 * and a new entry created for the newValue by delegating to append to enforce uniqueness of the newValue.
		 *
		 * Otherwise the old value is removed, its consumingInvocations are invalidated
		 * so that they recompute with the newValue which replaces the old.
		 */
		@NonNull Object replace(@NonNull Object connectionKey, @NonNull Object newValue);

		/**
		 * Revoke, inverse append, the old value at connectionKey.
		 *
		 * If the old value is a multiple value in a unique value connection, the multi-value count is decremented.
		 *
		 * Otherwise the old value is removed, its consumingInvocations are revoked
		 * so that their appends are also revoked.
		 */
		void revoke(@NonNull Object connectionKey);

		void revokeConsumer(@NonNull Object anElement, Invocation.@NonNull Incremental invocation);
	}

	void addAppender(@NonNull InvocationConstructor appendingInvoker);

	boolean addConsumer(@NonNull InvocationConstructor consumingInvoker);

	/**
	 * Append anElement to the contents, enforcing uniqueness if necessary, and waking up the overall
	 * connection manager to schedule a propagate() to consumers when convenient.
	 *
	 * Return the new entry.
	 */
	@NonNull Object appendElement(@NonNull Object anElement);

	int debugGetSize();

	int getCapacity();

	@NonNull Iterable<@NonNull InvocationConstructor> getConsumers();

	@Nullable Object getValue(int i);

	int getValues();

	//	boolean isQueued();

	void propagate();

	void queue();

	<@NonNull T> @NonNull Iterable<T> typedIterable(Class<T> elementClass);
}