/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtimperative.tests;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.completeocl.validation.CompleteOCLEObjectValidator;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.QVTiCompilerChain;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePackage;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.BasicQVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.runtime.evaluation.ModeFactory;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.qvtd.xtext.qvtimperative.tests.ManualRDBMSNormalizer;
import org.eclipse.qvtd.xtext.qvtimperative.tests.SimpleRDBMSNormalizer;
import org.eclipse.xtext.util.EmfFormatter;
import org.junit.Before;
import org.junit.Test;

public class QVTiInterpreterTests
extends LoadTestCase {
    public static void assertSameModel(Resource expectedResource, Resource actualResource) throws IOException, InterruptedException {
        String expected = EmfFormatter.listToStr((List)expectedResource.getContents());
        String actual = EmfFormatter.listToStr((List)actualResource.getContents());
        QVTiInterpreterTests.assertEquals((String)expected, (String)actual);
    }

    protected void assertLoadable(@NonNull URI asURI) throws Exception {
        this.assertLoadable(this.getTestProject(), asURI);
    }

    protected void assertLoadable(@NonNull TestProject testProject, @NonNull URI asURI) throws Exception {
        ProjectManager projectManager = this.getTestProjectManager();
        OCL ocl = OCL.newInstance((ProjectManager)projectManager);
        ResourceSet asResourceSet = ocl.getMetamodelManager().getASResourceSet();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            OCLstdlib.install();
            ((OCLInternal)ocl).getMetamodelManager().getASmetamodel();
        }
        Resource resource = asResourceSet.getResource(asURI, true);
        assert (resource != null);
        EcoreUtil.resolveAll((Resource)resource);
        QVTiInterpreterTests.assertNoUnresolvedProxies((String)"Loading", (Resource)resource);
        QVTiInterpreterTests.assertNoResourceErrors((String)"Loading", (Resource)resource);
        ocl.dispose();
    }

    protected @NonNull OCLInternal createOCL() {
        return QVTimperative.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    private @NonNull MyQVT createQVT(@NonNull String modelTestName, @NonNull URI txURI, @NonNull ModeFactory modeFactory) throws Exception {
        ProjectManager testProjectManager = this.getTestProjectManager();
        URI intermediateFileNamePrefixURI = this.getTestURI(modelTestName);
        URI srcFileURI = this.getTestFileURI("test-src/");
        URI binFileURI = this.getTestFileURI("test-bin/");
        return new MyQVT(testProjectManager, this.getTestProject(), this.getTestBundleURI(), txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI, modeFactory);
    }

    @Before
    public void setUp() throws Exception {
        XtextCompilerUtil.doQVTimperativeSetup();
        super.setUp();
    }

    @Test
    public void testQVTiInterpreter_Graph2GraphMinimal() throws Exception {
        URI txURI = this.getModelsURI("Graph2GraphMinimal/Graph2GraphMinimal.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        URI inputURI = this.getModelsURI("Graph2GraphMinimal/SimpleGraph.xmi");
        URI outputURI = this.getTestURI("Graph2GraphMinimal.xmi");
        URI traceURI = this.getTestURI("Graph2Graph.xmi");
        MyQVT myQVT = this.createQVT("Graph2GraphMinimal", txURI, ModeFactory.LAZY);
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        BasicQVTiExecutor testEvaluator = myQVT.createInterpretedExecutor(iTransformation);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        myQVT.addInputURI("upperGraph", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("lowerGraph", outputURI);
        myQVT.addOutputURI("middle", traceURI);
        myQVT.saveModels(null);
        myQVT.saveExecutionGraph(this.getTestURI("Graph2GraphMinimal_LAZY.graphml"));
        myQVT.checkOutput(outputURI, this.getModelsURI("Graph2GraphMinimal/Graph2GraphMinimalValidate.xmi"), null);
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_Graph2GraphHierarchical() throws Exception {
        URI txURI = this.getModelsURI("Graph2GraphHierarchical/Graph2GraphHierarchical.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        URI inputURI = this.getModelsURI("Graph2GraphMinimal/SimpleGraph.xmi");
        URI outputURI = this.getTestURI("Graph2GraphHierarchical.xmi");
        URI traceURI = this.getTestURI("Graph2Graph.xmi");
        MyQVT myQVT = this.createQVT("Graph2GraphHierarchical", txURI, ModeFactory.LAZY);
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        BasicQVTiExecutor testEvaluator = myQVT.createInterpretedExecutor(iTransformation);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        myQVT.addInputURI("upperGraph", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("lowerGraph", outputURI);
        myQVT.addOutputURI("middle", traceURI);
        myQVT.saveModels(null);
        myQVT.saveExecutionGraph(this.getTestURI("Graph2GraphMinimal_LAZY.graphml"));
        myQVT.checkOutput(outputURI, this.getModelsURI("Graph2GraphHierarchical/Graph2GraphHierarchicalValidate.xmi"), null);
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_Graph2GraphHierarchicalLoad() throws Exception {
        URI asURI = this.getModelsURI("Graph2GraphHierarchical/Graph2GraphHierarchical.ref.qvtias");
        this.assertLoadable(asURI);
    }

    @Test
    public void testQVTiInterpreter_HSV2HSL() throws Exception {
        URI txURI = this.getModelsURI("HSV2HSL/HSV2HSL.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        URI inputURI = this.getModelsURI("HSV2HSL/HSVNode.xmi");
        URI outputURI = this.getTestURI("HSLNode.xmi");
        URI traceURI = this.getTestURI("HSV2HSLNode.xmi");
        MyQVT myQVT = this.createQVT("HSV2HSL", txURI, ModeFactory.LAZY);
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        BasicQVTiExecutor testEvaluator = myQVT.createInterpretedExecutor(iTransformation);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        myQVT.addInputURI("hsv", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("hsl", outputURI);
        myQVT.addOutputURI("middle", traceURI);
        myQVT.saveModels(null);
        myQVT.saveExecutionGraph(this.getTestURI("HSV2HSL_LAZY.graphml"));
        myQVT.checkOutput(outputURI, this.getModelsURI("HSV2HSL/HSLNodeValidate.xmi"), null);
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_Tree2TallTreeIncremental() throws Exception {
        URI txURI = this.getModelsURI("Tree2TallTree/Tree2TallTree.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        URI inputURI = this.getModelsURI("Tree2TallTree/samples/Tree.xmi");
        URI outputURI = this.getTestURI("TallTree.xmi");
        URI traceURI = this.getTestURI("Tree2TallTree.xmi");
        MyQVT myQVT = this.createQVT("Tree2TallTree", txURI, ModeFactory.INCREMENTAL);
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        BasicQVTiExecutor testEvaluator = myQVT.createInterpretedExecutor(iTransformation);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        myQVT.addInputURI("tree", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("talltree", outputURI);
        myQVT.addOutputURI("tree2talltree", traceURI);
        myQVT.saveModels(null);
        myQVT.writeExecutionGraphMLfile(this.getTestURI("Tree2TallTree-execution.graphml"));
        myQVT.saveExecutionGraph(this.getTestURI("Tree2TallTree_INCREMENTAL.graphml"));
        myQVT.checkOutput(outputURI, this.getModelsURI("Tree2TallTree/samples/TallTreeValidate.xmi"), null);
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_Tree2TallTreeLazy() throws Exception {
        URI txURI = this.getModelsURI("Tree2TallTree/Tree2TallTree.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        URI inputURI = this.getModelsURI("Tree2TallTree/samples/Tree.xmi");
        URI outputURI = this.getTestURI("TallTree.xmi");
        URI traceURI = this.getTestURI("Tree2TallTree.xmi");
        MyQVT myQVT = this.createQVT("Tree2TallTree", txURI, ModeFactory.LAZY);
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        BasicQVTiExecutor testEvaluator = myQVT.createInterpretedExecutor(iTransformation);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        myQVT.addInputURI("tree", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("talltree", outputURI);
        myQVT.addOutputURI("tree2talltree", traceURI);
        myQVT.saveModels(null);
        myQVT.saveExecutionGraph(this.getTestURI("Tree2TallTree_LAZY.graphml"));
        myQVT.checkOutput(outputURI, this.getModelsURI("Tree2TallTree/samples/TallTreeValidate.xmi"), null);
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_ManualUML2RDBMS() throws Exception {
        URI txURI = this.getModelsURI("ManualUML2RDBMS/ManualUML2RDBMS.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        URI inputURI = this.getModelsURI("ManualUML2RDBMS/ManualUMLPeople.xmi");
        URI outputURI = this.getTestURI("ManualRDBMSPeople.xmi");
        URI traceURI = this.getTestURI("ManualUML2RDBMS.xmi");
        MyQVT myQVT = this.createQVT("ManualUML2RDBMS", txURI, ModeFactory.LAZY);
        TestUtil.doCompleteOCLSetup();
        URI oclURI = this.getResourceURI("org.eclipse.qvtd.pivot.qvtimperative/model/QVTimperative.ocl");
        CompleteOCLEObjectValidator completeOCLEObjectValidator2 = new CompleteOCLEObjectValidator((EPackage)ClassUtil.nonNullState((Object)QVTimperativePackage.eINSTANCE), oclURI, (EnvironmentFactory)myQVT.getEnvironmentFactory());
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        BasicQVTiExecutor testEvaluator = myQVT.createInterpretedExecutor(iTransformation);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        myQVT.addInputURI("uml", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("rdbms", outputURI);
        myQVT.addOutputURI("middle", traceURI);
        myQVT.saveModels(null);
        myQVT.saveExecutionGraph(this.getTestURI("ManualUML2RDBMS_LAZY.graphml"));
        myQVT.checkOutput(outputURI, this.getModelsURI("ManualUML2RDBMS/ManualRDBMSPeopleValidate.xmi"), ManualRDBMSNormalizer.INSTANCE);
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_SimpleUML2RDBMS() throws Exception {
        URI txURI = this.getModelsURI("SimpleUML2RDBMS/SimpleUML2RDBMS.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        URI inputURI = this.getModelsURI("SimpleUML2RDBMS/SimpleUMLPeople.xmi");
        URI outputURI = this.getTestURI("SimpleRDBMSPeople.xmi");
        URI traceURI = this.getTestURI("SimpleUML2RDBMS.xmi");
        MyQVT myQVT = this.createQVT("SimpleUML2RDBMS", txURI, ModeFactory.LAZY);
        TestUtil.doCompleteOCLSetup();
        URI oclURI = this.getResourceURI("org.eclipse.qvtd.pivot.qvtimperative/model/QVTimperative.ocl");
        QVTiEnvironmentFactory environmentFactory = myQVT.getEnvironmentFactory();
        CompleteOCLEObjectValidator completeOCLEObjectValidator2 = new CompleteOCLEObjectValidator((EPackage)ClassUtil.nonNullState((Object)QVTimperativePackage.eINSTANCE), oclURI, (EnvironmentFactory)environmentFactory);
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        BasicQVTiExecutor testEvaluator = myQVT.createInterpretedExecutor(iTransformation);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        myQVT.addInputURI("uml", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("rdbms", outputURI);
        myQVT.addOutputURI("middle", traceURI);
        myQVT.saveModels(null);
        myQVT.saveExecutionGraph(this.getTestURI("SimpleUML2RDBMS_LAZY.graphml"));
        myQVT.checkOutput(outputURI, this.getModelsURI("SimpleUML2RDBMS/SimpleRDBMSPeopleValidate.xmi"), SimpleRDBMSNormalizer.INSTANCE);
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_ClassesCS2AS_bug456900() throws Exception {
        URI txURI = this.getModelsURI("ClassesCS2AS/bug456900/ClassesCS2AS.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        URI inputURI = this.getModelsURI("ClassesCS2AS/bug456900/example_input.xmi");
        URI outputURI = this.getTestURI("example_output.xmi");
        MyQVT myQVT = this.createQVT("ClassesCS2AS", txURI, ModeFactory.LAZY);
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        BasicQVTiExecutor testEvaluator = myQVT.createInterpretedExecutor(iTransformation);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        myQVT.addInputURI("leftCS", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("rightAS", outputURI);
        myQVT.saveModels(null);
        myQVT.saveExecutionGraph(this.getTestURI("ClassesCS2AS_LAZY.graphml"));
        myQVT.checkOutput(outputURI, this.getModelsURI("ClassesCS2AS/bug456900/example_output_ref.xmi"), null);
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_ClassesCS2AS_bug457239() throws Exception {
        TestUtil.doCompleteOCLSetup();
        URI txURI = this.getModelsURI("ClassesCS2AS/bug457239/ClassesCS2AS.qvti");
        URI txASURI = this.getTestURIWithExtension(txURI, "qvtias");
        URI inputURI = this.getModelsURI("ClassesCS2AS/bug457239/example_input.xmi");
        URI outputURI = this.getTestURI("example_output.xmi");
        MyQVT myQVT = this.createQVT("ClassesCS2AS", txURI, ModeFactory.LAZY);
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        BasicQVTiExecutor testEvaluator = myQVT.createInterpretedExecutor(iTransformation);
        testEvaluator.saveTransformation(txASURI, null);
        this.assertLoadable(txASURI);
        myQVT.addInputURI("leftCS", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("rightAS", outputURI);
        myQVT.saveModels(null);
        myQVT.saveExecutionGraph(this.getTestURI("ClassesCS2AS_LAZY.graphml"));
        myQVT.checkOutput(outputURI, this.getModelsURI("ClassesCS2AS/bug457239/example_output_ref.xmi"), null);
        myQVT.dispose();
    }

    @Test
    public void testQVTiInterpreter_ClassesCS2AS_bug457239b() throws Exception {
        TestUtil.doCompleteOCLSetup();
        URI txURI = this.getModelsURI("ClassesCS2AS/bug457239/ClassesCS2ASv2_AS.qvtias");
        URI inputURI = this.getModelsURI("ClassesCS2AS/bug457239/example_input.xmi");
        URI outputURI = this.getTestURI("example_output.xmi");
        MyQVT myQVT = this.createQVT("ClassesCS2AS", txURI, ModeFactory.LAZY);
        ImperativeTransformation iTransformation = myQVT.loadTransformation();
        myQVT.createInterpretedExecutor(iTransformation);
        myQVT.addInputURI("leftCS", inputURI);
        QVTiInterpreterTests.assertTrue((boolean)myQVT.executeTransformation());
        myQVT.addOutputURI("rightAS", outputURI);
        myQVT.saveModels(null);
        myQVT.checkOutput(outputURI, this.getModelsURI("ClassesCS2AS/bug457239/exampleV2_output_ref.xmi"), null);
        myQVT.dispose();
    }

    protected class MyQVT
    extends AbstractTestQVT {
        private @NonNull ModeFactory modeFactory;

        public MyQVT(@NonNull ProjectManager projectManager, @NonNull TestProject testProject, @NonNull URI testBundleURI, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull URI srcFileURI, @NonNull URI binFileURI, ModeFactory modeFactory) throws IOException {
            super(projectManager, testProject, testBundleURI, txURI, intermediateFileNamePrefixURI, srcFileURI, binFileURI);
            this.modeFactory = modeFactory;
        }

        protected @NonNull AbstractCompilerChain createCompilerChain(@NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull CompilerOptions options) {
            return new QVTiCompilerChain(this.getEnvironmentFactory(), txURI, intermediateFileNamePrefixURI, (CompilerOptions)this.createCompilerOptions());
        }

        protected @NonNull BasicQVTiExecutor createInterpretedExecutor(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull ImperativeTransformation transformation) throws Exception {
            return new BasicQVTiExecutor(environmentFactory, transformation, this.modeFactory);
        }

        protected @NonNull String getBasePrefix() {
            return "org.eclipse.qvtd.xtext.qvtimperative.tests";
        }

        protected @NonNull ProjectManager getTestProjectManager(@NonNull String pathFromCurrentWorkingDirectoryToFileSystem) throws Exception {
            return QVTiInterpreterTests.this.getTestProjectManager(pathFromCurrentWorkingDirectoryToFileSystem);
        }

        public @NonNull ImperativeTransformation loadTransformation() throws IOException {
            QVTiEnvironmentFactory environmentFactory = this.getEnvironmentFactory();
            return QVTimperativeUtil.loadTransformation((QVTbaseEnvironmentFactory)environmentFactory, (URI)this.txURI, (boolean)environmentFactory.keepDebug());
        }

        public void saveExecutionGraph(@NonNull URI graphmlURI) throws Exception, IOException {
            URIConverter uriConverter = this.getEnvironmentFactory().getResourceSet().getURIConverter();
            GraphMLBuilder s = new GraphMLBuilder();
            OutputStream outputStream = uriConverter.createOutputStream(graphmlURI);
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            ((Writer)writer).append(s.toString());
            ((Writer)writer).close();
        }

        public void writeExecutionGraphMLfile(@NonNull URI graphmlURI) {
            URIConverter uriConverter = this.getEnvironmentFactory().getResourceSet().getURIConverter();
            try {
                OutputStream outputStream = uriConverter.createOutputStream(graphmlURI);
                GraphMLStringBuilder s = new GraphMLStringBuilder();
                ((BasicQVTiExecutor)this.getExecutor()).createGraph((GraphStringBuilder)s);
                outputStream.write(s.toString().getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

