/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.CoreVariable2Variable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.IteratorVariable2Variable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.LetVariable2Variable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.RelationVariable2Variable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.ThisVariable2Variable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.Variable2Variable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.VariablesAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

class Variables2Variables
extends VariablesAnalysis {
    protected final @NonNull RelationalTransformation2TracePackage relationalTransformation2tracePackage;
    protected final @NonNull CoreDomain cEnforcedDomain;
    protected final @NonNull Mapping cMapping;
    protected final @NonNull Transformation cTransformation;
    protected final @NonNull BottomPattern cMiddleBottomPattern;
    protected final @NonNull GuardPattern cMiddleGuardPattern;
    protected final @Nullable VariableDeclaration cMiddleVariable;
    protected final @NonNull Variable rThisVariable;
    protected final @NonNull Variable cThisVariable;
    private @NonNull Map<@NonNull String, @NonNull Variable2Variable> name2originator = new HashMap<String, Variable2Variable>();
    private final @NonNull Map<@NonNull VariableDeclaration, @NonNull Variable2Variable> rVariable2analysis = new HashMap<VariableDeclaration, Variable2Variable>();
    private final @NonNull Map<@NonNull VariableDeclaration, @NonNull Variable2Variable> cVariable2analysis = new HashMap<VariableDeclaration, Variable2Variable>();

    public static @NonNull Map<@NonNull Variable, @NonNull TemplateExp> gatherBoundVariables(@NonNull Element asRoot) {
        HashMap<@NonNull Variable, @NonNull TemplateExp> boundVariables = new HashMap<Variable, TemplateExp>();
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            if (!(eObject instanceof TemplateExp)) continue;
            Variable bindsTo = QVTrelationUtil.getBindsTo((TemplateExp)((TemplateExp)eObject));
            TemplateExp oldTemplateExp = boundVariables.put(bindsTo, (TemplateExp)eObject);
            assert (oldTemplateExp == null);
        }
        return boundVariables;
    }

    public static @Nullable Map<@NonNull Variable, @NonNull List<@NonNull CollectionTemplateExp>> gatherMemberVariables(@NonNull Element asRoot) {
        HashMap<@NonNull Variable, @NonNull ArrayList<@NonNull E>> memberVariable2collectionTemplateExps = null;
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            if (!(eObject instanceof CollectionTemplateExp)) continue;
            CollectionTemplateExp collectionTemplateExp = (CollectionTemplateExp)eObject;
            for (OCLExpression member : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)collectionTemplateExp)) {
                ArrayList<CollectionTemplateExp> collectionTemplateExps;
                if (!(member instanceof VariableExp)) continue;
                Variable memberVariable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)member));
                if (memberVariable2collectionTemplateExps == null) {
                    memberVariable2collectionTemplateExps = new HashMap();
                }
                if ((collectionTemplateExps = (ArrayList<CollectionTemplateExp>)memberVariable2collectionTemplateExps.get(memberVariable)) == null) {
                    collectionTemplateExps = new ArrayList<CollectionTemplateExp>();
                    memberVariable2collectionTemplateExps.put(memberVariable, collectionTemplateExps);
                }
                if (collectionTemplateExps.contains(collectionTemplateExp)) continue;
                collectionTemplateExps.add(collectionTemplateExp);
            }
        }
        return memberVariable2collectionTemplateExps;
    }

    public static void gatherReferredVariables(@NonNull Set<@NonNull Variable> referredVariables, @NonNull Iterable<@NonNull ? extends Element> asRoots) {
        for (Element element : asRoots) {
            Variables2Variables.gatherReferredVariables(referredVariables, element);
        }
    }

    public static void gatherReferredVariables(@NonNull Set<@NonNull Variable> referredVariables, @NonNull Element asRoot) {
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            Variable rest;
            if (eObject instanceof VariableExp) {
                VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                if (!(referredVariable instanceof Variable)) continue;
                referredVariables.add((Variable)referredVariable);
                continue;
            }
            if (eObject instanceof Variable) {
                referredVariables.add((Variable)eObject);
                continue;
            }
            if (!(eObject instanceof TemplateExp)) continue;
            Variable bindsTo = ((TemplateExp)eObject).getBindsTo();
            if (bindsTo != null) {
                referredVariables.add(bindsTo);
            }
            if (!(eObject instanceof CollectionTemplateExp) || (rest = ((CollectionTemplateExp)eObject).getRest()) == null || rest.isIsImplicit()) continue;
            referredVariables.add(rest);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void gatherReferredVariablesWithTypedModels(@NonNull Map<@NonNull Variable, @Nullable TypedModel> referredVariable2typedModel, @NonNull Element asRoot) {
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            Variable rest;
            if (eObject instanceof VariableExp) {
                VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                if (!(referredVariable instanceof Variable)) continue;
                EObject eContainer = eObject.eContainer();
                if (eContainer instanceof RelationCallExp) {
                    RelationCallExp relationCallExp = (RelationCallExp)eContainer;
                    int argument = relationCallExp.getArgument().indexOf((Object)eObject);
                    assert (argument >= 0);
                    Relation referredRelation = (Relation)ClassUtil.nonNullState((Object)relationCallExp.getReferredRelation());
                    @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)referredRelation);
                    assert (argument < rootVariables.size());
                    Variable rootVariable = (Variable)rootVariables.get(argument);
                    RelationDomain relationDomain = QVTrelationUtil.getRootVariableDomain((VariableDeclaration)rootVariable);
                    Variables2Variables.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, (Variable)referredVariable, relationDomain.getTypedModel());
                    continue;
                }
                Variables2Variables.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, (Variable)referredVariable, null);
                continue;
            }
            if (eObject instanceof Variable) {
                Variables2Variables.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, (Variable)eObject, null);
                continue;
            }
            if (!(eObject instanceof TemplateExp)) continue;
            Variable bindsTo = ((TemplateExp)eObject).getBindsTo();
            if (bindsTo != null) {
                Variables2Variables.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, bindsTo, null);
            }
            if (!(eObject instanceof CollectionTemplateExp) || (rest = ((CollectionTemplateExp)eObject).getRest()) == null || rest.isIsImplicit()) continue;
            Variables2Variables.gatherReferredVariablesWithTypedModelsAdd(referredVariable2typedModel, rest, null);
        }
    }

    private static void gatherReferredVariablesWithTypedModelsAdd(@NonNull Map<@NonNull Variable, @Nullable TypedModel> referredVariable2typedModel, @NonNull Variable variable, @Nullable TypedModel rTypedModel) {
        if (rTypedModel != null) {
            TypedModel oldTypedModel = referredVariable2typedModel.put(variable, rTypedModel);
            assert (oldTypedModel == rTypedModel || oldTypedModel == null);
        } else if (!referredVariable2typedModel.containsKey(variable)) {
            referredVariable2typedModel.put(variable, null);
        }
    }

    public static @Nullable Map<@NonNull Variable, @NonNull CollectionTemplateExp> gatherRestVariables(@NonNull Element asRoot) {
        HashMap<@NonNull Variable, @NonNull CollectionTemplateExp> restVariable2collectionTemplateExp = null;
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            CollectionTemplateExp collectionTemplateExp;
            Variable rest;
            if (!(eObject instanceof CollectionTemplateExp) || (rest = (collectionTemplateExp = (CollectionTemplateExp)eObject).getRest()) == null) continue;
            if (restVariable2collectionTemplateExp == null) {
                restVariable2collectionTemplateExp = new HashMap<Variable, CollectionTemplateExp>();
            }
            CollectionTemplateExp oldCollectionTemplateExp = restVariable2collectionTemplateExp.put(rest, collectionTemplateExp);
            assert (oldCollectionTemplateExp == null);
        }
        return restVariable2collectionTemplateExp;
    }

    public static @NonNull Set<@NonNull Variable> getMiddleDomainVariables(@NonNull Relation rRelation) {
        HashSet<@NonNull Variable> rSomeDomainVariables = new HashSet<Variable>();
        HashSet<@NonNull Variable> rMiddleDomainVariables = new HashSet<Variable>();
        for (RelationDomain rDomain : QVTrelationUtil.getOwnedDomains((Relation)rRelation)) {
            HashSet<@NonNull Variable> rThisDomainVariables = new HashSet<Variable>();
            Variables2Variables.gatherReferredVariables(rThisDomainVariables, (Element)rDomain);
            for (Variable rVariable : rThisDomainVariables) {
                if (rSomeDomainVariables.add(rVariable)) continue;
                rMiddleDomainVariables.add(rVariable);
            }
        }
        return rMiddleDomainVariables;
    }

    public Variables2Variables(@NonNull RelationAnalysis relationAnalysis, @NonNull RelationDomain rEnforcedDomain, @NonNull CoreDomain cEnforcedDomain, @Nullable Type traceClass, boolean isWhened, boolean isWhered) throws CompilerChainException {
        super(relationAnalysis, isWhened, isWhered);
        TransformationAnalysis transformationAnalysis = relationAnalysis.getTransformationAnalysis();
        QVTr2QVTc qvtr2qvtc = transformationAnalysis.getQVTr2QVTc();
        this.relationalTransformation2tracePackage = qvtr2qvtc.getRelationalTransformation2TracePackage(transformationAnalysis);
        this.cEnforcedDomain = cEnforcedDomain;
        this.cMapping = (Mapping)ClassUtil.nonNullState((Object)QVTcoreUtil.getContainingMapping((EObject)cEnforcedDomain));
        this.cTransformation = (Transformation)ClassUtil.nonNullState((Object)this.cMapping.getTransformation());
        this.cMiddleBottomPattern = (BottomPattern)ClassUtil.nonNullState((Object)this.cMapping.getBottomPattern());
        this.cMiddleGuardPattern = (GuardPattern)ClassUtil.nonNullState((Object)this.cMapping.getGuardPattern());
        this.cMiddleVariable = traceClass != null ? (relationAnalysis.traceIsRealized() ? this.addCoreRealizedVariable("trace", traceClass) : this.addCoreGuardVariable("trace", traceClass)) : null;
        this.rThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)this.environmentFactory.getStandardLibrary(), (Transformation)QVTbaseUtil.getContainingTransformation((EObject)rEnforcedDomain));
        this.cThisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)this.environmentFactory.getStandardLibrary(), (Transformation)this.cTransformation);
        ThisVariable2Variable thisVariableAnalysis = new ThisVariable2Variable(this, this.rThisVariable, this.cThisVariable);
        this.addVariableAnalysis(thisVariableAnalysis);
    }

    protected void addConditionPredicate(@NonNull CorePattern cCorePattern, @NonNull OCLExpression cLeftExpression, @NonNull OCLExpression cRightExpression) throws CompilerChainException {
        OperationCallExp eTerm = this.createOperationCallExp(cLeftExpression, "=", new OCLExpression[]{cRightExpression});
        this.addPredicate(cCorePattern, (OCLExpression)eTerm);
    }

    public @NonNull Variable addCoreGuardVariable(@NonNull String name, @NonNull Type type) throws CompilerChainException {
        CoreVariable2Variable analysis = new CoreVariable2Variable(this, name, type, null);
        Variable cVariable = analysis.getCoreVariable();
        this.addVariableAnalysis(analysis);
        this.cMiddleGuardPattern.getVariable().add((Object)cVariable);
        return cVariable;
    }

    public @NonNull RealizedVariable addCoreRealizedVariable(@NonNull String name, @NonNull Type type) throws CompilerChainException {
        CoreVariable2Variable analysis = new CoreVariable2Variable(this, name, type);
        RealizedVariable cVariable = analysis.getCoreRealizedVariable();
        this.addVariableAnalysis(analysis);
        this.cMiddleBottomPattern.getRealizedVariable().add((Object)cVariable);
        return cVariable;
    }

    public @NonNull Variable addCoreVariable(@NonNull String name, @NonNull OCLExpression mMember) throws CompilerChainException {
        CoreVariable2Variable analysis = new CoreVariable2Variable(this, name, (Type)ClassUtil.nonNullState((Object)mMember.getType()), mMember);
        Variable cVariable = analysis.getCoreVariable();
        this.addVariableAnalysis(analysis);
        this.cMiddleGuardPattern.getVariable().add((Object)cVariable);
        return cVariable;
    }

    public void addNavigationAssignment(@NonNull Variable rTargetVariable, @NonNull Property targetProperty, @NonNull OCLExpression cExpression, @Nullable Boolean isPartial) throws CompilerChainException {
        this.getVariableAnalysis(rTargetVariable).addNavigationAssignment(targetProperty, cExpression, isPartial);
    }

    public void addNavigationPredicate(@NonNull CorePattern cCorePattern, @NonNull Variable rTargetVariable, @NonNull Property targetProperty, @NonNull OCLExpression cExpression) throws CompilerChainException {
        Variable cTargetVariable = this.getCoreVariable(rTargetVariable);
        NavigationCallExp cNavigationExp = this.createNavigationCallExp((OCLExpression)this.createVariableExp((VariableDeclaration)cTargetVariable), targetProperty);
        if (cExpression instanceof VariableExp) {
            this.addConditionPredicate(cCorePattern, cExpression, (OCLExpression)cNavigationExp);
        } else {
            this.addConditionPredicate(cCorePattern, (OCLExpression)cNavigationExp, cExpression);
        }
    }

    protected void addPredicate(@NonNull CorePattern cExpectedCorePattern, @NonNull OCLExpression cExpression) throws CompilerChainException {
        assert (this.cMapping == QVTcoreUtil.getContainingMapping((EObject)cExpectedCorePattern));
        QVTr2QVTc.SYNTHESIS.println("  addPredicate " + cExpression);
        HashSet<@NonNull Variable> cReferredVariables = new HashSet<Variable>();
        Variables2Variables.gatherReferredVariables(cReferredVariables, (Element)cExpression);
        boolean isGuard = true;
        boolean isMiddle = false;
        GuardPattern cReferredPattern = null;
        for (Variable cReferredVariable : cReferredVariables) {
            Variable2Variable analysis = this.cVariable2analysis.get(cReferredVariable);
            if (analysis == null) {
                isGuard = false;
                isMiddle = true;
                break;
            }
            CorePattern corePattern = analysis.getCorePattern();
            if (corePattern != null && !(corePattern instanceof GuardPattern)) {
                isGuard = false;
            }
            if (cReferredPattern == null) {
                cReferredPattern = corePattern;
                continue;
            }
            if (cReferredPattern == corePattern) continue;
            isMiddle = true;
        }
        if (isMiddle) {
            cReferredPattern = isGuard ? this.cMiddleGuardPattern : this.cMiddleBottomPattern;
        } else if (cReferredPattern != null) {
            Object object = cReferredPattern = isGuard ? cReferredPattern.getArea().getGuardPattern() : cReferredPattern.getArea().getBottomPattern();
        }
        if (cReferredPattern != null) {
            Predicate cPredicate = this.createPredicate(cExpression);
            cReferredPattern.getPredicate().add((Object)cPredicate);
        }
    }

    public @NonNull Variable addTraceNavigationAssignment(@NonNull Variable rVariable, boolean isOptional) throws CompilerChainException {
        boolean traceIsRealized = this.getRelationAnalysis().traceIsRealized();
        VariableDeclaration cMiddleRealizedVariable2 = this.getMiddleVariable();
        Variable cVariable = this.getCoreVariable(rVariable);
        Property cTargetProperty = this.relationalTransformation2tracePackage.basicGetTraceProperty(QVTrelationUtil.getType((TypedElement)cMiddleRealizedVariable2), (VariableDeclaration)rVariable);
        if (!isOptional && cTargetProperty == null) {
            cTargetProperty = this.relationalTransformation2tracePackage.basicGetTraceProperty(QVTrelationUtil.getType((TypedElement)cMiddleRealizedVariable2), (VariableDeclaration)rVariable);
        }
        assert (isOptional || cTargetProperty != null);
        if (cTargetProperty != null) {
            assert (!cTargetProperty.isIsMany() || cVariable.getType() instanceof CollectionType);
            VariableExp cSlotVariableExp = this.createVariableExp(cMiddleRealizedVariable2);
            VariableExp cExpression = this.createVariableExp((VariableDeclaration)cVariable);
            NavigationAssignment cAssignment = this.createNavigationAssignment((OCLExpression)cSlotVariableExp, cTargetProperty, (OCLExpression)cExpression, false);
            QVTr2QVTc.SYNTHESIS.println("  addPropertyAssignment " + cAssignment);
            this.assertNewAssignment(QVTcoreUtil.getOwnedAssignments((BottomPattern)this.cMiddleBottomPattern), cAssignment);
            this.cMiddleBottomPattern.getAssignment().add((Object)cAssignment);
        }
        return cVariable;
    }

    public @NonNull Variable addTraceNavigationAssignment(@NonNull Property cTargetProperty, @NonNull Variable cVariable) throws CompilerChainException {
        boolean traceIsRealized = this.getRelationAnalysis().traceIsRealized();
        assert (!cTargetProperty.isIsMany() || cVariable.getType() instanceof CollectionType);
        VariableDeclaration cMiddleRealizedVariable2 = this.getMiddleVariable();
        VariableExp cSlotVariableExp = this.createVariableExp(cMiddleRealizedVariable2);
        VariableExp cExpression = this.createVariableExp((VariableDeclaration)cVariable);
        NavigationAssignment cAssignment = this.createNavigationAssignment((OCLExpression)cSlotVariableExp, cTargetProperty, (OCLExpression)cExpression, false);
        QVTr2QVTc.SYNTHESIS.println("  addPropertyAssignment " + cAssignment);
        this.assertNewAssignment(QVTcoreUtil.getOwnedAssignments((BottomPattern)this.cMiddleBottomPattern), cAssignment);
        this.cMiddleBottomPattern.getAssignment().add((Object)cAssignment);
        return cVariable;
    }

    public @NonNull Variable addTraceNavigationPredicate(@NonNull Variable rVariable) throws CompilerChainException {
        VariableDeclaration cMiddleRealizedVariable2 = this.getMiddleVariable();
        Variable cVariable = this.getCoreVariable(rVariable);
        Property cTargetProperty = this.relationalTransformation2tracePackage.basicGetTraceProperty(QVTrelationUtil.getType((TypedElement)cMiddleRealizedVariable2), (VariableDeclaration)rVariable);
        assert (cTargetProperty != null);
        assert (!cTargetProperty.isIsMany() || cVariable.getType() instanceof CollectionType);
        VariableExp cSlotVariableExp = this.createVariableExp(cMiddleRealizedVariable2);
        VariableExp cRightExp = this.createVariableExp((VariableDeclaration)cVariable);
        NavigationCallExp cLeftExp = this.createNavigationCallExp((OCLExpression)cSlotVariableExp, cTargetProperty);
        this.addConditionPredicate((CorePattern)this.cMiddleGuardPattern, (OCLExpression)cLeftExp, (OCLExpression)cRightExp);
        return cVariable;
    }

    public void addVariableAnalysis(@NonNull Variable2Variable analysis) {
        Variable cVariable = analysis.getCoreVariable();
        this.cVariable2analysis.put((VariableDeclaration)cVariable, analysis);
        VariableDeclaration rVariable = analysis.getRelationVariable();
        if (rVariable != null) {
            this.rVariable2analysis.put(rVariable, analysis);
        }
    }

    public void assertNewAssignment(@NonNull Iterable<@NonNull Assignment> oldAssignments, @NonNull NavigationAssignment newAssignment) {
        OCLExpression newSlotExpression = newAssignment.getSlotExpression();
        if (newSlotExpression instanceof VariableExp) {
            VariableDeclaration newVariable = ((VariableExp)newSlotExpression).getReferredVariable();
            Property targetProperty = QVTcoreUtil.getTargetProperty((NavigationAssignment)newAssignment);
            for (Assignment oldAssignment : oldAssignments) {
                OCLExpression oldSlotExpression;
                if (!(oldAssignment instanceof NavigationAssignment) || QVTcoreUtil.getTargetProperty((NavigationAssignment)((NavigationAssignment)oldAssignment)) != targetProperty || !((oldSlotExpression = ((NavigationAssignment)oldAssignment).getSlotExpression()) instanceof VariableExp)) continue;
                VariableDeclaration oldVariable = ((VariableExp)oldSlotExpression).getReferredVariable();
                assert (oldVariable != newVariable) : "Repeated assignment: \"" + oldAssignment + "\", \"" + newAssignment + "\"";
            }
        }
    }

    protected @Nullable Variable2Variable basicGetVariableAnalysis(@NonNull Variable relationVariable) {
        return this.rVariable2analysis.get(relationVariable);
    }

    public void check() {
        for (Variable2Variable analysis : this.rVariable2analysis.values()) {
            analysis.check();
        }
    }

    public @NonNull Iterable<@NonNull Variable2Variable> getAnalyses() {
        return this.rVariable2analysis.values();
    }

    public @NonNull CoreDomain getCoreDomain(@NonNull TypedModel rTypedModel) {
        TypedModel cTypedModel = this.relationAnalysis.getTransformationAnalysis().getQVTr2QVTc().getCoreTypedModel(rTypedModel);
        return QVTcoreUtil.getDomain((Mapping)this.cMapping, (TypedModel)cTypedModel);
    }

    public @NonNull Variable getCoreThisVariable() {
        return this.cThisVariable;
    }

    public @NonNull Variable getCoreVariable(@NonNull Variable rVariable) {
        return this.getVariableAnalysis(rVariable).getCoreVariable();
    }

    protected @NonNull Variable2Variable getCoreVariableAnalysis(@NonNull VariableDeclaration coreVariable) {
        return (Variable2Variable)ClassUtil.nonNullState((Object)this.cVariable2analysis.get(coreVariable));
    }

    public @NonNull BottomPattern getMiddleBottomPattern() {
        return this.cMiddleBottomPattern;
    }

    public @NonNull GuardPattern getMiddleGuardPattern() {
        return this.cMiddleGuardPattern;
    }

    public @NonNull VariableDeclaration getMiddleVariable() {
        return (VariableDeclaration)ClassUtil.nonNullState((Object)this.cMiddleVariable);
    }

    public @NonNull RelationAnalysis getRelationAnalysis() {
        return this.relationAnalysis;
    }

    @Nullable OCLExpression getTemplateExp(@NonNull ObjectTemplateExp objectTemplateExp, @NonNull Parameter keyParameter) {
        Property property;
        String keyParameterName = keyParameter.getName();
        for (PropertyTemplateItem propertyTemplateItem : ClassUtil.nullFree((EList)objectTemplateExp.getPart())) {
            property = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)propertyTemplateItem);
            if (!ClassUtil.safeEquals((Object)property.getName(), (Object)keyParameterName)) continue;
            return propertyTemplateItem.getValue();
        }
        EObject eContainer = objectTemplateExp.eContainer();
        if (eContainer instanceof PropertyTemplateItem) {
            Property oppositeProperty;
            PropertyTemplateItem containingPropertyTemplateItem = (PropertyTemplateItem)eContainer;
            property = QVTrelationUtil.basicGetReferredProperty((PropertyTemplateItem)containingPropertyTemplateItem);
            Property property2 = oppositeProperty = property != null ? property.getOpposite() : null;
            if (oppositeProperty != null && ClassUtil.safeEquals((Object)oppositeProperty.getName(), (Object)keyParameterName)) {
                return containingPropertyTemplateItem.getObjContainer();
            }
        }
        return null;
    }

    public @NonNull String getUniqueVariableName(@NonNull String name, @NonNull Variable2Variable originator) {
        Variable2Variable oldOriginator = this.name2originator.get(name);
        if (oldOriginator != null) {
            assert (oldOriginator != originator);
            int i = 0;
            while (true) {
                String newName;
                if (!this.name2originator.containsKey(newName = String.valueOf(name) + "_" + i)) {
                    name = newName;
                    break;
                }
                ++i;
            }
        }
        this.name2originator.put(name, originator);
        return name;
    }

    protected @NonNull Variable2Variable getVariableAnalysis(@NonNull Variable relationVariable) {
        Variable2Variable analysis = this.rVariable2analysis.get(relationVariable);
        if (analysis == null) {
            assert (QVTbaseUtil.basicGetContainingTransformation((EObject)relationVariable) instanceof RelationalTransformation);
            analysis = relationVariable instanceof IteratorVariable ? new IteratorVariable2Variable(this, (IteratorVariable)relationVariable) : (relationVariable instanceof LetVariable ? new LetVariable2Variable(this, (LetVariable)relationVariable) : new RelationVariable2Variable(this, relationVariable));
            this.rVariable2analysis.put((VariableDeclaration)relationVariable, analysis);
        }
        return analysis;
    }

    public boolean isAbstract() {
        return this.relationAnalysis.getRelation().isIsAbstract();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull String> names = new ArrayList<String>(this.name2originator.keySet());
        Collections.sort(names);
        for (String name : names) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(String.valueOf(name) + " => ");
            Variable2Variable originator = this.name2originator.get(name);
            if (originator == this) continue;
            s.append(originator);
        }
        return s.toString();
    }
}

