/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.InvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Invocation2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceGroup;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractInvocationAnalysis
implements InvocationAnalysis {
    protected final @NonNull RelationAnalysis invokingRelationAnalysis;
    protected final @NonNull RelationAnalysis invokedRelationAnalysis;
    protected final @NonNull QVTrelationScheduleManager scheduleManager;
    protected final @NonNull Map<@NonNull VariableDeclaration, @NonNull Node> rootVariable2argumentNode = new HashMap<VariableDeclaration, Node>();

    public AbstractInvocationAnalysis(@NonNull RelationAnalysis invokingRelationAnalysis, @NonNull RelationAnalysis invokedRelationAnalysis) {
        this.invokingRelationAnalysis = invokingRelationAnalysis;
        this.invokedRelationAnalysis = invokedRelationAnalysis;
        this.scheduleManager = invokedRelationAnalysis.getScheduleManager();
    }

    @Override
    public void addBinding(@NonNull VariableDeclaration rootVariable, @NonNull Node argumentNode) {
        Node oldNode = this.rootVariable2argumentNode.put(rootVariable, argumentNode);
        assert (oldNode == null);
    }

    protected void createGlobalSuccessNodeAndEdge(@NonNull Node invokedNode) {
    }

    protected abstract @NonNull NavigableEdge createInputEdge(@NonNull Node var1, @NonNull Property var2, @NonNull Node var3);

    protected void createInvocationEdges(@NonNull Node invokedNode) {
        RelationAnalysis2MiddleType baseInvokedRuleAnalysis2MiddleType = this.getBaseInvokedRuleAnalysis2MiddleType();
        Relation baseInvokedRelation = this.getBaseInvokedRelation();
        for (VariableDeclaration rootVariable : this.rootVariable2argumentNode.keySet()) {
            Node argumentNode = this.rootVariable2argumentNode.get(rootVariable);
            assert (argumentNode != null);
            Variable overriddenRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)baseInvokedRelation, (VariableDeclaration)rootVariable);
            Property invocationProperty = baseInvokedRuleAnalysis2MiddleType.getTraceProperty((VariableDeclaration)overriddenRootVariable);
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)argumentNode);
            DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)classDatum);
            if (domainUsage.isOutput()) {
                this.createOutputEdge(invokedNode, invocationProperty, argumentNode);
                continue;
            }
            this.createInputEdge(invokedNode, invocationProperty, argumentNode);
        }
    }

    protected abstract @NonNull Node createInvocationNode(@NonNull Node var1);

    protected void createInvokingTraceEdge(@NonNull Node invokedNode, @NonNull Node invokingTraceNode) {
        RelationAnalysis2TraceGroup invokingRuleAnalysis2TraceGroup = this.invokingRelationAnalysis.getRuleAnalysis2TraceGroup();
        RelationAnalysis2TraceClass invokingRuleAnalysis2TraceClass = invokingRuleAnalysis2TraceGroup.getRuleAnalysis2TraceClass();
        Invocation2TraceProperty invokingInvocation2TraceProperty = invokingRuleAnalysis2TraceClass.getInvocation2TraceProperty(this);
        Property invocationTraceProperty = invokingInvocation2TraceProperty.getTraceProperty();
        boolean isPartial = this.scheduleManager.computeIsPartial(invokedNode, invocationTraceProperty);
        this.invokingRelationAnalysis.createRealizedNavigationEdge(invokingTraceNode, invocationTraceProperty, invokedNode, isPartial);
    }

    protected abstract @NonNull NavigableEdge createOutputEdge(@NonNull Node var1, @NonNull Property var2, @NonNull Node var3);

    protected @NonNull Relation getBaseInvokedRelation() {
        return QVTrelationUtil.getBaseRelation((Relation)this.invokedRelationAnalysis.getRule());
    }

    protected @NonNull RelationAnalysis2MiddleType getBaseInvokedRuleAnalysis2MiddleType() {
        Relation invokedRelation = this.invokedRelationAnalysis.getRule();
        Relation baseInvokedRelation = this.getBaseInvokedRelation();
        RelationAnalysis baseInvokedRelationAnalysis = this.scheduleManager.getRuleAnalysis((Rule)baseInvokedRelation);
        RelationAnalysis2TraceGroup baseInvokedRelationAnalysis2TraceGroup = baseInvokedRelationAnalysis.getRuleAnalysis2TraceGroup();
        RelationAnalysis2MiddleType baseInvokedRuleAnalysis2MiddleType = QVTrelationUtil.hasOverrides((Relation)invokedRelation) ? baseInvokedRelationAnalysis2TraceGroup.getRuleAnalysis2DispatchClass() : (this.isTop() ? baseInvokedRelationAnalysis2TraceGroup.getRuleAnalysis2TraceInterface() : baseInvokedRelationAnalysis2TraceGroup.getRuleAnalysis2InvocationInterface());
        return baseInvokedRuleAnalysis2MiddleType;
    }

    protected @NonNull ClassDatum getInvokedClassDatum() {
        TypedModel traceTypedModel = this.scheduleManager.getTraceTypedModel();
        RelationAnalysis2MiddleType invokedRelationAnalysis2InvocationInterface = this.getInvokedRelationAnalysis2InvocationInterface();
        Class invokedInvocationInterface = invokedRelationAnalysis2InvocationInterface.getMiddleClass();
        return this.scheduleManager.getClassDatum(traceTypedModel, invokedInvocationInterface);
    }

    @Override
    public @NonNull RelationAnalysis getInvokedRelationAnalysis() {
        return this.invokedRelationAnalysis;
    }

    protected @NonNull RelationAnalysis2MiddleType getInvokedRelationAnalysis2InvocationInterface() {
        RelationAnalysis2TraceGroup invokedRuleAnalysis2TraceGroup = this.invokedRelationAnalysis.getRuleAnalysis2TraceGroup();
        RelationAnalysis2TraceGroup invokedBaseRelationAnalysis2TraceGroup = invokedRuleAnalysis2TraceGroup.getBaseRelationAnalysis2TraceGroup();
        RelationAnalysis2MiddleType invokedRelationAnalysis2InvocationInterface = invokedBaseRelationAnalysis2TraceGroup.getRuleAnalysis2InvocationInterface();
        return invokedRelationAnalysis2InvocationInterface;
    }

    @Override
    public @NonNull RelationAnalysis getInvokingRelationAnalysis() {
        return this.invokingRelationAnalysis;
    }

    protected boolean isMatched() {
        for (VariableDeclaration rootVariable : this.rootVariable2argumentNode.keySet()) {
            Node argumentNode = this.rootVariable2argumentNode.get(rootVariable);
            assert (argumentNode != null);
            if (argumentNode.isMatched()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void synthesizeInvocationNodes(@NonNull Node invokingTraceNode) {
        Node invokedNode = this.createInvocationNode(invokingTraceNode);
        this.createInvokingTraceEdge(invokedNode, invokingTraceNode);
        this.createGlobalSuccessNodeAndEdge(invokedNode);
        this.createInvocationEdges(invokedNode);
    }
}

