/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class RuleHeadAnalysis
extends HeadAnalysis {
    public static final @NonNull TracingOption RULE_HEAD_NODE_GROUPS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/headNodeGroups");

    public static @NonNull Iterable<@NonNull Node> computeRuleHeadNodes(@NonNull ScheduleManager scheduleManager, @NonNull MappingRegion mappingRegion, @Nullable List<@NonNull Node> preferredHeadNodes) {
        RuleHeadAnalysis mappingRegionAnalysis = new RuleHeadAnalysis(mappingRegion);
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources = mappingRegionAnalysis.computeOldTargetFromSources();
        Iterable<@NonNull Node> headNodes = mappingRegionAnalysis.computeHeadNodes(targetFromSources, preferredHeadNodes);
        mappingRegionAnalysis.checkHeadNodeConsistency(headNodes);
        return headNodes;
    }

    protected RuleHeadAnalysis(@NonNull MappingRegion mappingRegion) {
        super(mappingRegion);
    }

    private void addExtraHeads(@NonNull List<@NonNull Node> headNodes) {
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (!node.isDependency()) continue;
            node.setHead();
            assert (!headNodes.contains(node));
            headNodes.add(node);
        }
    }

    private void checkHeadNodeConsistency(@NonNull Iterable<@NonNull Node> headNodes) {
        HashSet<@NonNull Node> debugHeadNodes = new HashSet<Node>();
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (!node.isDependency() && !node.isHead()) continue;
            debugHeadNodes.add(node);
        }
        assert (debugHeadNodes.equals(Sets.newHashSet(headNodes)));
    }

    private @NonNull Iterable<@NonNull Node> computeHeadNodes(@NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources, @Nullable List<@NonNull Node> preferredHeadNodes) {
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourcesClosure = CompilerUtil.computeClosure(targetFromSources);
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> sourceToTargetsClosure = CompilerUtil.computeInverseClosure(targetFromSourcesClosure);
        List<@NonNull HeadNodeGroup> headNodeGroups = this.computeHeadNodeGroups(targetFromSourcesClosure, sourceToTargetsClosure, preferredHeadNodes);
        if (RULE_HEAD_NODE_GROUPS.isActive()) {
            StringBuilder s = new StringBuilder();
            s.append(this.mappingRegion.getName());
            for (HeadNodeGroup headNodeGroup : headNodeGroups) {
                s.append("\n\t");
                headNodeGroup.appendTo(s);
            }
            RULE_HEAD_NODE_GROUPS.println(s.toString());
        }
        List<@NonNull Node> headNodes = this.selectHeadNodes(headNodeGroups, preferredHeadNodes);
        this.addExtraHeads(headNodes);
        this.setHeadNodes(targetFromSourcesClosure.keySet(), headNodes);
        return headNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> computeNewTargetFromSources(@NonNull Iterable<@NonNull Node> realizedMiddleNodes) {
        HashMap<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources = new HashMap<Node, Set<Node>>();
        for (Node targetNode : realizedMiddleNodes) {
            @NonNull HashSet sources = Sets.newHashSet((Object[])new Node[]{targetNode});
            targetFromSources.put(targetNode, sources);
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                if (!edge.isRealized() || !edge.isNavigation()) continue;
                NavigationEdge navigationEdge = (NavigationEdge)edge;
                Node sourceNode = navigationEdge.getEdgeSource();
                sources.add(sourceNode);
            }
        }
        return targetFromSources;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> computeOldTargetFromSources() {
        HashMap<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources = new HashMap<Node, Set<Node>>();
        for (Node targetNode : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (!targetNode.isMatched() || targetNode.isConstant() || targetNode.isOperation() || !targetNode.isLoaded() && !targetNode.isChecked()) continue;
            @NonNull HashSet sources = Sets.newHashSet((Object[])new Node[]{targetNode});
            targetFromSources.put(targetNode, sources);
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                Node sourceNode;
                if (!(edge instanceof NavigationEdge) || edge.isRealized() || ((NavigationEdge)edge).isPartial() || !(sourceNode = edge.getEdgeSource()).isMatched() || sourceNode.isConstant() || sourceNode.isOperation() || !sourceNode.isLoaded() && !sourceNode.isChecked()) continue;
                sources.add(sourceNode);
            }
        }
        return targetFromSources;
    }

    @Override
    protected @NonNull HeadNodeGroup createHeadNodeGroup(final @NonNull List<@NonNull Node> headNodeGroup) {
        return new HeadNodeGroup(headNodeGroup){

            @Override
            protected boolean canBeSameGroup(@NonNull Node sourceNode, @NonNull Edge source2targetEdge) {
                boolean isOldSource = sourceNode.isOld();
                return isOldSource ? source2targetEdge.isOld() : source2targetEdge.isNew();
            }

            public String getName() {
                return ((Node)headNodeGroup.get(0)).getName();
            }
        };
    }

    private void setHeadNodes(@NonNull Set<@NonNull Node> reachableNodes, @NonNull List<@NonNull Node> headNodes) {
        for (Node node : reachableNodes) {
            if (headNodes.contains(node)) {
                node.setHead();
                continue;
            }
            node.resetHead();
        }
    }
}

