/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.bigmde2016.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class SimpleUMLGenerator<@NonNull PACKAGE extends EObject, @NonNull CLASS extends EObject, @NonNull TYPE extends EObject, @NonNull PROPERTY extends EObject, @NonNull ASSOCIATION extends EObject> {
    public @NonNull List<@NonNull ? extends EObject> createSimpleUMLModel(int nPackages, int nClasses, int nTypes, int nProperties, int nAssociations) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        ArrayList<EObject> rootPackages = new ArrayList<EObject>(10);
        ArrayList<EObject> allPackages = new ArrayList<EObject>(nPackages);
        int iPackage = 0;
        while (iPackage < nPackages) {
            int parentPackageIndex = random.nextInt(-1, allPackages.size());
            EObject parentPackage = parentPackageIndex >= 0 ? (EObject)allPackages.get(parentPackageIndex) : null;
            EObject aPackage = this.createPackage(parentPackage, "k" + iPackage);
            allPackages.add(aPackage);
            if (parentPackage == null) {
                rootPackages.add(aPackage);
            }
            ++iPackage;
        }
        ArrayList<CLASS> allClasses = new ArrayList<CLASS>(nClasses);
        int iClass = 0;
        while (iClass < nClasses) {
            int parentPackageIndex = random.nextInt(0, allPackages.size());
            allClasses.add(this.createClass((EObject)allPackages.get(parentPackageIndex), "c" + iClass));
            ++iClass;
        }
        ArrayList<TYPE> allTypes = new ArrayList<TYPE>(nTypes);
        int iType = 0;
        while (iType < nTypes) {
            int parentPackageIndex = random.nextInt(0, allPackages.size());
            allTypes.add(this.createType((EObject)allPackages.get(parentPackageIndex), "t" + iType));
            ++iType;
        }
        ArrayList<PROPERTY> allProperties = new ArrayList<PROPERTY>(nProperties);
        int iProperty = 0;
        while (iProperty < nProperties) {
            int parentClassIndex = random.nextInt(0, allClasses.size());
            int typeIndex = random.nextInt(0, allTypes.size());
            allProperties.add(this.createProperty((EObject)allClasses.get(parentClassIndex), "p" + iProperty, (EObject)allTypes.get(typeIndex)));
            ++iProperty;
        }
        ArrayList<ASSOCIATION> allAssociations = new ArrayList<ASSOCIATION>(nAssociations);
        int iAssociation = 0;
        while (iAssociation < nAssociations) {
            int parentPackageIndex = random.nextInt(0, allPackages.size());
            int fromClassIndex = random.nextInt(0, allClasses.size());
            int toClassIndex = random.nextInt(0, allClasses.size());
            allAssociations.add(this.createAssociation((EObject)allPackages.get(parentPackageIndex), "a" + iAssociation, (EObject)allClasses.get(fromClassIndex), (EObject)allClasses.get(toClassIndex)));
            ++iAssociation;
        }
        return this.createModel(rootPackages, "m0");
    }

    protected abstract ASSOCIATION createAssociation(PACKAGE var1, @NonNull String var2, CLASS var3, CLASS var4);

    protected abstract CLASS createClass(PACKAGE var1, @NonNull String var2);

    protected abstract @NonNull List<@NonNull ? extends EObject> createModel(@NonNull List<PACKAGE> var1, @NonNull String var2);

    protected abstract PACKAGE createPackage(@Nullable PACKAGE var1, @NonNull String var2);

    protected abstract PROPERTY createProperty(CLASS var1, @NonNull String var2, TYPE var3);

    protected abstract TYPE createType(PACKAGE var1, @NonNull String var2);
}

