/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CyclicPartition;

public class CyclicPartitionsAnalysis {
    protected final @NonNull TransformationPartitioner transformationPartitioner;
    protected final @NonNull Iterable<@NonNull PartitionAnalysis> leafPartitionAnalyses;
    protected final @NonNull Map<@NonNull PartitionAnalysis, @NonNull CyclicPartition> partitionAnalysis2cyclicPartition = new HashMap<PartitionAnalysis, CyclicPartition>();
    protected final @NonNull Map<@NonNull TraceClassPartitionAnalysis, @NonNull CyclicPartition> traceClassAnalysis2cyclicPartition = new HashMap<TraceClassPartitionAnalysis, CyclicPartition>();

    public CyclicPartitionsAnalysis(@NonNull TransformationPartitioner transformationPartitioner, @NonNull Iterable<@NonNull PartitionAnalysis> leafPartitions) {
        this.transformationPartitioner = transformationPartitioner;
        this.leafPartitionAnalyses = leafPartitions;
    }

    public @NonNull RootPartitionAnalysis analyze(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> leafPartitionAnalysis2predecessors = CompilerUtil.computeTransitivePredecessors(this.leafPartitionAnalyses);
        Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> leafPartitionAnalysis2successors = CompilerUtil.computeTransitiveSuccessors(leafPartitionAnalysis2predecessors);
        HashSet<@NonNull Set<@NonNull PartitionAnalysis>> intersections = new HashSet<Set<PartitionAnalysis>>();
        for (PartitionAnalysis leafPartitionAnalysis : this.leafPartitionAnalyses) {
            Set<@NonNull PartitionAnalysis> predecessors = leafPartitionAnalysis2predecessors.get(leafPartitionAnalysis);
            Set<@NonNull PartitionAnalysis> successors = leafPartitionAnalysis2successors.get(leafPartitionAnalysis);
            HashSet<@NonNull PartitionAnalysis> intersection = new HashSet<PartitionAnalysis>(predecessors);
            intersection.retainAll(successors);
            if (intersection.isEmpty()) continue;
            intersections.add(intersection);
        }
        if (intersections.isEmpty()) {
            String rootName = "\u00abroot\u00bb";
            return RootPartitionAnalysis.createRootPartitionAnalysis(partitionedTransformationAnalysis, this.transformationPartitioner.getTransformationAnalysis(), rootName, leafPartitionAnalysis2predecessors);
        }
        intersections.add(Sets.newHashSet(this.leafPartitionAnalyses));
        return this.createAcyclicPartitionHierarchy(partitionedTransformationAnalysis, intersections, leafPartitionAnalysis2predecessors);
    }

    private @NonNull Set<@NonNull TraceClassPartitionAnalysis> computeTraceClassAnalysisDependencies(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Iterable<@NonNull PartitionAnalysis> nestedPartitions) {
        HashSet<@NonNull E> consumedTraceClassAnalyses = new HashSet();
        HashSet<@NonNull E> superProducedTraceClassAnalyses = new HashSet();
        for (PartitionAnalysis nestedPartitionAnalysis : nestedPartitions) {
            Iterable<TraceClassPartitionAnalysis> superProducedTraceClassAnalyses2;
            Iterable<@NonNull TC> consumedTraceClassAnalyses2 = nestedPartitionAnalysis.getConsumedTraceClassAnalyses();
            if (consumedTraceClassAnalyses2 != null) {
                Iterables.addAll(consumedTraceClassAnalyses, consumedTraceClassAnalyses2);
            }
            if ((superProducedTraceClassAnalyses2 = nestedPartitionAnalysis.getSuperProducedTraceClassAnalyses()) == null) continue;
            Iterables.addAll(superProducedTraceClassAnalyses, superProducedTraceClassAnalyses2);
        }
        HashSet<@NonNull TraceClassPartitionAnalysis> cyclicTraceClassAnalyses = new HashSet<TraceClassPartitionAnalysis>(consumedTraceClassAnalyses);
        cyclicTraceClassAnalyses.retainAll(superProducedTraceClassAnalyses);
        return cyclicTraceClassAnalyses;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull RootPartitionAnalysis createAcyclicPartitionHierarchy(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Iterable<@NonNull Set<@NonNull PartitionAnalysis>> partitionings, @NonNull Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partition2predecessors) {
        ArrayList<@NonNull Set<@NonNull PartitionAnalysis>> sortedPartitionings = new ArrayList<Set<PartitionAnalysis>>();
        final HashMap<@NonNull Set<@NonNull PartitionAnalysis>, @NonNull HashSet<@NonNull E>> partitioning2predecessors = new HashMap();
        for (Set<PartitionAnalysis> partitioning : partitionings) {
            sortedPartitionings.add(partitioning);
            HashSet<@NonNull E> predecessors = new HashSet();
            for (PartitionAnalysis partitionAnalysis : partitioning) {
                predecessors.addAll(partition2predecessors.get(partitionAnalysis));
            }
            partitioning2predecessors.put(partitioning, predecessors);
        }
        Collections.sort(sortedPartitionings, new Comparator<Set<PartitionAnalysis>>(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public int compare(@NonNull Set<@NonNull PartitionAnalysis> o1, @NonNull Set<@NonNull PartitionAnalysis> o2) {
                int s2;
                @NonNull Set predecessors1 = (Set)partitioning2predecessors.get(o1);
                @NonNull Set predecessors2 = (Set)partitioning2predecessors.get(o2);
                if (!$assertionsDisabled && predecessors1 == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && predecessors2 == null) {
                    throw new AssertionError();
                }
                int s1 = predecessors1.size();
                if (s1 == (s2 = predecessors2.size())) {
                    s1 = o1.size();
                    s2 = o2.size();
                }
                return s1 - s2;
            }
        });
        ArrayList<@NonNull CompositePartitionAnalysis> acyclicPartitionHierarchy = new ArrayList<CompositePartitionAnalysis>();
        int iMax = sortedPartitionings.size();
        assert (iMax >= 2);
        assert (((Set)sortedPartitionings.get(iMax - 1)).equals(Sets.newHashSet(this.leafPartitionAnalyses)));
        int i = 0;
        while (i < iMax - 1) {
            CyclicPartition oldCycleAnalysis;
            @NonNull Set nestedPartitioning = (Set)sortedPartitionings.get(i);
            String cycleName = "\u00abcycle-" + i + "\u00bb";
            Set<@NonNull TraceClassPartitionAnalysis> cyclicTraceClassAnalyses = this.computeTraceClassAnalysisDependencies(partitionedTransformationAnalysis, nestedPartitioning);
            CyclicPartitionAnalysis nestedCyclicPartitionAnalysis = CyclicPartitionAnalysis.createCyclicPartitionAnalysis(partitionedTransformationAnalysis, cycleName, nestedPartitioning, partition2predecessors);
            CyclicPartition nestedCyclicPartition = (CyclicPartition)nestedCyclicPartitionAnalysis.getPartition();
            acyclicPartitionHierarchy.add(nestedCyclicPartitionAnalysis);
            for (PartitionAnalysis nestedPartition : nestedPartitioning) {
                oldCycleAnalysis = this.partitionAnalysis2cyclicPartition.put(nestedPartition, nestedCyclicPartition);
                assert (oldCycleAnalysis == null);
                partition2predecessors.remove(nestedPartition);
            }
            partition2predecessors.put(nestedCyclicPartitionAnalysis, (Set<PartitionAnalysis>)nestedCyclicPartitionAnalysis.getExplicitPredecessors());
            for (TraceClassPartitionAnalysis cyclicTraceClassAnalysis : cyclicTraceClassAnalyses) {
                oldCycleAnalysis = this.traceClassAnalysis2cyclicPartition.put(cyclicTraceClassAnalysis, nestedCyclicPartition);
                assert (oldCycleAnalysis == null);
            }
            int j = i + 1;
            while (j < iMax) {
                @NonNull Set nestingPartitioning = (Set)sortedPartitionings.get(j);
                int oldSize = nestingPartitioning.size();
                if (nestingPartitioning.removeAll(nestedPartitioning)) {
                    int newSize = nestingPartitioning.size();
                    assert (oldSize - newSize == nestedPartitioning.size());
                    nestingPartitioning.add(nestedCyclicPartitionAnalysis);
                }
                ++j;
            }
            for (PartitionAnalysis partition : partition2predecessors.keySet()) {
                Set<@NonNull PartitionAnalysis> predecessors = partition2predecessors.get(partition);
                assert (predecessors != null);
                int oldSize = predecessors.size();
                if (!predecessors.removeAll(nestedPartitioning)) continue;
                int newSize = predecessors.size();
                assert (oldSize - newSize == nestedPartitioning.size());
                predecessors.add(nestedCyclicPartitionAnalysis);
            }
            ++i;
        }
        String rootName = "\u00abroot\u00bb";
        RootPartitionAnalysis rootPartitionAnalysis = RootPartitionAnalysis.createRootPartitionAnalysis(partitionedTransformationAnalysis, this.transformationPartitioner.getTransformationAnalysis(), rootName, partition2predecessors);
        acyclicPartitionHierarchy.add(rootPartitionAnalysis);
        if (TransformationPartitioner.CYCLES.isActive()) {
            this.showCycles(partitionedTransformationAnalysis, acyclicPartitionHierarchy);
        }
        return rootPartitionAnalysis;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void showCycles(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, Iterable<@NonNull CompositePartitionAnalysis> cyclicPartitionAnalyses) {
        if (Iterables.isEmpty(cyclicPartitionAnalyses)) {
            TransformationPartitioner.CYCLES.println("No cycles");
        } else {
            for (CompositePartitionAnalysis cyclicPartitionAnalysis : cyclicPartitionAnalyses) {
                StringBuilder s = new StringBuilder();
                s.append("\n  Partitions:");
                @NonNull ArrayList partitions2 = Lists.newArrayList(cyclicPartitionAnalysis.getPartitionAnalyses());
                Collections.sort(partitions2, NameUtil.NAMEABLE_COMPARATOR);
                for (PartitionAnalysis partition : partitions2) {
                    Iterable<TracePropertyPartitionAnalysis> producedTracePropertyAnalyses;
                    Iterable consumedTracePropertyAnalyses;
                    Iterable<TraceClassPartitionAnalysis> producedTraceClassAnalyses;
                    s.append("\n\t" + partition);
                    Iterable<@NonNull TC> consumedTraceClassAnalyses = partition.getConsumedTraceClassAnalyses();
                    if (consumedTraceClassAnalyses != null) {
                        for (TraceClassPartitionAnalysis traceClassAnalysis : consumedTraceClassAnalyses) {
                            s.append("\n\t  =>" + traceClassAnalysis);
                        }
                    }
                    if ((producedTraceClassAnalyses = partition.getProducedTraceClassAnalyses()) != null) {
                        for (TraceClassPartitionAnalysis traceClassAnalysis : producedTraceClassAnalyses) {
                            s.append("\n\t  <=" + traceClassAnalysis);
                        }
                    }
                    if ((consumedTracePropertyAnalyses = partition.getConsumedTracePropertyAnalyses()) != null) {
                        for (TracePropertyPartitionAnalysis tracePropertyAnalysis : consumedTracePropertyAnalyses) {
                            s.append("\n\t  =>" + tracePropertyAnalysis);
                        }
                    }
                    if ((producedTracePropertyAnalyses = partition.getProducedTracePropertyAnalyses()) == null) continue;
                    for (TracePropertyPartitionAnalysis tracePropertyAnalysis : producedTracePropertyAnalyses) {
                        s.append("\n\t  <=" + tracePropertyAnalysis);
                    }
                }
                TransformationPartitioner.CYCLES.println(s.toString());
            }
        }
    }
}

