/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.AbstractMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MergedPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.CompositePartition;
import org.eclipse.qvtd.pivot.qvtschedule.Connection;
import org.eclipse.qvtd.pivot.qvtschedule.MappingPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class SequentialPartitionMerger
extends AbstractMerger {
    protected final @NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis;
    protected final @NonNull List<@NonNull BasicPartitionAnalysis> mergeablePartitionAnalyses;

    public static @NonNull List<@NonNull Concurrency> merge(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull List<@NonNull Concurrency> partitionSchedule) {
        RootPartitionAnalysis rootPartitionAnalysis = partitionedTransformationAnalysis.getRootPartitionAnalysis();
        ScheduleManager scheduleManager = partitionedTransformationAnalysis.getScheduleManager();
        for (Connection connection : QVTscheduleUtil.getOwnedConnections((RootRegion)rootPartitionAnalysis.getRootRegion())) {
            AbstractPartitionAnalysis<?> sourcePartitionAnalysis;
            Partition sourcePartition;
            Iterable sourcePartitions;
            if (!connection.isPassed() || Iterables.size((Iterable)(sourcePartitions = connection.getSourcePartitions())) != 1 || !((sourcePartition = (Partition)sourcePartitions.iterator().next()) instanceof MappingPartition) || !((sourcePartitionAnalysis = partitionedTransformationAnalysis.getPartitionAnalysis(sourcePartition)) instanceof BasicPartitionAnalysis)) continue;
            ArrayList<BasicPartitionAnalysis> mergeablePartitionAnalyses = null;
            CheckedConditionAnalysis sourceCheckedConditionAnalysis = new CheckedConditionAnalysis((MappingPartitionAnalysis)sourcePartitionAnalysis, scheduleManager);
            Set<@NonNull CheckedCondition> sourceCheckedConditions = sourceCheckedConditionAnalysis.computeCheckedConditions();
            for (Partition targetPartition : connection.getTargetPartitions()) {
                CheckedConditionAnalysis targetCheckedConditionAnalysis;
                Set<CheckedCondition> targetCheckedConditions;
                AbstractPartitionAnalysis<?> targetPartitionAnalysis;
                if (targetPartition.getHeadNodes().size() != 1 || sourcePartition.getRegion() != targetPartition.getRegion() || !((targetPartitionAnalysis = partitionedTransformationAnalysis.getPartitionAnalysis(targetPartition)) instanceof BasicPartitionAnalysis) || !sourceCheckedConditions.containsAll(targetCheckedConditions = (targetCheckedConditionAnalysis = new CheckedConditionAnalysis((MappingPartitionAnalysis)targetPartitionAnalysis, scheduleManager)).computeCheckedConditions())) continue;
                if (mergeablePartitionAnalyses == null) {
                    mergeablePartitionAnalyses = new ArrayList<BasicPartitionAnalysis>();
                    mergeablePartitionAnalyses.add((BasicPartitionAnalysis)sourcePartitionAnalysis);
                }
                mergeablePartitionAnalyses.add((BasicPartitionAnalysis)targetPartitionAnalysis);
                System.out.println("Sequential Merge " + sourcePartition + " => " + connection + " => " + targetPartitionAnalysis);
            }
        }
        return partitionSchedule;
    }

    protected SequentialPartitionMerger(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull List<@NonNull BasicPartitionAnalysis> mergeablePartitionAnalyses) {
        this.partitionedTransformationAnalysis = partitionedTransformationAnalysis;
        this.mergeablePartitionAnalyses = mergeablePartitionAnalyses;
    }

    protected @Nullable Map<@NonNull PartitionAnalysis, @Nullable PartitionAnalysis> merge() {
        ScheduleManager scheduleManager = this.partitionedTransformationAnalysis.getScheduleManager();
        HashMap<@NonNull PartitionAnalysis, @Nullable PartitionAnalysis> old2new = new HashMap<PartitionAnalysis, PartitionAnalysis>();
        BasicPartition firstPartition = (BasicPartition)this.mergeablePartitionAnalyses.get(0).getPartition();
        CompositePartition owningCompositePartition = firstPartition.getOwningCompositePartition();
        assert (owningCompositePartition != null);
        AbstractCompositePartitionAnalysis compositePartitionAnalysis = (AbstractCompositePartitionAnalysis)this.partitionedTransformationAnalysis.getPartitionAnalysis((Partition)owningCompositePartition);
        List ownedMappingPartitions = owningCompositePartition.getOwnedMappingPartitions();
        MergedPartitionFactory mergedPartitionFactory = new MergedPartitionFactory(scheduleManager, QVTscheduleUtil.getRegion((Partition)firstPartition), this.mergeablePartitionAnalyses);
        BasicPartitionAnalysis mergedPartitionAnalysis = mergedPartitionFactory.createPartitionAnalysis(this.partitionedTransformationAnalysis);
        BasicPartition mergedPartition = (BasicPartition)mergedPartitionAnalysis.getPartition();
        for (BasicPartitionAnalysis mergeablePartitionAnalysis : this.mergeablePartitionAnalyses) {
            old2new.put(mergeablePartitionAnalysis, mergedPartitionAnalysis);
        }
        Iterator<BasicPartitionAnalysis> iterator = firstPartition.getPasses().iterator();
        while (iterator.hasNext()) {
            int pass = (Integer)((Object)iterator.next());
            mergedPartition.addPass(pass);
        }
        scheduleManager.writeDebugGraphs((Graphable)mergedPartition, null);
        ownedMappingPartitions.add(mergedPartition);
        compositePartitionAnalysis.merge(old2new);
        return old2new;
    }
}

