/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TraceClassRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TraceElementRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class TracePropertyRegionAnalysis
extends TraceElementRegionAnalysis
implements CompilerUtil.TraceProperty<RegionAnalysis, TraceClassRegionAnalysis, TracePropertyRegionAnalysis> {
    protected final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    protected final @NonNull TraceClassRegionAnalysis traceClassAnalysis;
    protected final @NonNull PropertyDatum tracePropertyDatum;

    public TracePropertyRegionAnalysis(@NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull TraceClassRegionAnalysis traceClassAnalysis, @NonNull PropertyDatum tracePropertyDatum) {
        this.transformationAnalysis = transformationAnalysis;
        this.traceClassAnalysis = traceClassAnalysis;
        this.tracePropertyDatum = tracePropertyDatum;
        assert (transformationAnalysis.getTraceClassAnalysis(QVTscheduleUtil.getOwningClassDatum((PropertyDatum)tracePropertyDatum)) == traceClassAnalysis);
    }

    public String getName() {
        return this.tracePropertyDatum.getName();
    }

    public @NonNull Iterable<@NonNull TracePropertyRegionAnalysis> getSuperTracePropertyAnalyses() {
        ArrayList<@NonNull TracePropertyRegionAnalysis> tracePropertyAnalyses = new ArrayList<TracePropertyRegionAnalysis>();
        for (TraceClassRegionAnalysis superTraceClassAnalysis : this.traceClassAnalysis.getSuperTraceClassAnalyses()) {
            TracePropertyRegionAnalysis tracePropertyAnalysis;
            ClassDatum superTraceClassDatum = superTraceClassAnalysis.getClassDatum();
            PropertyDatum propertyDatum = (PropertyDatum)NameUtil.getNameable((Iterable)superTraceClassDatum.getOwnedPropertyDatums(), (String)this.getName());
            if (propertyDatum == null || (tracePropertyAnalysis = this.transformationAnalysis.basicGetTracePropertyAnalysis(propertyDatum)) == null || tracePropertyAnalyses.contains(tracePropertyAnalysis)) continue;
            tracePropertyAnalyses.add(tracePropertyAnalysis);
        }
        assert (tracePropertyAnalyses.contains(this));
        return tracePropertyAnalyses;
    }

    public @NonNull Property getTraceProperty() {
        return QVTscheduleUtil.getReferredProperty((PropertyDatum)this.tracePropertyDatum);
    }

    public String toString() {
        return this.tracePropertyDatum.toString();
    }
}

