/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.checks;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;

public abstract class CheckedCondition
implements Comparable<CheckedCondition> {
    public abstract <R> R accept(@NonNull CheckedConditionVisitor<R> var1);

    @Override
    public int compareTo(@NonNull CheckedCondition that) {
        Class<?> thatClass;
        int thatOrdinal;
        CheckPriority thisPriority = this.getCheckPriority();
        CheckPriority thatPriority = that.getCheckPriority();
        int thisOrdinal = thisPriority.ordinal();
        if (thisOrdinal != (thatOrdinal = thatPriority.ordinal())) {
            return thisOrdinal - thatOrdinal;
        }
        Class<?> thisClass = this.getClass();
        if (thisClass != (thatClass = that.getClass())) {
            return thisClass.getName().compareTo(thatClass.getName());
        }
        String thisString = this.toString();
        String thatString = that.toString();
        return thisString.compareTo(thatString);
    }

    public @Nullable Iterable<@NonNull Edge> getEdges() {
        return null;
    }

    public @Nullable Node getNode() {
        return null;
    }

    protected @NonNull CheckPriority getCheckPriority() {
        return CheckPriority.LOWEST_PRIORITY;
    }

    public @NonNull String toString() {
        Node node;
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append("(");
        boolean isFirst = true;
        Iterable<@NonNull Edge> edges = this.getEdges();
        if (edges != null) {
            for (Edge edge : edges) {
                if (!isFirst) {
                    s.append(",");
                }
                s.append(edge.getDisplayName());
                isFirst = false;
            }
        }
        if ((node = this.getNode()) != null) {
            if (!isFirst) {
                s.append(",");
            }
            s.append(node.getDisplayName());
            isFirst = false;
        }
        s.append(")");
        return s.toString();
    }

    protected static enum CheckPriority {
        LOCAL_SUCCESS_EDGE,
        GLOBAL_SUCCESS_EDGE,
        CONSTANT_TARGET,
        LOWEST_PRIORITY;

    }
}

