/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.DatumConnection;
import org.eclipse.qvtd.pivot.qvtschedule.EdgeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class RegionAnalysis
implements Adapter {
    protected final @NonNull Region region;
    private @Nullable Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigableEdge>> typedModel2checkedEdges = null;
    private @Nullable Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigableEdge>> typedModel2enforcedEdges = null;

    public static @Nullable RegionAnalysis find(@NonNull Region region) {
        return (RegionAnalysis)ClassUtil.getAdapter(RegionAnalysis.class, (Notifier)region);
    }

    public static @NonNull RegionAnalysis get(@NonNull Region region) {
        RegionAnalysis adapter = (RegionAnalysis)ClassUtil.getAdapter(RegionAnalysis.class, (Notifier)region);
        if (adapter == null) {
            adapter = new RegionAnalysis(region);
        }
        return adapter;
    }

    public RegionAnalysis(@NonNull Region region) {
        region.eAdapters().add((Object)this);
        this.region = region;
    }

    private void addCheckedEdge(@NonNull NavigableEdge predicatedEdge) {
        assert (predicatedEdge.isPredicated());
        assert (predicatedEdge.getOwningRegion() == this.region);
        Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigableEdge>> typedModel2checkedEdges2 = this.typedModel2checkedEdges;
        assert (typedModel2checkedEdges2 != null);
        ClassDatum classDatum = RegionUtil.getClassDatum((Node)predicatedEdge.getEdgeSource());
        TypedModel typedModel = RegionUtil.getReferredTypedModel((ClassDatum)classDatum);
        Set<@NonNull NavigableEdge> checkedEdges = typedModel2checkedEdges2.get(typedModel);
        if (checkedEdges == null) {
            checkedEdges = new HashSet<NavigableEdge>();
            typedModel2checkedEdges2.put(typedModel, checkedEdges);
        }
        checkedEdges.add(predicatedEdge);
        QVTscheduleConstants.POLLED_PROPERTIES.println("    checked " + predicatedEdge.getProperty() + " at " + this.region.getIndexRangeText() + " in " + typedModel + " for " + this.region);
    }

    private void addEnforcedEdge(@NonNull NavigableEdge realizedEdge) {
        assert (realizedEdge.isRealized());
        assert (realizedEdge.getOwningRegion() == this.region);
        Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigableEdge>> typedModel2enforcedEdges2 = this.typedModel2enforcedEdges;
        assert (typedModel2enforcedEdges2 != null);
        ClassDatum classDatum = RegionUtil.getClassDatum((Node)realizedEdge.getEdgeSource());
        TypedModel typedModel = RegionUtil.getReferredTypedModel((ClassDatum)classDatum);
        Set<@NonNull NavigableEdge> enforcedEdges = typedModel2enforcedEdges2.get(typedModel);
        if (enforcedEdges == null) {
            enforcedEdges = new HashSet<NavigableEdge>();
            typedModel2enforcedEdges2.put(typedModel, enforcedEdges);
        }
        enforcedEdges.add(realizedEdge);
        QVTscheduleConstants.POLLED_PROPERTIES.println("    enforced " + realizedEdge.getProperty() + " at " + this.region.getIndexRangeText() + " in " + typedModel + " for " + this.region);
    }

    public void buildNavigationEdgesIndex(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges, @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges) {
        this.buildPredicatedNavigationEdgesIndex2(typedModel2property2predicatedEdges);
        this.buildRealizedNavigationEdgesIndex2(typedModel2property2realizedEdges);
        this.typedModel2checkedEdges = new HashMap<TypedModel, Set<NavigableEdge>>();
        this.typedModel2enforcedEdges = new HashMap<TypedModel, Set<NavigableEdge>>();
    }

    private void buildPredicatedNavigationEdgesIndex2(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges) {
        for (NavigableEdge predicatedEdge : this.region.getPredicatedNavigationEdges()) {
            List<NavigableEdge> predicatedEdges;
            if (predicatedEdge.isCast()) continue;
            Property property = QVTscheduleUtil.getProperty((NavigableEdge)predicatedEdge);
            Node predicatedNode = predicatedEdge.getEdgeSource();
            ClassDatum classDatum = RegionUtil.getClassDatum((Node)predicatedNode);
            TypedModel typedModel = RegionUtil.getReferredTypedModel((ClassDatum)classDatum);
            Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> property2predicatedEdges = typedModel2property2predicatedEdges.get(typedModel);
            if (property2predicatedEdges == null) {
                property2predicatedEdges = new HashMap<Property, List<NavigableEdge>>();
                typedModel2property2predicatedEdges.put(typedModel, property2predicatedEdges);
            }
            if ((predicatedEdges = property2predicatedEdges.get(property)) == null) {
                predicatedEdges = new ArrayList<NavigableEdge>();
                property2predicatedEdges.put(property, predicatedEdges);
            }
            predicatedEdges.add(predicatedEdge);
            QVTscheduleConstants.POLLED_PROPERTIES.println("  " + typedModel + " predicated for " + property);
        }
    }

    private void buildRealizedNavigationEdgesIndex2(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges) {
        for (NavigableEdge realizedEdge : this.region.getRealizedNavigationEdges()) {
            List<NavigableEdge> realizedEdges;
            Property property = QVTscheduleUtil.getProperty((NavigableEdge)realizedEdge);
            Node realizedNode = realizedEdge.getEdgeSource();
            ClassDatum classDatum = RegionUtil.getClassDatum((Node)realizedNode);
            TypedModel typedModel = RegionUtil.getReferredTypedModel((ClassDatum)classDatum);
            Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> property2realizedEdges = typedModel2property2realizedEdges.get(typedModel);
            if (property2realizedEdges == null) {
                property2realizedEdges = new HashMap<Property, List<NavigableEdge>>();
                typedModel2property2realizedEdges.put(typedModel, property2realizedEdges);
            }
            if ((realizedEdges = property2realizedEdges.get(property)) == null) {
                realizedEdges = new ArrayList<NavigableEdge>();
                property2realizedEdges.put(property, realizedEdges);
            }
            realizedEdges.add(realizedEdge);
            QVTscheduleConstants.POLLED_PROPERTIES.println("  " + typedModel + " realized for " + property);
        }
    }

    public void computeCheckedOrEnforcedEdges(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges, @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges) {
        boolean doDebug = QVTscheduleConstants.POLLED_PROPERTIES.isActive();
        if (doDebug) {
            QVTscheduleConstants.POLLED_PROPERTIES.println("analyzing " + this.region + " (" + this.region.getIndexRangeText() + ")");
        }
        for (NavigableEdge predicatedEdge : this.region.getPredicatedNavigationEdges()) {
            EdgeConnection edgeConnection;
            if (predicatedEdge.isCast()) continue;
            Property property = predicatedEdge.getProperty();
            if (doDebug) {
                QVTscheduleConstants.POLLED_PROPERTIES.println("  analyzing " + predicatedEdge.getEdgeSource().getName() + "::" + property.getName() + " : " + predicatedEdge.getEdgeSource().getCompleteClass());
            }
            if ((edgeConnection = predicatedEdge.getIncomingConnection()) != null) {
                Region usedRegion;
                boolean isChecked = false;
                for (NavigableEdge usedEdge : QVTscheduleUtil.getSourceEnds((DatumConnection)edgeConnection)) {
                    usedRegion = QVTscheduleUtil.getOwningRegion((ConnectionEnd)usedEdge);
                    RegionAnalysis.get(usedRegion).addEnforcedEdge(usedEdge);
                    if (usedRegion.getFinalExecutionIndex() < this.region.getInvocationIndex()) continue;
                    this.addCheckedEdge(predicatedEdge);
                    isChecked = true;
                }
                if (isChecked) {
                    for (NavigableEdge usedEdge : QVTscheduleUtil.getSourceEnds((DatumConnection)edgeConnection)) {
                        usedRegion = QVTscheduleUtil.getOwningRegion((ConnectionEnd)usedEdge);
                        RegionAnalysis.get(usedRegion).addEnforcedEdge(usedEdge);
                    }
                }
            }
            Node laterNode = predicatedEdge.getEdgeSource();
            Node predicatedSourceNode = predicatedEdge.getEdgeSource();
            Node predicatedTargetNode = predicatedEdge.getEdgeTarget();
            NodeConnection usedConnection = predicatedTargetNode.getIncomingUsedConnection();
            if (usedConnection == null) continue;
            for (Node usedSourceNode : QVTscheduleUtil.getSourceEnds((DatumConnection)usedConnection)) {
                CompleteClass realizedTargetType;
                CompleteClass realizedSourceType;
                Node realizedTargetNode;
                Node realizedSourceNode;
                Region usedRegion = QVTscheduleUtil.getOwningRegion((Node)usedSourceNode);
                if (usedRegion.getFinalExecutionIndex() < this.region.getInvocationIndex()) continue;
                CompleteClass predicatedSourceType = predicatedSourceNode.getCompleteClass();
                CompleteClass predicatedTargetType = predicatedTargetNode.getCompleteClass();
                ClassDatum classDatum = laterNode.getClassDatum();
                TypedModel typedModel = classDatum.getReferredTypedModel();
                Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>> property2realizedEdges = typedModel2property2realizedEdges.get(typedModel);
                assert (property2realizedEdges != null);
                Property oclContainerProperty = RegionUtil.getScheduleManager(this.region).getStandardLibraryHelper().getOclContainerProperty();
                if (property == oclContainerProperty) {
                    for (Property candidateProperty : property2realizedEdges.keySet()) {
                        if (!candidateProperty.isIsComposite()) continue;
                        List<@NonNull NavigableEdge> realizedEdges = property2realizedEdges.get(candidateProperty);
                        assert (realizedEdges != null);
                        for (NavigableEdge realizedEdge : realizedEdges) {
                            Region earlierRegion = realizedEdge.getOwningRegion();
                            realizedSourceNode = realizedEdge.getEdgeSource();
                            realizedTargetNode = realizedEdge.getEdgeTarget();
                            realizedSourceType = realizedSourceNode.getCompleteClass();
                            realizedTargetType = realizedTargetNode.getCompleteClass();
                            if (realizedSourceType.conformsTo(predicatedSourceType) && realizedTargetType.conformsTo(predicatedTargetType)) assert (this.region.getFinalExecutionIndex() >= earlierRegion.getInvocationIndex());
                            assert (this.region.getFinalExecutionIndex() >= earlierRegion.getInvocationIndex());
                            this.addCheckedEdge(predicatedEdge);
                            RegionAnalysis.get(earlierRegion).addEnforcedEdge(realizedEdge);
                        }
                    }
                    continue;
                }
                assert (property2realizedEdges != null) : "No realized typed model for " + typedModel;
                List<@NonNull NavigableEdge> realizedEdges = property2realizedEdges.get(property);
                if (realizedEdges == null) {
                    System.err.println("No realized edges for " + property + " in " + typedModel);
                    continue;
                }
                for (NavigableEdge realizedEdge : realizedEdges) {
                    String enforceIsHazardFreeBecause;
                    String checkIsHazardFreeBecause;
                    Region earlierRegion = QVTscheduleUtil.getOwningRegion((ConnectionEnd)realizedEdge);
                    realizedSourceNode = realizedEdge.getEdgeSource();
                    realizedTargetNode = realizedEdge.getEdgeTarget();
                    realizedSourceType = realizedSourceNode.getCompleteClass();
                    realizedTargetType = realizedTargetNode.getCompleteClass();
                    if (!realizedSourceType.conformsTo(predicatedSourceType)) {
                        checkIsHazardFreeBecause = "incompatible-source";
                        enforceIsHazardFreeBecause = "incompatible-source";
                    } else if (!RegionUtil.conformsToClassOrBehavioralClass((CompleteClass)realizedTargetType, (CompleteClass)predicatedTargetType)) {
                        checkIsHazardFreeBecause = "incompatible-target";
                        enforceIsHazardFreeBecause = "incompatible-target";
                    } else if (this.region == earlierRegion) {
                        checkIsHazardFreeBecause = null;
                        enforceIsHazardFreeBecause = null;
                    } else if (earlierRegion.getFinalExecutionIndex() < this.region.getInvocationIndex()) {
                        checkIsHazardFreeBecause = "later";
                        enforceIsHazardFreeBecause = null;
                    } else {
                        checkIsHazardFreeBecause = null;
                        enforceIsHazardFreeBecause = null;
                    }
                    if (checkIsHazardFreeBecause == null) {
                        this.addCheckedEdge(predicatedEdge);
                    } else if (doDebug) {
                        QVTscheduleConstants.POLLED_PROPERTIES.println("    ignored check for " + this.region + "::" + laterNode.getName() + "(" + this.region.getIndexRangeText() + ")" + " " + checkIsHazardFreeBecause + " (" + earlierRegion.getIndexRangeText() + ")" + earlierRegion + "::" + realizedEdge.getEdgeSource().getName());
                    }
                    if (enforceIsHazardFreeBecause == null) {
                        RegionAnalysis.get(earlierRegion).addEnforcedEdge(realizedEdge);
                        continue;
                    }
                    if (!doDebug) continue;
                    QVTscheduleConstants.POLLED_PROPERTIES.println("    ignored enforce " + this.region + "::" + laterNode.getName() + "(" + this.region.getIndexRangeText() + ")" + " " + enforceIsHazardFreeBecause + " (" + earlierRegion.getIndexRangeText() + ")" + earlierRegion + "::" + realizedEdge.getEdgeSource().getName());
                }
            }
        }
    }

    public @Nullable Set<@NonNull NavigableEdge> getCheckedEdges(@NonNull TypedModel typedModel) {
        assert (this.typedModel2checkedEdges != null);
        return this.typedModel2checkedEdges.get(typedModel);
    }

    public @Nullable Set<@NonNull NavigableEdge> getEnforcedEdges(@NonNull TypedModel typedModel) {
        assert (this.typedModel2enforcedEdges != null);
        return this.typedModel2enforcedEdges.get(typedModel);
    }

    public Notifier getTarget() {
        return this.region;
    }

    public boolean isAdapterForType(Object type) {
        return type == RegionAnalysis.class;
    }

    public void notifyChanged(Notification notification) {
    }

    public void setTarget(Notifier newTarget) {
    }
}

