/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTrNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.NonTopRelation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.TopRelation2TraceClass;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;

public class RelationalTransformation2TracePackage {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;
    protected final @NonNull QVTrNameGenerator nameGenerator;
    protected final @NonNull RelationalTransformation rTransformation;
    private final @NonNull Package tracePackage;
    protected final @NonNull Map<@NonNull String, @NonNull Relation2TraceClass> name2relation2traceClass = new HashMap<String, Relation2TraceClass>();
    protected final @NonNull Map<@NonNull Relation, @Nullable Relation2TraceClass> relation2relation2traceClass = new HashMap<Relation, Relation2TraceClass>();
    private @NonNull Map<@NonNull Type, @NonNull Relation2TraceClass> traceClass2relation2traceClass = new HashMap<Type, Relation2TraceClass>();

    public RelationalTransformation2TracePackage(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull RelationalTransformation rTransformation) {
        this.qvtr2qvtc = qvtr2qvtc;
        this.nameGenerator = qvtr2qvtc.getNameGenerator();
        this.rTransformation = rTransformation;
        this.tracePackage = this.createTracePackage();
    }

    protected void analyzeTraceClasses() throws CompilerChainException {
        for (Relation2TraceClass relation2TraceClass : this.name2relation2traceClass.values()) {
            relation2TraceClass.analyzeProperties();
        }
    }

    public @Nullable Class basicGetSignatureClass(@NonNull Relation rRelation) {
        return this.getRelation2TraceClass(rRelation).basicGetSignatureClass();
    }

    public @Nullable Property basicGetTraceProperty(@NonNull Type aClass, @NonNull VariableDeclaration rVariable) {
        Relation2TraceClass relation2TraceClass = this.traceClass2relation2traceClass.get(aClass);
        if (relation2TraceClass == null) {
            return null;
        }
        return relation2TraceClass.basicGetTraceProperty(rVariable);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void createDependencies() throws CompilerChainException {
        ArrayList<Relation2TraceClass> consumedByRelation2TraceClasses;
        ArrayList<Relation2TraceClass> consumedRelation2TraceClasses;
        boolean isFirst;
        StringBuilder s;
        ArrayList<@NonNull Relation2TraceClass> relation2TraceClasses2 = new ArrayList<Relation2TraceClass>(this.name2relation2traceClass.values());
        Collections.sort(relation2TraceClasses2);
        for (Relation2TraceClass relation2TraceClass : relation2TraceClasses2) {
            relation2TraceClass.installConsumesDependencies();
        }
        if (QVTr2QVTc.CALL_TREE.isActive()) {
            s = new StringBuilder();
            for (Relation2TraceClass relation2TraceClasses : relation2TraceClasses2) {
                s.append("\n\t" + relation2TraceClasses.toString() + "(");
                isFirst = true;
                consumedRelation2TraceClasses = Lists.newArrayList(relation2TraceClasses.getConsumedRelation2TraceClasses());
                Collections.sort(consumedRelation2TraceClasses);
                for (Relation2TraceClass consumedRelation2TraceClass : consumedRelation2TraceClasses) {
                    if (!isFirst) {
                        s.append(",");
                    }
                    s.append(consumedRelation2TraceClass.toString());
                    isFirst = false;
                }
                s.append(")");
            }
            QVTr2QVTc.CALL_TREE.println("traceClass(directlyConsumedTraceClasses)" + s.toString());
        }
        if (QVTr2QVTc.CALL_TREE.isActive()) {
            s = new StringBuilder();
            for (Relation2TraceClass relation2TraceClass : relation2TraceClasses2) {
                s.append("\n\t" + relation2TraceClass.toString() + "(");
                isFirst = true;
                consumedRelation2TraceClasses = new ArrayList<Relation2TraceClass>(relation2TraceClass.getTransitivelyConsumedRelation2TraceClasses());
                Collections.sort(consumedRelation2TraceClasses);
                for (Relation2TraceClass consumedRelation2TraceClass : consumedRelation2TraceClasses) {
                    if (!isFirst) {
                        s.append(",");
                    }
                    s.append(consumedRelation2TraceClass.toString());
                    isFirst = false;
                }
                s.append(")");
            }
            QVTr2QVTc.CALL_TREE.println("traceClass(transitivelyConsumedTraceClasses)" + s.toString());
        }
        if (QVTr2QVTc.CALL_TREE.isActive()) {
            s = new StringBuilder();
            for (Relation2TraceClass relation2TraceClasses : relation2TraceClasses2) {
                s.append("\n\t" + relation2TraceClasses.toString() + "(");
                isFirst = true;
                consumedByRelation2TraceClasses = Lists.newArrayList(relation2TraceClasses.getConsumedByRelation2TraceClasses());
                Collections.sort(consumedByRelation2TraceClasses);
                for (Relation2TraceClass consumedByRelation2TraceClass : consumedByRelation2TraceClasses) {
                    if (!isFirst) {
                        s.append(",");
                    }
                    s.append(consumedByRelation2TraceClass.toString());
                    isFirst = false;
                }
                s.append(")");
            }
            QVTr2QVTc.CALL_TREE.println("traceClass(directlyConsumedByTraceClasses)" + s.toString());
        }
        if (QVTr2QVTc.CALL_TREE.isActive()) {
            s = new StringBuilder();
            for (Relation2TraceClass relation2TraceClasses : relation2TraceClasses2) {
                s.append("\n\t" + relation2TraceClasses.toString() + "(");
                isFirst = true;
                consumedByRelation2TraceClasses = new ArrayList<Relation2TraceClass>(relation2TraceClasses.getTransitivelyConsumedByRelation2TraceClasses());
                Collections.sort(consumedByRelation2TraceClasses);
                for (Relation2TraceClass consumedByRelation2TraceClass : consumedByRelation2TraceClasses) {
                    if (!isFirst) {
                        s.append(",");
                    }
                    s.append(consumedByRelation2TraceClass.toString());
                    isFirst = false;
                }
                s.append(")");
            }
            QVTr2QVTc.CALL_TREE.println("traceClass(transitivelyConsumedByTraceClasses)" + s.toString());
        }
        if (QVTr2QVTc.CALL_TREE.isActive()) {
            s = new StringBuilder();
            for (Relation2TraceClass relation2TraceClasses : relation2TraceClasses2) {
                s.append("\n\t" + relation2TraceClasses.toString() + "(");
                isFirst = true;
                @NonNull ArrayList cyclicRelation2TraceClasses = Lists.newArrayList(relation2TraceClasses.getCyclicRelation2TraceClasses());
                Collections.sort(cyclicRelation2TraceClasses);
                for (Relation2TraceClass cyclicRelation2TraceClass : cyclicRelation2TraceClasses) {
                    if (!isFirst) {
                        s.append(",");
                    }
                    s.append(cyclicRelation2TraceClass.toString());
                    isFirst = false;
                }
                s.append(")");
            }
            QVTr2QVTc.CALL_TREE.println("traceClass(cyclicTraceClasses)" + s.toString());
        }
    }

    protected void createRelation2TraceClass(@NonNull Relation rRelation) {
        Relation2TraceClass relation2traceClass = this.relation2relation2traceClass.get(rRelation);
        assert (relation2traceClass == null);
        relation2traceClass = rRelation.isIsTopLevel() ? new TopRelation2TraceClass(this, rRelation) : new NonTopRelation2TraceClass(this, rRelation);
        this.qvtr2qvtc.putRelationTrace(rRelation, relation2traceClass.getTraceClass());
        this.relation2relation2traceClass.put(rRelation, relation2traceClass);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void createRelation2TraceClasses() {
        @NonNull Iterable rRelations = QVTrelationUtil.getOwnedRelations((RelationalTransformation)this.rTransformation);
        for (Relation rRelation : rRelations) {
            this.createRelation2TraceClass(rRelation);
        }
        for (Relation rRelation : rRelations) {
            Relation2TraceClass relation2TraceClass = this.getRelation2TraceClass(rRelation);
            relation2TraceClass.analyzeInheritance();
        }
        for (Relation rRelation : rRelations) {
            Relation2TraceClass invokedRelation2TraceClass;
            Relation invokedRelation;
            Relation2TraceClass invokingRelation2TraceClass = this.getRelation2TraceClass(rRelation);
            for (RelationCallExp whenInvocation : invokingRelation2TraceClass.getWhenInvocations()) {
                invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)whenInvocation);
                if (invokedRelation.isIsTopLevel()) continue;
                invokedRelation2TraceClass = this.getRelation2TraceClass(invokedRelation);
                invokedRelation2TraceClass.getSignatureClass();
            }
            for (RelationCallExp whereInvocation : invokingRelation2TraceClass.getWhereInvocations()) {
                invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)whereInvocation);
                if (invokedRelation.isIsTopLevel()) continue;
                invokedRelation2TraceClass = this.getRelation2TraceClass(invokedRelation);
                invokedRelation2TraceClass.getSignatureClass();
            }
        }
    }

    protected @NonNull Package createTracePackage() {
        Package rPackage = this.rTransformation.getOwningPackage();
        Package tracePackage = PivotFactory.eINSTANCE.createPackage();
        tracePackage.setName("P" + this.rTransformation.getName());
        tracePackage.setNsPrefix("P" + this.rTransformation.getName());
        StringBuilder sURI = new StringBuilder();
        this.getURI(rPackage, sURI);
        tracePackage.setURI(String.valueOf(sURI.toString()) + "/" + this.rTransformation.getName());
        this.qvtr2qvtc.putTracePackage(this.rTransformation, tracePackage);
        return tracePackage;
    }

    protected @NonNull Class getBagType(@NonNull Class traceClass) {
        return this.qvtr2qvtc.getEnvironmentFactory().getCompleteEnvironment().getBagType((Type)traceClass, true, null, null);
    }

    public @NonNull QVTrNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    protected @NonNull Relation2TraceClass getRelation2TraceClass(@NonNull Relation rRelation) {
        return (Relation2TraceClass)ClassUtil.nonNullState((Object)this.relation2relation2traceClass.get(rRelation));
    }

    public @NonNull Class getSignatureClass(@NonNull Relation rRelation) {
        return this.getRelation2TraceClass(rRelation).getSignatureClass();
    }

    public @NonNull Property getSignatureProperty(@NonNull Class aClass, @NonNull VariableDeclaration rVariable) {
        Relation2TraceClass relation2TraceClass = this.traceClass2relation2traceClass.get(aClass);
        assert (relation2TraceClass != null);
        return relation2TraceClass.getSignatureProperty(rVariable);
    }

    public @NonNull Class getTraceClass(@NonNull Relation rRelation) {
        return this.getRelation2TraceClass(rRelation).getTraceClass();
    }

    public @NonNull Property getTraceProperty(@NonNull RelationCallExp rInvocation) {
        Relation2TraceClass relation2TraceClass = this.getRelation2TraceClass(QVTrelationUtil.getContainingRelation((EObject)rInvocation));
        return relation2TraceClass.getTraceProperty(rInvocation);
    }

    protected @NonNull String getUniqueTraceClassName(@NonNull Relation2TraceClass mapping2traceClass, @NonNull String name) {
        return this.getNameGenerator().getUniqueName(this.name2relation2traceClass, name, mapping2traceClass);
    }

    private String getURI(Package rPackage, @NonNull StringBuilder s) {
        if (rPackage == null) {
            s.append("http://www.eclipse.org/qvtd-example");
        } else if (rPackage.getURI() != null) {
            s.append(rPackage.getURI());
        } else {
            this.getURI(rPackage.getOwningPackage(), s);
            s.append("/");
            s.append(rPackage.getName());
        }
        return null;
    }

    protected void synthesizeTraceClasses() {
        ArrayList<@NonNull Class> traceClasses = new ArrayList<Class>(this.name2relation2traceClass.size());
        for (Relation2TraceClass relation2TraceClass : new HashSet<Relation2TraceClass>(this.name2relation2traceClass.values())) {
            relation2TraceClass.synthesize();
            Class traceClass = relation2TraceClass.getTraceClass();
            traceClasses.add(traceClass);
            this.traceClass2relation2traceClass.put((Type)traceClass, relation2TraceClass);
            Class signatureClass = relation2TraceClass.basicGetSignatureClass();
            if (signatureClass == null) continue;
            traceClasses.add(signatureClass);
            this.traceClass2relation2traceClass.put((Type)signatureClass, relation2TraceClass);
        }
        CompilerUtil.normalizeNameables(traceClasses);
        this.tracePackage.getOwnedClasses().addAll(traceClasses);
    }

    public String toString() {
        return this.rTransformation.toString();
    }

    public @NonNull Package transform() throws CompilerChainException {
        this.createRelation2TraceClasses();
        this.analyzeTraceClasses();
        this.createDependencies();
        this.synthesizeTraceClasses();
        return this.tracePackage;
    }
}

