/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.qvtd.runtime.evaluation.AbstractConnection;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.SimpleConnection;
import org.eclipse.qvtd.runtime.evaluation.SimpleIncrementalConnection;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.evaluation.StrictConnection;
import org.eclipse.qvtd.runtime.evaluation.StrictIncrementalConnection;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractConnectionInternal;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractIncrementalConnectionInternal;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractInvocationInternal;

public abstract class AbstractIntervalInternal
implements Interval {
    protected final boolean debugInvocations = AbstractTransformer.INVOCATIONS.isActive();
    protected final @NonNull InvocationManager invocationManager;
    protected final int intervalIndex;
    private @Nullable AbstractConnection headConnection = null;
    private @Nullable AbstractConnection tailConnection = null;
    private @NonNull List<@NonNull Connection> connections = new ArrayList<Connection>();
    private @Nullable AbstractInvocationInternal blockedInvocations = null;
    private @Nullable AbstractInvocationInternal waitingInvocations = null;

    public AbstractIntervalInternal(@NonNull InvocationManager invocationManager, int intervalIndex) {
        this.invocationManager = invocationManager;
        this.intervalIndex = intervalIndex;
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitInterval(this);
    }

    private synchronized void block(@NonNull Invocation invocation, @NonNull SlotState slotState) {
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.debug_blockedBy == null);
        assert (castInvocation.next == castInvocation);
        assert (castInvocation.prev == castInvocation);
        assert (this.blockedInvocations != castInvocation);
        assert (this.waitingInvocations != castInvocation);
        castInvocation.debug_blockedBy = slotState;
        AbstractInvocationInternal blockedInvocations2 = this.blockedInvocations;
        if (blockedInvocations2 == null) {
            this.blockedInvocations = castInvocation;
        } else {
            castInvocation.insertAfter(blockedInvocations2.prev);
        }
        slotState.block(invocation);
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("block " + invocation + " for " + slotState);
        }
    }

    @Override
    public @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
        AbstractConnectionInternal connection = isStrict ? new StrictConnection(this, name, typeId) : new SimpleConnection(this, name, typeId);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public @NonNull Connection.Incremental createIncrementalConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
        AbstractIncrementalConnectionInternal connection = isStrict ? new StrictIncrementalConnection(this, name, typeId) : new SimpleIncrementalConnection(this, name, typeId);
        this.connections.add(connection);
        return connection;
    }

    public synchronized void destroy(@NonNull Invocation invocation) {
        AbstractInvocationInternal prevInvocation;
        assert (invocation.getInterval() == this);
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("destroy " + invocation);
        }
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (this.blockedInvocations != castInvocation);
        if (this.waitingInvocations == castInvocation) {
            this.waitingInvocations = castInvocation.next;
            if (this.waitingInvocations == castInvocation) {
                this.waitingInvocations = null;
            }
        }
        if ((prevInvocation = castInvocation.prev) != castInvocation) {
            AbstractInvocationInternal nextInvocation;
            prevInvocation.next = nextInvocation = castInvocation.next;
            nextInvocation.prev = prevInvocation;
            castInvocation.next = castInvocation;
            castInvocation.prev = castInvocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() {
        while (this.headConnection != null) {
            AbstractConnection nextConnection2;
            AbstractIntervalInternal abstractIntervalInternal = this;
            synchronized (abstractIntervalInternal) {
                nextConnection2 = this.headConnection;
                if (nextConnection2 != null) {
                    this.headConnection = nextConnection2.getNextConnection();
                    if (this.headConnection == null) {
                        this.tailConnection = null;
                    }
                    nextConnection2.resetQueued();
                }
            }
            if (nextConnection2 == null) continue;
            nextConnection2.propagate();
        }
        while (this.waitingInvocations != null) {
            AbstractInvocationInternal invocation = null;
            AbstractIntervalInternal abstractIntervalInternal = this;
            synchronized (abstractIntervalInternal) {
                AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
                if (waitingInvocations2 != null) {
                    invocation = waitingInvocations2;
                    this.waitingInvocations = waitingInvocations2.next;
                    if (this.waitingInvocations == invocation) {
                        this.waitingInvocations = null;
                    }
                    invocation.remove();
                }
            }
            if (invocation == null) continue;
            if (this.debugInvocations) {
                AbstractTransformer.INVOCATIONS.println("invoke " + invocation);
            }
            try {
                boolean success = invocation.execute();
                if (!this.debugInvocations) continue;
                AbstractTransformer.INVOCATIONS.println(String.valueOf(success ? "done " : "fail ") + invocation);
            }
            catch (InvocationFailedException e) {
                this.block(invocation, e.slotState);
            }
        }
        AbstractInvocationInternal blockedInvocation = this.blockedInvocations;
        if (blockedInvocation == null) {
            return true;
        }
        do {
            if (!this.debugInvocations) continue;
            AbstractTransformer.INVOCATIONS.println("still blocked " + blockedInvocation + " by " + blockedInvocation.debug_blockedBy);
        } while ((blockedInvocation = blockedInvocation.next) != this.blockedInvocations);
        return false;
    }

    @Override
    public @NonNull Iterable<@NonNull Connection> getConnections() {
        return this.connections;
    }

    @Override
    public int getIndex() {
        return this.intervalIndex;
    }

    @Override
    public @NonNull InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    @Override
    public @NonNull String getName() {
        return String.valueOf(this.intervalIndex);
    }

    @Override
    public boolean isFlushed() {
        if (this.tailConnection != null) {
            return false;
        }
        if (this.blockedInvocations != null) {
            return false;
        }
        return this.waitingInvocations == null;
    }

    public void queue() {
        this.invocationManager.setWorkToDoAt(this.intervalIndex);
    }

    @Override
    public synchronized void queue(@NonNull Connection connection) {
        AbstractConnection connection2 = (AbstractConnection)connection;
        AbstractConnection tailConnection2 = this.tailConnection;
        if (tailConnection2 == null) {
            assert (this.headConnection == null);
            assert (connection2.getNextConnection() == null);
            this.headConnection = connection2;
        } else {
            assert (this.headConnection != null);
            if (connection2.getNextConnection() != null) {
                return;
            }
            tailConnection2.setNextConnection(connection2);
        }
        this.tailConnection = connection2;
        this.queue();
    }

    @Override
    public synchronized void queue(@NonNull Invocation invocation) {
        assert (invocation.getInterval() == this);
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("queue " + invocation);
        }
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.debug_blockedBy == null);
        assert (this.blockedInvocations != castInvocation);
        AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
        if (waitingInvocations2 == null) {
            this.waitingInvocations = castInvocation;
        } else {
            castInvocation.insertAfter(waitingInvocations2.prev);
        }
        this.queue();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("<");
        s.append(this.intervalIndex);
        s.append("> ");
        int i = 0;
        AbstractConnection aConnection = this.headConnection;
        while (aConnection != null) {
            if (++i > 100) {
                i = 999999;
                break;
            }
            aConnection = aConnection.getNextConnection();
        }
        s.append(i);
        s.append(" connections, ");
        int j = 0;
        AbstractInvocationInternal blockedInvocation = this.blockedInvocations;
        if (blockedInvocation != null) {
            ++j;
            while ((blockedInvocation = blockedInvocation.next) != this.blockedInvocations) {
                if (++j <= 100) continue;
                j = 999999;
                break;
            }
        }
        s.append(j);
        s.append(" blocked, ");
        int k = 0;
        AbstractInvocationInternal waitingInvocation = this.waitingInvocations;
        if (waitingInvocation != null) {
            ++k;
            while ((waitingInvocation = waitingInvocation.next) != this.waitingInvocations) {
                if (++k <= 100) continue;
                k = 999999;
                break;
            }
        }
        s.append(k);
        s.append(" waiting");
        return s.toString();
    }

    @Override
    public synchronized void unblock(@NonNull Invocation invocation) {
        if (this.debugInvocations) {
            AbstractTransformer.INVOCATIONS.println("unblock " + invocation);
        }
        AbstractInvocationInternal castInvocation = (AbstractInvocationInternal)invocation;
        assert (castInvocation.debug_blockedBy != null);
        castInvocation.debug_blockedBy = null;
        if (this.blockedInvocations == castInvocation) {
            this.blockedInvocations = castInvocation.next;
            if (this.blockedInvocations == castInvocation) {
                this.blockedInvocations = null;
            }
        }
        castInvocation.remove();
        AbstractInvocationInternal waitingInvocations2 = this.waitingInvocations;
        if (waitingInvocations2 == null) {
            this.waitingInvocations = castInvocation;
        } else {
            castInvocation.insertAfter(waitingInvocations2.prev);
        }
        this.queue();
    }
}

