/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.utilities;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;

public class QVTbaseUtil
extends PivotUtil {
    public static @Nullable Domain basicGetContainingDomain(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Domain) {
                return (Domain)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable BaseModel basicGetContainingModel(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof BaseModel) {
                return (BaseModel)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Pattern basicGetContainingPattern(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Pattern) {
                return (Pattern)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Rule basicGetContainingRule(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Rule) {
                return (Rule)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Transformation basicGetContainingTransformation(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Transformation) {
                return (Transformation)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static boolean containsAll(@NonNull Iterable<@NonNull ?> iterable1, @NonNull Iterable<@NonNull ?> iterable2) {
        for (Object e : iterable1) {
            if (Iterables.contains(iterable2, e)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(@NonNull Iterable<@NonNull ?> iterable1, @NonNull Iterable<@NonNull ?> iterable2) {
        for (Object e : iterable1) {
            if (!Iterables.contains(iterable2, e)) continue;
            return true;
        }
        return false;
    }

    public static @NonNull List<@NonNull Transformation> getAllTransformations(@NonNull Model asModel) {
        ArrayList<@NonNull Transformation> asTransformations = new ArrayList<Transformation>();
        QVTbaseUtil.getAllTransformations(ClassUtil.nullFree((List)asModel.getOwnedPackages()), asTransformations);
        return asTransformations;
    }

    public static void getAllTransformations(@NonNull List<@NonNull Package> asPackages, @NonNull List<@NonNull Transformation> asTransformations) {
        for (Package asPackage : asPackages) {
            for (Class asClass : ClassUtil.nullFree((List)asPackage.getOwnedClasses())) {
                if (!(asClass instanceof Transformation)) continue;
                asTransformations.add((Transformation)asClass);
            }
            QVTbaseUtil.getAllTransformations(ClassUtil.nullFree((List)asPackage.getOwnedPackages()), asTransformations);
        }
    }

    public static @NonNull Set<@NonNull TypedModel> getAllTypedModels(@NonNull TypedModel typedModel) {
        HashSet<@NonNull TypedModel> allTypedModels = new HashSet<TypedModel>();
        QVTbaseUtil.getAllTypedModelsInternal(allTypedModels, typedModel);
        return allTypedModels;
    }

    private static void getAllTypedModelsInternal(@NonNull Set<TypedModel> allTypedModels, @NonNull TypedModel typedModel) {
        if (allTypedModels.add(typedModel)) {
            for (TypedModel dependsOn : typedModel.getDependsOn()) {
                QVTbaseUtil.getAllTypedModelsInternal(allTypedModels, dependsOn);
            }
        }
    }

    public static @NonNull Set<@NonNull Package> getAllUsedPackages(@NonNull Transformation transformation) {
        HashSet<@NonNull Package> allPackages = new HashSet<Package>();
        for (TypedModel typedModel : transformation.getModelParameter()) {
            QVTbaseUtil.getAllUsedPackagesInternal(allPackages, typedModel);
        }
        return allPackages;
    }

    public static @NonNull Set<@NonNull Package> getAllUsedPackages(@NonNull TypedModel typedModel) {
        HashSet<@NonNull Package> allUsedPackages = new HashSet<Package>();
        QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, typedModel);
        return allUsedPackages;
    }

    private static void getAllUsedPackagesInternal(@NonNull Set<@NonNull Package> allUsedPackages, @NonNull TypedModel typedModel) {
        QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, typedModel.getUsedPackage());
        for (TypedModel dependsOn : typedModel.getDependsOn()) {
            QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, dependsOn);
        }
    }

    private static void getAllUsedPackagesInternal(@NonNull Set<Package> allUsedPackages, @NonNull Iterable<Package> moreUsedPackages) {
        for (Package usedPackage : moreUsedPackages) {
            if (!allUsedPackages.add(usedPackage)) continue;
            QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, usedPackage.getImportedPackages());
        }
    }

    public static @NonNull OCLExpression getConditionExpression(@NonNull Predicate asPredicate) {
        return (OCLExpression)ClassUtil.nonNullState((Object)asPredicate.getConditionExpression());
    }

    public static @NonNull Domain getContainingDomain(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Domain) {
                return (Domain)eObject;
            }
            eObject = eObject.eContainer();
        }
        throw new IllegalStateException();
    }

    public static @NonNull BaseModel getContainingModel(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof BaseModel) {
                return (BaseModel)eObject;
            }
            eObject = eObject.eContainer();
        }
        throw new IllegalStateException();
    }

    public static @NonNull Rule getContainingRule(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Rule) {
                return (Rule)eObject;
            }
            eObject = eObject.eContainer();
        }
        throw new IllegalStateException();
    }

    public static @NonNull Transformation getContainingTransformation(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Transformation) {
                return (Transformation)eObject;
            }
            eObject = eObject.eContainer();
        }
        throw new IllegalStateException();
    }

    public static @NonNull Variable getContextVariable(@NonNull StandardLibrary standardLibrary, @NonNull Transformation transformation) {
        Variable ownedContext = transformation.getOwnedContext();
        if (ownedContext == null) {
            ownedContext = PivotFactory.eINSTANCE.createParameterVariable();
            ownedContext.setName("this");
            ownedContext.setType((Type)transformation);
            ownedContext.setIsRequired(true);
            transformation.setOwnedContext(ownedContext);
        } else {
            ownedContext.setTypeValue((Type)transformation);
        }
        return ownedContext;
    }

    public static @NonNull Variable getContextVariable(@NonNull StandardLibraryInternal standardLibrary, @NonNull TypedModel typedModel) {
        Variable ownedContext = typedModel.getOwnedContext();
        if (ownedContext == null) {
            ownedContext = PivotFactory.eINSTANCE.createParameterVariable();
            ownedContext.setName(typedModel.getName());
            ownedContext.setType((Type)standardLibrary.getLibraryType("Model"));
            ownedContext.setIsRequired(true);
            typedModel.setOwnedContext(ownedContext);
        }
        return ownedContext;
    }

    public static @NonNull Iterable<@NonNull TypedModel> getDependsOns(@NonNull TypedModel qvtrTypedModel) {
        return ClassUtil.nullFree(qvtrTypedModel.getDependsOn());
    }

    public static @Nullable Domain getDomain(@NonNull Rule rule, @NonNull TypedModel typedModel) {
        for (Domain domain : rule.getDomain()) {
            if (domain.getTypedModel() != typedModel) continue;
            return domain;
        }
        return null;
    }

    public static @NonNull Set<@NonNull TypedModel> getEnforceableTypedModels(@NonNull Transformation transformation) {
        HashSet<@NonNull TypedModel> enforceableTypedModels = new HashSet<TypedModel>();
        HashSet<@NonNull TypedModel> notEnforceableTypedModels = new HashSet<TypedModel>();
        for (Rule rule : transformation.getRule()) {
            for (Domain domain : rule.getDomain()) {
                TypedModel typedModel = domain.getTypedModel();
                assert (typedModel != null);
                if (domain.isIsEnforceable()) {
                    enforceableTypedModels.add(typedModel);
                    continue;
                }
                notEnforceableTypedModels.add(typedModel);
            }
        }
        enforceableTypedModels.removeAll(notEnforceableTypedModels);
        return enforceableTypedModels;
    }

    public static @NonNull Iterable<@NonNull VariableDeclaration> getExternalVariables(@NonNull OperationCallExp operationCallExp) {
        ArrayList<@NonNull VariableDeclaration> externalVariables = new ArrayList<VariableDeclaration>();
        for (EObject eObject : new TreeIterable((EObject)operationCallExp, false)) {
            if (!(eObject instanceof VariableExp)) continue;
            VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
            assert (referredVariable != null);
            EObject eContainer = referredVariable.eContainer();
            boolean gotIt = eContainer instanceof Transformation;
            while (!gotIt && eContainer != null) {
                if (eContainer == operationCallExp) {
                    gotIt = true;
                }
                eContainer = eContainer.eContainer();
            }
            if (gotIt || externalVariables.contains(referredVariable)) continue;
            externalVariables.add(referredVariable);
        }
        return externalVariables;
    }

    public static @NonNull Iterable<@NonNull TypedModel> getModelParameters(@NonNull Transformation asTransformation) {
        return ClassUtil.nullFree(asTransformation.getModelParameter());
    }

    public static @NonNull Iterable<@NonNull Operation> getOwnedOperations(@NonNull Transformation asTransformation) {
        return ClassUtil.nullFree((List)asTransformation.getOwnedOperations());
    }

    public static @NonNull Iterable<@NonNull Predicate> getOwnedPredicates(@NonNull Pattern asPattern) {
        return ClassUtil.nullFree(asPattern.getPredicate());
    }

    public static @NonNull OCLExpression getQueryExpression(@NonNull Function asFunction) {
        return (OCLExpression)ClassUtil.nonNullState((Object)asFunction.getQueryExpression());
    }

    public static @NonNull Variable getReferredVariable(@NonNull VariableExp asVariableExp) {
        return (Variable)ClassUtil.nonNullState((Object)asVariableExp.getReferredVariable());
    }

    public static @NonNull List<@NonNull Rule> getRule(@NonNull Transformation asTransformation) {
        return ClassUtil.nullFree(asTransformation.getRule());
    }

    public static @NonNull TypedModel getTypedModel(@NonNull Domain asDomain) {
        return (TypedModel)ClassUtil.nonNullState((Object)asDomain.getTypedModel());
    }

    public static @NonNull Iterable<@NonNull Class> getUsedClasses(@NonNull TypedModel asTypedModel) {
        HashSet<@NonNull Class> usedClasses = new HashSet<Class>();
        for (Package rPackage : ClassUtil.nullFree(asTypedModel.getUsedPackage())) {
            usedClasses.addAll(ClassUtil.nullFree((List)rPackage.getOwnedClasses()));
        }
        return usedClasses;
    }

    public static @NonNull Iterable<@NonNull Package> getUsedPackages(@NonNull TypedModel asTypedModel) {
        return ClassUtil.nullFree(asTypedModel.getUsedPackage());
    }

    public static boolean isIdentification(Operation asOperation) {
        OCLExpression queryExpression;
        return asOperation instanceof Function && (queryExpression = ((Function)asOperation).getQueryExpression()) instanceof ShadowExp;
    }

    public static @NonNull Transformation loadTransformation(@NonNull java.lang.Class<? extends Model> modelClass, @NonNull EnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        ASResource asResource;
        CSResource xtextResource = null;
        if (PivotUtilInternal.isASURI((URI)transformationURI)) {
            asResource = (ASResource)environmentFactory.getMetamodelManager().getASResourceSet().getResource(transformationURI, true);
        } else {
            xtextResource = (CSResource)environmentFactory.getResourceSet().getResource(transformationURI, true);
            if (xtextResource == null) {
                throw new IOException("Failed to load '" + transformationURI + "'");
            }
            String csMessage = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)xtextResource.getErrors())), (String)("Failed to load '" + transformationURI + "'"), (String)"\n");
            if (csMessage != null) {
                throw new IOException(csMessage);
            }
            asResource = xtextResource.getASResource();
        }
        try {
            String asMessage = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)asResource.getErrors())), (String)("Failed to load '" + asResource.getURI() + "'"), (String)"\n");
            if (asMessage != null) {
                throw new IOException(asMessage);
            }
            for (EObject eContent : asResource.getContents()) {
                if (!modelClass.isInstance(eContent)) continue;
                for (Package asPackage : ClassUtil.nullFree((List)((Model)eContent).getOwnedPackages())) {
                    Transformation asTransformation = QVTbaseUtil.loadTransformationRecursion(asPackage);
                    if (asTransformation == null) continue;
                    Transformation transformation = asTransformation;
                    return transformation;
                }
            }
        }
        finally {
            if (!keepDebug && xtextResource instanceof CSResource.CSResourceExtension) {
                ((CSResource.CSResourceExtension)xtextResource).dispose();
            }
        }
        throw new IOException("Failed to locate a transformation in '" + transformationURI + "'");
    }

    private static @Nullable Transformation loadTransformationRecursion(@NonNull Package asPackage) {
        for (Class asClass : ClassUtil.nullFree((List)asPackage.getOwnedClasses())) {
            if (!(asClass instanceof Transformation)) continue;
            return (Transformation)asClass;
        }
        for (Package asNestedPackage : ClassUtil.nullFree((List)asPackage.getOwnedPackages())) {
            Transformation asTransformation = QVTbaseUtil.loadTransformationRecursion(asNestedPackage);
            if (asTransformation == null) continue;
            return asTransformation;
        }
        return null;
    }

    public static @NonNull Resource loadTransformations(@NonNull java.lang.Class<? extends Model> modelClass, @NonNull EnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        ASResource asResource;
        CSResource xtextResource = null;
        if (PivotUtilInternal.isASURI((URI)transformationURI)) {
            asResource = (ASResource)environmentFactory.getMetamodelManager().getASResourceSet().getResource(transformationURI, true);
        } else {
            xtextResource = (CSResource)environmentFactory.getResourceSet().getResource(transformationURI, true);
            if (xtextResource == null) {
                throw new IOException("Failed to load '" + transformationURI + "'");
            }
            String csMessage = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)xtextResource.getErrors())), (String)("Failed to load '" + transformationURI + "'"), (String)"\n");
            if (csMessage != null) {
                throw new IOException(csMessage);
            }
            asResource = xtextResource.getASResource();
        }
        if (asResource == null) {
            throw new IOException("Failed to load '" + transformationURI + "'");
        }
        return asResource;
    }

    public static @Nullable List<@NonNull OperationCallExp> rewriteMissingOperationCallSources(@NonNull EnvironmentFactory environmentFactory, @NonNull Resource asResource) {
        ArrayList<@NonNull OperationCallExp> missingSources = null;
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            OperationCallExp operationCallExp;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof OperationCallExp) || (operationCallExp = (OperationCallExp)eObject).getOwnedSource() != null) continue;
            if (missingSources == null) {
                missingSources = new ArrayList<OperationCallExp>();
            }
            missingSources.add(operationCallExp);
        }
        if (missingSources != null) {
            StandardLibrary standardLibrary = environmentFactory.getStandardLibrary();
            for (OperationCallExp operationCallExp : missingSources) {
                Transformation transformation = QVTbaseUtil.basicGetContainingTransformation((EObject)operationCallExp);
                if (transformation == null) continue;
                Variable thisVariable = QVTbaseUtil.getContextVariable(standardLibrary, transformation);
                operationCallExp.setOwnedSource((OCLExpression)PivotUtil.createVariableExp((VariableDeclaration)thisVariable));
            }
        }
        return missingSources;
    }

    public static /* bridge */ /* synthetic */ VariableDeclaration getReferredVariable(VariableExp variableExp) {
        return QVTbaseUtil.getReferredVariable(variableExp);
    }

    public static /* bridge */ /* synthetic */ Model getContainingModel(EObject eObject) {
        return QVTbaseUtil.getContainingModel(eObject);
    }

    public static final class DomainNameComparator
    implements Comparator<Domain> {
        public static final @NonNull DomainNameComparator INSTANCE = new DomainNameComparator();

        @Override
        public int compare(@NonNull Domain o1, @NonNull Domain o2) {
            TypedModel t1 = o1.getTypedModel();
            TypedModel t2 = o2.getTypedModel();
            String n1 = t1 != null ? t1.getName() : null;
            String n2 = t2 != null ? t2.getName() : null;
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }

    public static class Internal
    extends PivotUtilInternal {
        public static @NonNull List<@NonNull TypedModel> getModelParameterList(@NonNull Transformation asTransformation) {
            return ClassUtil.nullFree(asTransformation.getModelParameter());
        }

        public static @NonNull List<@NonNull Rule> getOverridesList(@NonNull Rule asRule) {
            return ClassUtil.nullFree(asRule.getOverrides());
        }

        public static @NonNull List<@NonNull Predicate> getPredicatesList(@NonNull Pattern asPattern) {
            return ClassUtil.nullFree(asPattern.getPredicate());
        }

        public static @NonNull List<@NonNull Package> getUsedPackagesList(@NonNull TypedModel asTypedModel) {
            return ClassUtil.nullFree(asTypedModel.getUsedPackage());
        }
    }
}

