/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergeableRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergedMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.OperationDatum;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.OperationRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.QVTp2QVTg;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region2Depth;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SuperRegion;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameReservation;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePackage;
import org.eclipse.qvtd.pivot.schedule.AbstractAction;
import org.eclipse.qvtd.pivot.schedule.ClassDatum;
import org.eclipse.qvtd.pivot.schedule.MappingAction;
import org.eclipse.qvtd.pivot.schedule.Schedule;
import org.eclipse.qvtd.pivot.schedule.utilities.DependencyUtil;

public class Scheduler
extends SchedulerConstants {
    public static final @NonNull TracingOption CONNECTION_CREATION = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/connectionCreation");
    public static final @NonNull TracingOption CONNECTION_ROUTING = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/connectionRouting");
    public static final @NonNull TracingOption DEBUG_GRAPHS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/debugGraphs");
    public static final @NonNull TracingOption DEPENDENCY_ANALYSIS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/dependencyAnalysis");
    public static final @NonNull TracingOption DUMP_CLASS_TO_CONSUMING_NODES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/dump/class2consumingNodes");
    public static final @NonNull TracingOption DUMP_CLASS_TO_CONTAINING_PROPERTIES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/dump/class2containingProperty");
    public static final @NonNull TracingOption DUMP_CLASS_TO_REALIZED_NODES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/dump/class2realizedNodes");
    public static final @NonNull TracingOption DUMP_INPUT_MODEL_TO_DOMAIN_USAGE = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/dump/inputModel2domainUsage");
    public static final @NonNull TracingOption DUMP_PROPERTY_TO_CONSUMING_CLASSES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/dump/property2consumingClass");
    public static final @NonNull TracingOption EDGE_ORDER = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/edgeOrder");
    public static final @NonNull TracingOption REGION_CYCLES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/regionCycles");
    public static final @NonNull TracingOption REGION_DEPTH = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/regionDepth");
    public static final @NonNull TracingOption REGION_ORDER = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/regionOrder");
    public static final @NonNull TracingOption REGION_STACK = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/regionStack");
    public static final @NonNull TracingOption REGION_TRAVERSAL = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtp2qvts/regionTraversal");
    private final @NonNull Map<@NonNull AbstractAction, @NonNull SimpleMappingRegion> action2mappingRegion = new HashMap<AbstractAction, SimpleMappingRegion>();
    private final @NonNull List<@NonNull AbstractAction> orderedActions;
    private Map<OperationDatum, OperationRegion> map = new HashMap<OperationDatum, OperationRegion>();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Scheduler(@NonNull EnvironmentFactory environmentFactory, @NonNull Schedule schedule, @NonNull QVTp2QVTg qvtp2qvtg) {
        super(environmentFactory, schedule, qvtp2qvtg);
        DependencyUtil.NaturalOrderer orderer = new DependencyUtil.NaturalOrderer(schedule);
        @NonNull List orderedActions = orderer.computeOrdering();
        if (orderedActions == null) {
            throw new IllegalArgumentException(orderer.diagnoseOrderingFailure());
        }
        this.orderedActions = orderedActions;
    }

    public @NonNull OperationRegion analyzeOperation(@NonNull SuperRegion superRegion, @NonNull OperationCallExp operationCallExp) {
        Operation operation = operationCallExp.getReferredOperation();
        LanguageExpression bodyExpression = operation.getBodyExpression();
        assert (bodyExpression != null);
        try {
            ExpressionInOCL specification = this.getEnvironmentFactory().getMetamodelManager().parseSpecification(bodyExpression);
            OperationDatum operationDatum = this.createOperationDatum(operationCallExp);
            OperationRegion operationRegion = this.map.get(operationDatum);
            if (operationRegion == null) {
                operationRegion = new OperationRegion(superRegion, operationDatum, specification, operationCallExp);
                this.map.put(operationDatum, operationRegion);
                if (DEBUG_GRAPHS.isActive()) {
                    operationRegion.writeDebugGraphs("1-create");
                }
            }
            return operationRegion;
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    private @NonNull OperationDatum createOperationDatum(@NonNull OperationCallExp operationCallExp) {
        List ownedArguments = operationCallExp.getOwnedArguments();
        @NonNull ClassDatum[] classDatums = new ClassDatum[1 + ownedArguments.size()];
        int i = 0;
        @NonNull OCLExpression source = operationCallExp.getOwnedSource();
        classDatums[i++] = this.getClassDatum((TypedElement)source);
        for (OCLExpression argument : ownedArguments) {
            classDatums[i++] = this.getClassDatum((TypedElement)argument);
        }
        String operationName = operationCallExp.getReferredOperation().getName();
        assert (operationName != null);
        return new OperationDatum(this, operationName, classDatums);
    }

    @Override
    protected @NonNull ClassDatumAnalysis createClassDatumAnalysis(@NonNull ClassDatum classDatum) {
        return new ClassDatumAnalysis(this, classDatum);
    }

    private @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull HeadNodeGroup> createHeadGroups() {
        HashMap<@NonNull ClassDatumAnalysis, @NonNull HeadNodeGroup> classDatumAnalysis2headGroup = new HashMap<ClassDatumAnalysis, HeadNodeGroup>();
        for (SimpleMappingRegion mappingRegion : this.action2mappingRegion.values()) {
            List<@NonNull Node> headNodes = mappingRegion.getHeadNodes();
            if (headNodes.size() != 1) continue;
            Node headNode = headNodes.get(0);
            HeadNodeGroup headNodeGroup = (HeadNodeGroup)classDatumAnalysis2headGroup.get(headNode.getClassDatumAnalysis());
            if (headNodeGroup == null) {
                headNodeGroup = new HeadNodeGroup();
            }
            headNodeGroup.addMappingRegion(mappingRegion, headNodes);
            classDatumAnalysis2headGroup.put(headNode.getClassDatumAnalysis(), headNodeGroup);
        }
        return classDatumAnalysis2headGroup;
    }

    private @NonNull List<@NonNull Region> createSuperRegions() {
        SuperRegion superRegion = new SuperRegion(this);
        int i = 0;
        while (i < this.orderedActions.size()) {
            @NonNull AbstractAction abstractAction = this.orderedActions.get(i);
            if (abstractAction instanceof MappingAction) {
                MappingAction mappingAction = (MappingAction)abstractAction;
                SimpleMappingRegion mappingRegion = new SimpleMappingRegion(superRegion, mappingAction, i);
                this.action2mappingRegion.put(abstractAction, mappingRegion);
            }
            ++i;
        }
        ArrayList<@NonNull SimpleMappingRegion> mappingRegions = new ArrayList<SimpleMappingRegion>(this.action2mappingRegion.values());
        Collections.sort(mappingRegions, NameUtil.NAMEABLE_COMPARATOR);
        for (SimpleMappingRegion mappingRegion : mappingRegions) {
            mappingRegion.registerConsumptionsAndProductions();
        }
        if (DEBUG_GRAPHS.isActive()) {
            for (SimpleMappingRegion mappingRegion : mappingRegions) {
                mappingRegion.writeDebugGraphs("1-create");
            }
        }
        Map<@NonNull ClassDatumAnalysis, @NonNull HeadNodeGroup> classDatumAnalysis2headNodeGroup = this.createHeadGroups();
        ArrayList<@NonNull SimpleMappingRegion> orderedRegions = new ArrayList<SimpleMappingRegion>();
        for (AbstractAction abstractAction : this.orderedActions) {
            SimpleMappingRegion mappingRegion = this.action2mappingRegion.get(abstractAction);
            assert (mappingRegion != null);
            orderedRegions.add(mappingRegion);
            mappingRegion.resolveRecursion();
        }
        ArrayList<@NonNull Region> allRegions = new ArrayList<Region>(this.earlyRegionMerge(orderedRegions));
        for (OperationRegion operationRegion : superRegion.getOperationRegions()) {
            allRegions.add(operationRegion);
        }
        return allRegions;
    }

    private @NonNull RootScheduledRegion createRootRegion(@NonNull List<@NonNull Region> allRegions) {
        AbstractScheduledRegion rootRegion = null;
        for (Region region : new ArrayList<Region>(allRegions)) {
            if (region.getInvokingRegion() != null) continue;
            if (rootRegion == null) {
                String name = (String)ClassUtil.nonNullState((Object)this.getDependencyGraph().eResource().getURI().trimFileExtension().trimFileExtension().lastSegment());
                rootRegion = new RootScheduledRegion(name, region);
            }
            rootRegion.addRegion(region);
        }
        assert (rootRegion != null);
        return rootRegion;
    }

    public @NonNull List<@NonNull Region> earlyRegionMerge(@NonNull List<@NonNull SimpleMappingRegion> orderedRegions) {
        Region2Depth region2depths = new Region2Depth();
        ArrayList<@NonNull Region> outputRegions = new ArrayList<Region>();
        LinkedHashSet<@NonNull SimpleMappingRegion> residualInputRegions = new LinkedHashSet<SimpleMappingRegion>(orderedRegions);
        while (!residualInputRegions.isEmpty()) {
            List<Region> secondaryRegions;
            @NonNull Region candidateRegion = (Region)residualInputRegions.iterator().next();
            boolean isMerged = false;
            if (this.isEarlyMergePrimaryCandidate(candidateRegion) && (secondaryRegions = this.selectSecondaryRegions(candidateRegion)) != null) {
                Region primaryRegion = candidateRegion;
                AbstractRegion mergedRegion = null;
                for (Region secondaryRegion : secondaryRegions) {
                    boolean isSharedHead;
                    Map<Node, Node> secondaryNode2primaryNode;
                    assert (secondaryRegion != null);
                    if (!residualInputRegions.contains(secondaryRegion) || (secondaryNode2primaryNode = primaryRegion.canMerge(secondaryRegion, region2depths, false)) == null || (isSharedHead = this.isSharedHead(primaryRegion, secondaryRegion)) && secondaryRegion.canMerge(primaryRegion, region2depths, false) == null) continue;
                    if (mergedRegion == null) {
                        mergedRegion = new MergedMappingRegion((MergeableRegion)primaryRegion);
                        residualInputRegions.remove(primaryRegion);
                        primaryRegion = mergedRegion;
                    }
                    ((MergedMappingRegion)mergedRegion).mergeRegion(secondaryRegion, secondaryNode2primaryNode);
                    residualInputRegions.remove(secondaryRegion);
                    region2depths.addRegion(mergedRegion);
                }
                if (mergedRegion != null) {
                    if (DEBUG_GRAPHS.isActive()) {
                        mergedRegion.writeDebugGraphs("2-merged");
                    }
                    outputRegions.add(mergedRegion);
                    isMerged = true;
                }
            }
            if (!isMerged) {
                outputRegions.add(candidateRegion);
            }
            residualInputRegions.remove(candidateRegion);
        }
        return outputRegions;
    }

    public @NonNull SimpleMappingRegion getMappingRegion(@NonNull AbstractAction action) {
        SimpleMappingRegion mappingRegion = this.action2mappingRegion.get(action);
        assert (mappingRegion != null);
        return mappingRegion;
    }

    private boolean isEarlyMergePrimaryCandidate(@NonNull Region mappingRegion) {
        List<@NonNull Node> headNodes = mappingRegion.getHeadNodes();
        return headNodes.size() == 1;
    }

    private boolean isEarlyMergeSecondaryCandidate(@NonNull Region primaryRegion, @NonNull Region secondaryRegion, @NonNull Set<ClassDatumAnalysis> toOneReachableClasses) {
        Node classNode;
        ClassDatumAnalysis classDatumAnalysis;
        List<@NonNull Node> secondaryHeadNodes = secondaryRegion.getHeadNodes();
        return secondaryHeadNodes.size() == 1 && toOneReachableClasses.contains(classDatumAnalysis = (classNode = secondaryHeadNodes.get(0)).getClassDatumAnalysis());
    }

    private boolean isSharedHead(@NonNull Region primaryRegion, @NonNull Region secondaryRegion) {
        for (Node primaryHead : primaryRegion.getHeadNodes()) {
            ClassDatumAnalysis primaryClassDatumAnalysis = primaryHead.getClassDatumAnalysis();
            for (Node secondaryHead : secondaryRegion.getHeadNodes()) {
                if (primaryClassDatumAnalysis != secondaryHead.getClassDatumAnalysis()) continue;
                return true;
            }
        }
        return false;
    }

    public @NonNull RootScheduledRegion qvtp2qvts() throws IOException {
        List<@NonNull Region> allRegions = this.createSuperRegions();
        RootScheduledRegion rootRegion = this.createRootRegion(allRegions);
        rootRegion.createSchedule();
        return rootRegion;
    }

    public @NonNull Resource qvts2qvti(@NonNull RootScheduledRegion scheduledRegion, @NonNull URI qvtiURI, @NonNull SymbolNameReservation symbolNameReservation) {
        Transformation qvtiTransformation;
        Transformation transformation = this.getTransformation();
        QVTs2QVTiVisitor visitor = new QVTs2QVTiVisitor(this.getEnvironmentFactory(), transformation, symbolNameReservation);
        Transformation qvtiChild = qvtiTransformation = (Transformation)scheduledRegion.accept(visitor);
        Package qvtpPackage = transformation.getOwningPackage();
        while (qvtpPackage != null) {
            @NonNull Package qvtiPackage = visitor.createPackage((String)ClassUtil.nonNull((Object)qvtpPackage.getName()), qvtpPackage.getNsPrefix(), qvtpPackage.getURI());
            if (qvtiChild instanceof Transformation) {
                qvtiPackage.getOwnedClasses().add(qvtiChild);
            } else {
                qvtiPackage.getOwnedPackages().add((Package)qvtiChild);
            }
            qvtiChild = qvtiPackage;
            qvtpPackage = qvtpPackage.getOwningPackage();
        }
        Model model = PivotUtil.createModel(ImperativeModel.class, (EClass)QVTimperativePackage.Literals.IMPERATIVE_MODEL, null);
        model.getOwnedPackages().add((Package)qvtiChild);
        HashSet<@NonNull Object> importedNamespaces = new HashSet<Object>();
        for (EObject eObject : new TreeIterable((EObject)model, false)) {
            Property property;
            Package asPackage;
            Class asClass;
            if (eObject instanceof TypedModel) {
                for (Namespace namespace : ClassUtil.nullFree((EList)((TypedModel)eObject).getUsedPackage())) {
                    if (importedNamespaces.contains(namespace)) continue;
                    importedNamespaces.add(namespace);
                }
                continue;
            }
            if (eObject instanceof OperationCallExp) {
                Operation operation = ((OperationCallExp)eObject).getReferredOperation();
                if (operation == null || (asClass = operation.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
                importedNamespaces.add(asPackage);
                continue;
            }
            if (eObject instanceof LoopExp) {
                Iteration iteration = ((LoopExp)eObject).getReferredIteration();
                if (iteration == null || (asClass = iteration.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
                importedNamespaces.add(asPackage);
                continue;
            }
            if (eObject instanceof PropertyCallExp) {
                Property property2 = ((PropertyCallExp)eObject).getReferredProperty();
                if (property2 == null || (asClass = property2.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
                importedNamespaces.add(asPackage);
                continue;
            }
            if (!(eObject instanceof OppositePropertyCallExp) || (property = ((OppositePropertyCallExp)eObject).getReferredProperty()) == null || (asClass = property.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
            importedNamespaces.add(asPackage);
        }
        ArrayList<@NonNull E> sortedImportedNamespaces = new ArrayList(importedNamespaces);
        Collections.sort(sortedImportedNamespaces, NameUtil.NAMEABLE_COMPARATOR);
        List ownedImports = model.getOwnedImports();
        for (Namespace namespace : importedNamespaces) {
            ownedImports.add(visitor.createImport(null, namespace));
        }
        assert (model != null);
        model.setExternalURI(qvtiURI.toString());
        Resource resource = this.getDependencyGraph().eResource();
        Resource resource2 = resource.getResourceSet().createResource(qvtiURI);
        resource2.getContents().add((Object)model);
        return resource2;
    }

    private @Nullable List<@NonNull Region> selectSecondaryRegions(@NonNull Region primaryRegion) {
        HashSet<@NonNull Region> allConsumingRegions = new HashSet<Region>();
        allConsumingRegions.add(primaryRegion);
        HashSet<@NonNull ClassDatumAnalysis> toOneReachableClasses = new HashSet<ClassDatumAnalysis>();
        ArrayList<Region> secondaryRegions = null;
        ArrayList<@NonNull Region> allConsumingRegionsList = new ArrayList<Region>(allConsumingRegions);
        int i = 0;
        while (i < allConsumingRegionsList.size()) {
            @NonNull Region secondaryRegion = (Region)allConsumingRegionsList.get(i);
            if (i == 0 || this.isEarlyMergeSecondaryCandidate(primaryRegion, secondaryRegion, toOneReachableClasses)) {
                if (i > 0) {
                    if (secondaryRegions == null) {
                        secondaryRegions = new ArrayList<Region>();
                    }
                    secondaryRegions.add(secondaryRegion);
                }
                for (Node predicatedNode : secondaryRegion.getMatchableNodes()) {
                    ClassDatumAnalysis predicatedClassDatumAnalysis;
                    if (!predicatedNode.isClassNode() || !toOneReachableClasses.add(predicatedClassDatumAnalysis = predicatedNode.getClassDatumAnalysis())) continue;
                    for (Region consumingRegion : predicatedClassDatumAnalysis.getConsumingRegions()) {
                        if (!allConsumingRegions.add(consumingRegion)) continue;
                        allConsumingRegionsList.add(consumingRegion);
                    }
                }
                if (secondaryRegion instanceof SimpleMappingRegion) {
                    for (Node assignedNode : ((SimpleMappingRegion)secondaryRegion).getComputedNodes()) {
                        ClassDatumAnalysis consumingClassDatumAnalysis;
                        if (!assignedNode.isClassNode() || !toOneReachableClasses.add(consumingClassDatumAnalysis = assignedNode.getClassDatumAnalysis())) continue;
                        for (Region consumingRegion : consumingClassDatumAnalysis.getConsumingRegions()) {
                            if (!allConsumingRegions.add(consumingRegion)) continue;
                            allConsumingRegionsList.add(consumingRegion);
                        }
                    }
                }
            }
            ++i;
        }
        assert (allConsumingRegionsList.size() == allConsumingRegions.size());
        return secondaryRegions;
    }
}

