/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.CallTreeBuilder;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Connection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.DatumConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduleCache;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;

public abstract class ScheduleState
extends ScheduleCache {
    private final @NonNull Set<@NonNull Region> blockedRegions = new HashSet<Region>();
    private final @NonNull Set<@NonNull Region> mandatoryBlockedRegions = new HashSet<Region>();
    private final @NonNull Set<@NonNull Region> unblockedRegions = new HashSet<Region>();
    private final @NonNull Map<@NonNull Region, @NonNull Integer> callableRegion2blockedConnectionCount = new HashMap<Region, Integer>();
    private final @NonNull Map<@NonNull DatumConnection, @NonNull Map<@NonNull Region, @NonNull Boolean>> connection2sourceRegion2hasContent = new HashMap<DatumConnection, Map<Region, Boolean>>();
    private final @NonNull List<@NonNull Region> orderedRegions = new ArrayList<Region>();
    private final @NonNull Set<@NonNull Connection> blockedConnections = new HashSet<Connection>();
    private final @NonNull Set<@NonNull ScheduledRegion> blockedScheduledRegions = new HashSet<ScheduledRegion>();

    protected ScheduleState(@NonNull RootScheduledRegion rootScheduledRegion) {
        super(rootScheduledRegion);
        this.blockedRegions.addAll(this.callableRegions);
        for (Region region : this.callableRegions) {
            if (!(region instanceof ScheduledRegion)) continue;
            ScheduledRegion innerScheduledRegion = (ScheduledRegion)region;
            this.blockedScheduledRegions.add(innerScheduledRegion);
        }
        for (Region region : this.callableRegions) {
            this.analyzeInitialConnectionContent(region);
        }
        for (Region region : this.callableRegions) {
            Iterable<@NonNull DatumConnection> incomingConnections = this.getIncomingConnections(region);
            assert (incomingConnections != null);
            for (DatumConnection connection : incomingConnections) {
                Map<@NonNull Region, @NonNull Boolean> sourceRegion2hasContent = this.connection2sourceRegion2hasContent.get(connection);
                assert (sourceRegion2hasContent != null);
            }
        }
        Iterables.addAll(this.blockedConnections, this.getConnections());
        for (Region region : this.callableRegions) {
            this.refreshRegionBlockage(region);
        }
    }

    private void analyzeInitialConnectionContent(@NonNull Region region) {
        boolean hasMandatoryUsedConnection = false;
        for (DatumConnection connection : this.getIncomingConnections(region)) {
            Map<Region, Boolean> sourceRegion2hasContent;
            if (connection.isMandatory()) {
                hasMandatoryUsedConnection = true;
            }
            if ((sourceRegion2hasContent = this.connection2sourceRegion2hasContent.get(connection)) != null) continue;
            sourceRegion2hasContent = new HashMap<Region, Boolean>();
            for (Region sourceRegion : connection.getSourceRegions()) {
                sourceRegion2hasContent.put(sourceRegion, false);
            }
            this.connection2sourceRegion2hasContent.put(connection, sourceRegion2hasContent);
        }
        if (hasMandatoryUsedConnection) {
            this.mandatoryBlockedRegions.add(region);
        }
    }

    protected void buildCallTree() {
        CallTreeBuilder callTreeBuilder = new CallTreeBuilder(this);
        callTreeBuilder.buildTree(this.rootScheduledRegion, this.orderedRegions);
    }

    protected @NonNull Iterable<@NonNull Region> getBlockedCallableRegions() {
        return this.callableRegion2blockedConnectionCount.keySet();
    }

    protected @Nullable Integer getBlockedConnectionCount(@NonNull Region region) {
        return this.callableRegion2blockedConnectionCount.get(region);
    }

    protected @NonNull Iterable<? extends @NonNull Connection> getBlockedConnections() {
        return this.blockedConnections;
    }

    protected @NonNull Iterable<? extends @NonNull Region> getMandatoryBlockedRegions() {
        return this.mandatoryBlockedRegions;
    }

    public @NonNull List<@NonNull Region> getOrdering() {
        return this.orderedRegions;
    }

    private @NonNull Map<@NonNull Region, @NonNull Boolean> getSourceRegion2hasContent(@NonNull DatumConnection connection) {
        Map<@NonNull Region, @NonNull Boolean> sourceRegion2hasContent = this.connection2sourceRegion2hasContent.get(connection);
        assert (sourceRegion2hasContent != null);
        return sourceRegion2hasContent;
    }

    protected @NonNull Iterable<? extends @NonNull Region> getUnblockedRegions() {
        return this.unblockedRegions;
    }

    private boolean isBlocked(@NonNull DatumConnection connection) {
        return this.blockedConnections.contains(connection);
    }

    private void propagateIndexes(@NonNull DatumConnection connection) {
        List<@NonNull Integer> connectionIndexes = connection.getIndexes();
        if (connectionIndexes.size() > 0) {
            for (Region region : this.getTargetRegions(connection)) {
                int invocationIndex = region.getInvocationIndex();
                boolean propagateThroughRegion = false;
                for (int connectionIndex : connectionIndexes) {
                    if (connectionIndex <= invocationIndex || !region.addIndex(connectionIndex)) continue;
                    propagateThroughRegion = true;
                }
                if (!propagateThroughRegion) continue;
                Iterable<@NonNull DatumConnection> outgoingConnections = this.getOutgoingConnections(region);
                for (DatumConnection targetConnection : outgoingConnections) {
                    boolean propagateThroughConnection = false;
                    for (int connectionIndex : connectionIndexes) {
                        if (!targetConnection.addIndex(connectionIndex)) continue;
                        propagateThroughConnection = true;
                    }
                    if (!propagateThroughConnection) continue;
                    this.propagateIndexes(targetConnection);
                }
            }
        }
    }

    private void refreshConnectionBlockage(@NonNull DatumConnection connection, @NonNull Region region, @NonNull Set<@NonNull Region> nextRegions) {
        Map<@NonNull Region, @NonNull Boolean> sourceRegion2hasContent = this.getSourceRegion2hasContent(connection);
        sourceRegion2hasContent.put(region, Boolean.TRUE);
        for (Boolean hasContent : sourceRegion2hasContent.values()) {
            if (hasContent.booleanValue()) continue;
            return;
        }
        this.blockedConnections.remove(connection);
        for (Region nextRegion : this.getTargetRegions(connection)) {
            if (nextRegion == region) continue;
            nextRegions.add(nextRegion);
        }
    }

    private boolean refreshRegionBlockage(@NonNull Region region) {
        ScheduledRegion invokingRegion = region.getInvokingRegion();
        assert (invokingRegion != null);
        if (this.blockedRegions.contains(invokingRegion) && !this.unblockedRegions.contains(invokingRegion) && !this.refreshRegionBlockage(invokingRegion)) {
            return false;
        }
        if (region instanceof ScheduledRegion) {
            boolean isBlocked = false;
            ScheduledRegion scheduledRegion = (ScheduledRegion)region;
            for (Connection connection : scheduledRegion.getIncomingPassedConnections()) {
                if (!this.blockedConnections.contains(connection)) continue;
                isBlocked = true;
                break;
            }
            if (!isBlocked) {
                assert (!this.orderedRegions.contains(scheduledRegion));
                this.blockedScheduledRegions.remove(scheduledRegion);
                this.unblockedRegions.add(scheduledRegion);
                this.callableRegion2blockedConnectionCount.remove(region);
                return true;
            }
            return false;
        }
        boolean hasPassedBlock = false;
        boolean hasMandatoryBlock = false;
        Iterable<@NonNull DatumConnection> iterable = this.getIncomingConnections(region);
        assert (iterable != null);
        int blockedConnectionCount = 0;
        for (DatumConnection connection : iterable) {
            if (!this.isBlocked(connection)) continue;
            ++blockedConnectionCount;
            if (connection.isPassed()) {
                hasPassedBlock = true;
                continue;
            }
            if (!connection.isMandatory()) continue;
            hasMandatoryBlock = true;
        }
        if (hasMandatoryBlock) {
            assert (this.mandatoryBlockedRegions.contains(region));
            assert (!this.unblockedRegions.contains(region));
            assert (!this.callableRegion2blockedConnectionCount.containsKey(region));
        } else {
            this.mandatoryBlockedRegions.remove(region);
            if (hasPassedBlock) {
                assert (!this.unblockedRegions.contains(region));
                assert (!this.callableRegion2blockedConnectionCount.containsKey(region));
            } else if (blockedConnectionCount > 0) {
                assert (!this.orderedRegions.contains(region));
                assert (!this.unblockedRegions.contains(region));
                this.callableRegion2blockedConnectionCount.put(region, blockedConnectionCount);
            } else if (this.blockedRegions.contains(invokingRegion)) {
                assert (!this.orderedRegions.contains(region));
                assert (!this.unblockedRegions.contains(region));
                this.callableRegion2blockedConnectionCount.put(region, blockedConnectionCount);
            } else {
                if (!this.orderedRegions.contains(region)) {
                    this.unblockedRegions.add(region);
                    this.callableRegion2blockedConnectionCount.remove(region);
                    return true;
                }
                assert (!this.unblockedRegions.contains(region));
            }
        }
        return false;
    }

    protected void scheduleRegion(@NonNull Region region) {
        int thisIndex = this.orderedRegions.size();
        Scheduler.REGION_ORDER.println(String.valueOf(thisIndex) + " : " + region);
        assert (!this.orderedRegions.contains(region)) : "Attempting to re-order " + region;
        region.addIndex(thisIndex);
        this.orderedRegions.add(region);
        this.unblock(region);
        Iterable<@NonNull DatumConnection> loopingConnections = this.getLoopingConnections(region);
        assert (loopingConnections != null);
        Iterable<@NonNull DatumConnection> outgoingConnections = this.getOutgoingConnections(region);
        assert (outgoingConnections != null);
        HashSet<@NonNull Region> nextRegions = new HashSet<Region>();
        for (DatumConnection loopingConnection : loopingConnections) {
            loopingConnection.addIndex(thisIndex);
        }
        for (DatumConnection outgoingConnection : outgoingConnections) {
            outgoingConnection.addIndex(thisIndex);
            this.refreshConnectionBlockage(outgoingConnection, region, nextRegions);
        }
        for (Region nextRegion : nextRegions) {
            if (this.orderedRegions.contains(nextRegion)) continue;
            this.refreshRegionBlockage(nextRegion);
        }
        if (region instanceof ScheduledRegion) {
            ScheduledRegion scheduledRegion = (ScheduledRegion)region;
            this.scheduleScheduledRegion(scheduledRegion);
        }
    }

    public void schedule(@NonNull RootScheduledRegion rootScheduledRegion) {
        this.scheduleScheduledRegion(rootScheduledRegion);
        for (DatumConnection datumConnection : this.getConnections()) {
            this.propagateIndexes(datumConnection);
        }
        this.buildCallTree();
    }

    protected abstract void scheduleScheduledRegion(@NonNull ScheduledRegion var1);

    private void unblock(@NonNull Region region) {
        boolean wasRemoved2;
        assert (!this.blockedRegions.contains(region.getInvokingRegion()));
        boolean wasRemoved0 = this.blockedRegions.remove(region);
        assert (wasRemoved0);
        boolean wasRemoved1 = this.unblockedRegions.remove(region);
        boolean bl = wasRemoved2 = this.callableRegion2blockedConnectionCount.remove(region) != null;
        assert (wasRemoved1 || wasRemoved2);
    }
}

