/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;

public class RegionUtil {
    public static @NonNull NavigationEdge getCastTarget(@NonNull NavigationEdge edge) {
        @NonNull NavigationEdge sourceEdge = edge;
        while (true) {
            @Nullable NavigationEdge targetEdge = null;
            for (Edge nextEdge : sourceEdge.getTarget().getOutgoingEdges()) {
                if (!nextEdge.isCast() && !nextEdge.isRecursion()) {
                    return sourceEdge;
                }
                if (targetEdge != null) {
                    return sourceEdge;
                }
                targetEdge = (NavigationEdge)nextEdge;
            }
            if (targetEdge == null) {
                return sourceEdge;
            }
            sourceEdge = targetEdge;
        }
    }

    public static @NonNull Node getCastTarget(@NonNull Node node) {
        @NonNull Node sourceNode = node;
        while (true) {
            @Nullable Node targetNode = null;
            for (Edge edge : sourceNode.getOutgoingEdges()) {
                if (!edge.isCast() && !edge.isRecursion()) {
                    return sourceNode;
                }
                if (targetNode != null) {
                    return sourceNode;
                }
                targetNode = edge.getTarget();
            }
            if (targetNode == null) {
                return sourceNode;
            }
            sourceNode = targetNode;
        }
    }

    public static boolean isConformantSource(@NonNull NavigationEdge thatEdge, @NonNull NavigationEdge thisEdge) {
        CompleteClass thisType;
        Node thatSource = thatEdge.getSource();
        CompleteClass thatType = thatSource.getCompleteClass();
        if (thatType.conformsTo(thisType = thisEdge.getSource().getCompleteClass())) {
            return true;
        }
        if (thatSource.isRealized()) {
            return false;
        }
        return thisType.conformsTo(thatType);
    }

    public static boolean isConformantTarget(@NonNull NavigationEdge thatEdge, @NonNull NavigationEdge thisEdge) {
        CompleteClass thisType;
        Node thatTarget = RegionUtil.getCastTarget(thatEdge.getTarget());
        Node thisTarget = RegionUtil.getCastTarget(thisEdge.getTarget());
        CompleteClass thatType = thatTarget.getCompleteClass();
        if (thatType.conformsTo(thisType = thisTarget.getCompleteClass())) {
            return true;
        }
        if (thatTarget.isRealized()) {
            return false;
        }
        return thisType.conformsTo(thatType);
    }
}

