/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergeableRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergedEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergedNavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergedNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Visitor;

public class MergedMappingRegion
extends AbstractMappingRegion {
    private final @NonNull List<@NonNull MergeableRegion> mergedRegions = new ArrayList<MergeableRegion>();
    private final @NonNull Map<@NonNull SimpleNode, @NonNull MergedNode> simpleNode2mergedNode = new HashMap<SimpleNode, MergedNode>();
    private final @NonNull Map<@NonNull SimpleEdge, @NonNull MergedEdge> simpleEdge2mergedEdge = new HashMap<SimpleEdge, MergedEdge>();
    private @Nullable Map<@NonNull Node, @NonNull Node> recursiveBindings = null;

    public MergedMappingRegion(@NonNull MergeableRegion primaryRegion) {
        super(primaryRegion.getSuperRegion());
        this.mergedRegions.add(primaryRegion);
        this.createMergedRegion(primaryRegion);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitMergedMappingRegion(this);
    }

    private void addEdgeToMergedEdge(@NonNull Edge edge, @NonNull MergedEdge mergedEdge) {
        mergedEdge.addEdge(edge);
    }

    private void addNodeToMergedNode(@NonNull Node node, @NonNull MergedNode mergedNode) {
        for (SimpleNode simpleNode : node.getSimpleNodes()) {
            this.addSimpleNodeToMergedNode(simpleNode, mergedNode);
        }
    }

    private void addSimpleEdgeToMergedEdge(@NonNull SimpleEdge simpleEdge, @NonNull MergedEdge mergedEdge) {
        mergedEdge.addEdge(simpleEdge);
    }

    private void addSimpleNodeToMergedNode(@NonNull SimpleNode simpleNode, @NonNull MergedNode mergedNode) {
        mergedNode.addNode(simpleNode);
        this.simpleNode2mergedNode.put(simpleNode, mergedNode);
        for (Edge incomingEdge : new ArrayList<Edge>(simpleNode.getIncomingEdges())) {
            if (incomingEdge.getSource().getRegion() == incomingEdge.getTarget().getRegion()) continue;
            if (mergedNode == incomingEdge.getSource()) {
                incomingEdge.destroy();
                continue;
            }
            incomingEdge.setTarget(mergedNode);
        }
        for (Edge outgoingEdge : new ArrayList<Edge>(simpleNode.getOutgoingEdges())) {
            if (outgoingEdge.getSource().getRegion() == outgoingEdge.getTarget().getRegion()) continue;
            if (mergedNode == outgoingEdge.getTarget()) {
                outgoingEdge.destroy();
                continue;
            }
            outgoingEdge.setSource(mergedNode);
        }
    }

    private void createMergedRegion(@NonNull Region region) {
        for (Node node : region.getNodes()) {
            this.createMergedNode(node);
        }
        for (Edge edge : region.getEdges()) {
            if (edge instanceof NavigationEdge) {
                this.createMergedNavigationEdge(edge.getSource(), (NavigationEdge)edge, edge.getTarget());
                continue;
            }
            if (edge.isMergeable()) {
                this.createMergedEdge(edge.getSource(), edge, edge.getTarget());
                continue;
            }
            if (edge.isRecursion()) continue;
            System.err.println("Unmerged edge" + edge);
        }
    }

    private @NonNull MergedEdge createMergedEdge(@NonNull Node sourceNode, @NonNull Edge edge, @NonNull Node targetNode) {
        MergedNode mergedSource = this.getMergedNode(sourceNode);
        MergedNode mergedTarget = this.getMergedNode(targetNode);
        MergedEdge mergedEdge = new MergedEdge(this, mergedSource, edge, mergedTarget);
        for (SimpleEdge simpleEdge : edge.getSimpleEdges()) {
            MergedEdge oldEdge = this.simpleEdge2mergedEdge.put(simpleEdge, mergedEdge);
            assert (oldEdge == null);
        }
        return mergedEdge;
    }

    private @NonNull MergedNavigationEdge createMergedNavigationEdge(@NonNull Node sourceNode, @NonNull NavigationEdge edge, @NonNull Node targetNode) {
        MergedNode mergedSource = this.getMergedNode(sourceNode);
        MergedNode mergedTarget = this.getMergedNode(targetNode);
        MergedNavigationEdge mergedEdge = new MergedNavigationEdge(this, mergedSource, edge, mergedTarget);
        for (SimpleEdge simpleEdge : edge.getSimpleEdges()) {
            MergedEdge oldEdge = this.simpleEdge2mergedEdge.put(simpleEdge, mergedEdge);
            assert (oldEdge == null);
        }
        return mergedEdge;
    }

    private @NonNull MergedNode createMergedNode(@NonNull Node node) {
        MergedNode mergedNode = new MergedNode(this, node);
        this.addNodeToMergedNode(node, mergedNode);
        return mergedNode;
    }

    private @Nullable MergedNode findMergedNode(@Nullable Node node) {
        if (node instanceof MergedNode) {
            return (MergedNode)node;
        }
        if (node != null) {
            return this.simpleNode2mergedNode.get(node);
        }
        return null;
    }

    @Override
    public @NonNull String getName() {
        ArrayList<String> names = new ArrayList<String>();
        for (Region region : this.mergedRegions) {
            names.add(region.getName());
        }
        Collections.sort(names);
        StringBuilder stringBuilder = new StringBuilder();
        for (String name : names) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\\n");
            }
            stringBuilder.append(name);
        }
        return stringBuilder.toString();
    }

    @Override
    public @NonNull String getColor() {
        return "green";
    }

    @Override
    public @NonNull Iterable<@NonNull MergeableRegion> getMergeableRegions() {
        return this.mergedRegions;
    }

    public @NonNull MergedNode getMergedNode(@NonNull Node node) {
        if (node instanceof MergedNode) {
            return (MergedNode)node;
        }
        MergedNode mergedNode = this.simpleNode2mergedNode.get(node);
        if (mergedNode != null) {
            return mergedNode;
        }
        return (MergedNode)ClassUtil.nonNullState((Object)mergedNode);
    }

    public @Nullable Map<Node, Node> getRecursiveBindings() {
        return this.recursiveBindings;
    }

    public void mergeRegion(@NonNull Region secondaryRegion, @NonNull Map<@NonNull Node, @NonNull Node> secondaryNode2primaryNode) {
        for (MergeableRegion mergeableRegion : secondaryRegion.getMergeableRegions()) {
            this.mergedRegions.add(mergeableRegion);
        }
        for (Map.Entry entry : secondaryNode2primaryNode.entrySet()) {
            @NonNull Node secondaryNode = (Node)entry.getKey();
            @NonNull Node primaryNode = (Node)entry.getValue();
            MergedNode mergedNode = this.getMergedNode(primaryNode);
            this.addNodeToMergedNode(secondaryNode, mergedNode);
        }
        for (Node node : secondaryRegion.getNodes()) {
            Node primaryNode = secondaryNode2primaryNode.get(node);
            MergedNode mergedNode1 = this.findMergedNode(primaryNode);
            if (mergedNode1 == null) {
                mergedNode1 = this.createMergedNode(node);
                secondaryNode2primaryNode.put(node, mergedNode1);
            }
            assert (mergedNode1 != null);
        }
        for (Edge edge : secondaryRegion.getEdges()) {
            if (!edge.isMergeable()) continue;
            Node primarySource = (Node)ClassUtil.nonNullState((Object)secondaryNode2primaryNode.get(edge.getSource()));
            Node primaryTarget = (Node)ClassUtil.nonNullState((Object)secondaryNode2primaryNode.get(edge.getTarget()));
            MergedNode mergedSourceNode = this.getMergedNode(primarySource);
            if (edge instanceof NavigationEdge) {
                NavigationEdge secondaryNavigationEdge = (NavigationEdge)edge;
                MergedNavigationEdge mergedEdge = (MergedNavigationEdge)mergedSourceNode.getNavigationEdge(secondaryNavigationEdge.getProperty());
                if (mergedEdge == null) {
                    this.createMergedNavigationEdge(primarySource, secondaryNavigationEdge, primaryTarget);
                    continue;
                }
                this.addEdgeToMergedEdge(edge, mergedEdge);
                continue;
            }
            if (edge.isArgument()) {
                boolean gotIt = false;
                MergedNode mergedTargetNode = this.getMergedNode(edge.getTarget());
                for (Edge edge2 : mergedSourceNode.getOutgoingEdges()) {
                    if (!edge2.isArgument() || edge2.getTarget() != mergedTargetNode || !edge2.isArgument() || !ClassUtil.safeEquals((Object)edge2.getName(), (Object)edge.getName())) continue;
                    gotIt = true;
                }
                if (gotIt) continue;
                this.createMergedEdge(primarySource, edge, primaryTarget);
                continue;
            }
            this.createMergedEdge(primarySource, edge, primaryTarget);
        }
    }
}

