/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTcRelations;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QvtrToQvtcTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.Rule;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.AbstractRule;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RelationalTransformationToMappingTransformation;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.RuleBindings;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;

public class InvokedRelationToMappingForEnforcement
extends AbstractRule {
    @NonNull
    private static final RuleBindings.KeySet RULE_BINDINGS = new RuleBindings.KeySet();
    @NonNull
    private static final RuleBindings.RuleKey<Relation> RELATIONS_r = RULE_BINDINGS.createRoot(null, "r");
    public Transformation mt;
    @NonNull
    public static final Rule.Factory FACTORY = new Factory();
    @NonNull
    protected final List<SubRecord> subRecords = new ArrayList<SubRecord>();
    private String rn;

    protected InvokedRelationToMappingForEnforcement(@NonNull QvtrToQvtcTransformation transformation, Relation r) {
        super(transformation);
        this.ruleBindings.put(RELATIONS_r, r);
    }

    @Override
    public void check() {
        List<RelationCallExp> ris;
        Relation r = this.ruleBindings.get(RELATIONS_r);
        assert (r != null);
        this.rn = r.getName();
        if (!r.isIsTopLevel() && (ris = this.transformation.getRelationCallExpsForRelation(r)) != null) {
            for (RelationCallExp ri : ris) {
                assert (ri != null);
                Relation ir = this.transformation.getInvokingRelationForRelationCallExp(ri);
                assert (ir != null);
                String irn = ir.getName();
                assert (irn != null);
                for (Domain d : r.getDomain()) {
                    RelationDomain rd = (RelationDomain)d;
                    DomainPattern dp = (DomainPattern)rd.getPattern().get(0);
                    assert (dp != null);
                    if (!rd.isIsEnforceable() || !(dp.getTemplateExpression() instanceof ObjectTemplateExp)) continue;
                    String dn = rd.getName();
                    assert (dn != null);
                    TypedModel dir = rd.getTypedModel();
                    String tmn = dir.getName();
                    assert (tmn != null);
                    EList up = dir.getUsedPackage();
                    assert (up != null);
                    EList domainVars = dp.getBindsTo();
                    ObjectTemplateExp te = (ObjectTemplateExp)dp.getTemplateExpression();
                    Variable tev = te.getBindsTo();
                    assert (tev != null);
                    ArrayList<RelationDomain> rOppositeDomains = new ArrayList<RelationDomain>();
                    Iterator it = r.getDomain().iterator();
                    while (it.hasNext()) {
                        rOppositeDomains.add((RelationDomain)it.next());
                    }
                    rOppositeDomains.remove(rd);
                    this.subRecords.add(new SubRecord(ri, ir, irn, rd, dir, tmn, dn, (List<Package>)up, (List<Variable>)domainVars, te, tev, rOppositeDomains));
                }
            }
        }
    }

    @Override
    public void instantiateOutput() {
        Relation r = this.ruleBindings.get(RELATIONS_r);
        assert (r != null && this.mt != null);
        for (SubRecord subRecord : this.subRecords) {
            Transformation mt2 = this.mt;
            if (mt2 == null) continue;
            Mapping m = this.transformation.findMapping(String.valueOf(this.rn) + '_' + subRecord.irn + '_' + subRecord.dn, mt2);
            assert (m != null);
            subRecord.m = m;
            GuardPattern mg = this.transformation.findGuardPattern((Area)m);
            assert (mg != null);
            subRecord.mg = mg;
            BottomPattern mb = this.transformation.findBottomPattern((Area)m);
            assert (mb != null);
            subRecord.mb = mb;
            CoreDomain md = this.transformation.findCoreDomain(subRecord.dn, (org.eclipse.qvtd.pivot.qvtbase.Rule)m);
            assert (md != null);
            subRecord.md = md;
            TypedModel mdir = null;
            for (TypedModel tm : mt2.getModelParameter()) {
                if (tm.getName() != subRecord.tmn || !tm.getUsedPackage().equals((Object)subRecord.up)) continue;
                mdir = tm;
                break;
            }
            assert (mdir != null);
            subRecord.mdir = mdir;
            GuardPattern dg = this.transformation.findGuardPattern((Area)md);
            assert (dg != null);
            subRecord.dg = dg;
            BottomPattern db = this.transformation.findBottomPattern((Area)md);
            assert (db != null);
            subRecord.db = db;
        }
    }

    @Override
    public void setAttributes() {
        for (SubRecord subRecord : this.subRecords) {
            BottomPattern mb = subRecord.mb;
            RealizedVariable tcv = subRecord.tcv;
            assert (mb != null && tcv != null);
            mb.getRealizedVariable().add((Object)tcv);
            CoreDomain md = subRecord.md;
            assert (md != null);
            md.setTypedModel(subRecord.mdir);
            md.setIsEnforceable(true);
        }
    }

    @Override
    public boolean when() {
        Relation r = this.ruleBindings.get(RELATIONS_r);
        assert (r != null);
        RelationalTransformation rt = (RelationalTransformation)r.getTransformation();
        assert (rt != null);
        RelationalTransformationToMappingTransformation whenRule = new RelationalTransformationToMappingTransformation(this.transformation, rt);
        RuleBindings whenBindings = whenRule.getRuleBindings();
        RelationalTransformationToMappingTransformation whenRuleRecord = (RelationalTransformationToMappingTransformation)this.transformation.getRecord(whenBindings);
        if (whenRuleRecord != null && whenRuleRecord.hasExecuted()) {
            this.mt = whenRuleRecord.getCore();
            assert (this.mt != null);
            return true;
        }
        return false;
    }

    @Override
    public void where() {
        QVTr2QVTcRelations relations = new QVTr2QVTcRelations(this.transformation);
        Relation r = this.ruleBindings.get(RELATIONS_r);
        assert (r != null);
        Set<Variable> allDomainVars = relations.getAllDomainVars(r);
        HashSet whereVars = new HashSet();
        HashSet whenVars = new HashSet();
        HashSet<Predicate> rpSet = new HashSet<Predicate>();
        if (r.getWhen() != null) {
            whenVars.addAll(r.getWhen().getBindsTo());
        }
        if (r.getWhere() != null) {
            rpSet.addAll(relations.rejectRelationCallPredicates((List<Predicate>)r.getWhere().getPredicate()));
            whereVars.addAll(r.getWhere().getBindsTo());
        }
        Set<Variable> sharedDomainVars = relations.getSharedDomainVars(r);
        HashSet<Variable> unsharedWhereVars = new HashSet<Variable>(whereVars);
        unsharedWhereVars.removeAll(whenVars);
        unsharedWhereVars.removeAll(allDomainVars);
        unsharedWhereVars.addAll(sharedDomainVars);
        HashSet unsharedWhenVars = new HashSet(whenVars);
        unsharedWhenVars.removeAll(allDomainVars);
        for (SubRecord subRecord : this.subRecords) {
            HashSet<Variable> oppositeDomainVars = new HashSet<Variable>();
            for (Domain d : subRecord.rOppositeDomains) {
                if (((RelationDomain)d).getPattern() == null) continue;
                oppositeDomainVars.addAll((Collection<Variable>)((DomainPattern)((RelationDomain)d).getPattern().get(0)).getBindsTo());
            }
            HashSet<Variable> domainBottomUnSharedVars = new HashSet<Variable>(subRecord.domainVars);
            domainBottomUnSharedVars.removeAll(whenVars);
            domainBottomUnSharedVars.removeAll(sharedDomainVars);
            domainBottomUnSharedVars.remove(subRecord.tev);
            Set<Predicate> predicatesWithVarBindings = relations.filterOutPredicatesThatReferToVars(rpSet, domainBottomUnSharedVars);
            HashSet<Predicate> predicatesWithoutVarBindings = new HashSet<Predicate>(rpSet);
            predicatesWithoutVarBindings.removeAll(predicatesWithVarBindings);
            HashSet<Variable> domainTopVars = new HashSet<Variable>(subRecord.domainVars);
            domainTopVars.retainAll(whenVars);
            domainTopVars.add(subRecord.tev);
            Mapping m = subRecord.m;
            assert (m != null);
            GuardPattern mg = subRecord.mg;
            assert (mg != null);
            BottomPattern mb = subRecord.mb;
            assert (mb != null);
            GuardPattern dg = subRecord.dg;
            assert (dg != null);
            BottomPattern db = subRecord.db;
            assert (db != null);
            RealizedVariable tcv = relations.doRelationDomainToTraceClassVar(r, subRecord.rd, (CorePattern)mb);
            assert (tcv != null);
            subRecord.tcv = tcv;
            relations.doRPredicateSetToMBPredicateSet(new ArrayList<Predicate>(predicatesWithVarBindings), mb);
            relations.doRVarSetToDGVarSet(new ArrayList<Variable>(domainTopVars), dg);
            relations.doRVarSetToMBVarSet(new ArrayList<Variable>(unsharedWhereVars), mb);
            relations.doIROppositeDomainsToMappingForEnforcement(r, subRecord.ir, subRecord.rd, m);
            relations.doRInvokerToMGuard(subRecord.ir, subRecord.ri, r, mg);
            relations.doROppositeDomainVarsToTraceClassProps(r, subRecord.rd, subRecord.te, oppositeDomainVars, mb);
            relations.doRWhenPatternToMGuardPattern(r, mg);
            relations.doRDomainToMDBottomForEnforcement(r, subRecord.rd, subRecord.te, predicatesWithoutVarBindings, domainBottomUnSharedVars, db);
            relations.doRRelImplToMBottomEnforcementOperation(r, subRecord.rd, mb);
        }
    }

    private static class Factory
    extends AbstractRule.Factory {
        private Factory() {
        }

        @Override
        @Nullable
        public Rule createRule(@NonNull QvtrToQvtcTransformation transformation, @NonNull EObject eo) {
            Rule tracedRule;
            Rule rule = null;
            if (eo instanceof Relation && (tracedRule = transformation.getRecord((rule = new InvokedRelationToMappingForEnforcement(transformation, (Relation)eo)).getRuleBindings())) != null) {
                rule = tracedRule;
            }
            return rule;
        }

        @Override
        @Nullable
        public Rule createRule(@NonNull QvtrToQvtcTransformation transformation, @NonNull List<EObject> eos) {
            return null;
        }
    }

    private class SubRecord {
        @NonNull
        private Relation ir;
        @NonNull
        private RelationDomain rd;
        @NonNull
        private String tmn;
        @NonNull
        private List<Package> up;
        @NonNull
        private String dn;
        @NonNull
        private List<Variable> domainVars;
        @NonNull
        private ObjectTemplateExp te;
        @NonNull
        private Variable tev;
        @NonNull
        private List<RelationDomain> rOppositeDomains;
        @NonNull
        private RelationCallExp ri;
        private BottomPattern mb;
        private String irn;
        private Mapping m;
        private CoreDomain md;
        private TypedModel mdir;
        private GuardPattern dg;
        private BottomPattern db;
        private RealizedVariable tcv;
        private GuardPattern mg;

        public SubRecord(@NonNull RelationCallExp ri, @NonNull Relation ir, @NonNull String irn, @NonNull RelationDomain rd, @NonNull TypedModel dir, @NonNull String tmn, @NonNull String dn, @NonNull List<Package> up, @NonNull List<Variable> domainVars, @NonNull ObjectTemplateExp te, @NonNull Variable tev, List<RelationDomain> rOppositeDomains) {
            this.ri = ri;
            this.ir = ir;
            this.irn = irn;
            this.rd = rd;
            this.tmn = tmn;
            this.dn = dn;
            this.up = up;
            this.domainVars = domainVars;
            this.te = te;
            this.tev = tev;
            this.rOppositeDomains = rOppositeDomains;
        }
    }
}

