/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.evaluator;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluator;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.debug.evaluator.IQVTiVMEvaluationEnvironment;
import org.eclipse.qvtd.debug.evaluator.QVTiVMEnvironmentFactory;
import org.eclipse.qvtd.debug.evaluator.QVTiVMModelManager;
import org.eclipse.qvtd.debug.evaluator.QVTiVMRootEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;
import org.eclipse.qvtd.xtext.qvtimperative.utilities.QVTiXtextEvaluator;

public class QVTiVMEvaluator
implements IVMEvaluator {
    @NonNull
    protected final MetamodelManager metamodelManager;
    @NonNull
    protected final Transformation transformation;
    @NonNull
    protected final QVTiVMEnvironmentFactory vmEnvironmentFactory;
    @NonNull
    protected final QVTiVMModelManager vmModelManager;
    private boolean suspendOnStartup = false;

    private QVTiVMEvaluator(@NonNull QVTiVMEnvironmentFactory vmEnvironmentFactory, @NonNull Transformation transformation) {
        this.vmEnvironmentFactory = vmEnvironmentFactory;
        this.metamodelManager = vmEnvironmentFactory.getEnvironmentFactory().getMetamodelManager();
        this.transformation = transformation;
        QVTiTransformationAnalysis transformationAnalysis = vmEnvironmentFactory.getEnvironmentFactory().createTransformationAnalysis();
        transformationAnalysis.analyzeTransformation(transformation);
        this.vmModelManager = vmEnvironmentFactory.createVMModelManager(transformationAnalysis);
    }

    public QVTiVMEvaluator(@NonNull QVTiVMEnvironmentFactory vmEnvironmentFactory, @NonNull URI transformationURI) throws IOException {
        this(vmEnvironmentFactory, QVTiXtextEvaluator.loadTransformation(ImperativeModel.class, (EnvironmentFactory)vmEnvironmentFactory.getEnvironmentFactory(), (URI)transformationURI, (boolean)vmEnvironmentFactory.keepDebug()));
    }

    public void createModel(@NonNull String name, @NonNull URI modelURI, String contentType) {
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        Resource resource = this.vmEnvironmentFactory.getEnvironmentFactory().getResourceSet().createResource(modelURI, contentType);
        if (resource != null) {
            this.vmModelManager.addModel(typedModel, resource);
        }
    }

    public void dispose() {
        this.vmModelManager.dispose();
    }

    public Boolean execute() {
        Transformation transformation = this.getTransformation();
        IQVTiVMEvaluationEnvironment evalEnv = this.vmEnvironmentFactory.createVMEvaluationEnvironment(transformation, this.vmModelManager);
        QVTiVMRootEvaluationVisitor visitor = this.vmEnvironmentFactory.createVMEvaluationVisitor(evalEnv);
        StandardLibraryInternal standardLibrary = this.vmEnvironmentFactory.getEnvironmentFactory().getStandardLibrary();
        Variable ownedContext = QVTbaseUtil.getContextVariable((StandardLibraryInternal)standardLibrary, (Transformation)transformation);
        evalEnv.add((TypedElement)ownedContext, this.vmModelManager.getTransformationInstance(transformation));
        for (TypedModel typedModel : transformation.getModelParameter()) {
            if (typedModel == null) continue;
            ownedContext = QVTbaseUtil.getContextVariable((StandardLibraryInternal)standardLibrary, (TypedModel)typedModel);
            evalEnv.add((TypedElement)ownedContext, this.vmModelManager.getTypedModelInstance(typedModel));
        }
        visitor.start(this.suspendOnStartup);
        return (Boolean)transformation.accept((Visitor)visitor);
    }

    @NonNull
    public Transformation getDebuggable() {
        return this.getTransformation();
    }

    @NonNull
    public final QVTiVMEnvironmentFactory getEnvironmentFactory() {
        return this.vmEnvironmentFactory;
    }

    @NonNull
    public final MetamodelManager getMetamodelManager() {
        return this.metamodelManager;
    }

    @NonNull
    public Transformation getTransformation() {
        return this.transformation;
    }

    @NonNull
    public final QVTiVMModelManager getVMModelManager() {
        return this.vmModelManager;
    }

    public void loadModel(@NonNull String name, @NonNull URI modelURI, String contentType) {
        Resource resource;
        TypedModel typedModel = (TypedModel)NameUtil.getNameable((Iterable)this.transformation.getModelParameter(), (String)name);
        if (typedModel == null) {
            throw new IllegalStateException("Unknown TypedModel '" + name + "'");
        }
        if (contentType == null) {
            resource = this.vmEnvironmentFactory.getEnvironmentFactory().getResourceSet().getResource(modelURI, true);
        } else {
            resource = this.vmEnvironmentFactory.getEnvironmentFactory().getResourceSet().createResource(modelURI, contentType);
            try {
                resource.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (resource != null) {
            this.vmModelManager.addModel(typedModel, resource);
        }
    }

    public void saveModels() {
        this.vmModelManager.saveModels();
    }

    public void setSuspendOnStartUp(boolean suspendOnStartup) {
        this.suspendOnStartup = suspendOnStartup;
    }
}

