/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class XMLStringBuilder {
    private StringBuilder s = new StringBuilder();
    @NonNull
    private Stack<String> tagStack = new Stack();
    @Nullable
    private String currentTag = null;

    public void appendElement(@NonNull String element, String value) {
        this.s.append(" ");
        this.s.append(element);
        this.s.append("=\"");
        this.s.append(value);
        this.s.append("\"");
    }

    protected void appendIndentation() {
        int i = 0;
        while (i < this.tagStack.size()) {
            this.s.append("  ");
            ++i;
        }
    }

    public void appendNewLineElement(@NonNull String element, @NonNull String value) {
        this.s.append("\n");
        this.appendIndentation();
        this.appendElement(element, value);
    }

    public void appendText(@NonNull String tag, String text) {
        this.pushTag(tag);
        this.s.append(">");
        this.s.append(text);
        this.s.append("</");
        this.s.append(this.tagStack.pop());
        this.s.append(">\n");
        this.currentTag = null;
    }

    public void appendValueAndPopTag(@Nullable String value) {
        if (this.currentTag != null) {
            this.s.append(">");
            this.currentTag = null;
        }
        if (value == null) {
            value = "";
        }
        this.s.append(value);
        String topTag = this.tagStack.pop();
        this.s.append("</");
        this.s.append(topTag);
        this.s.append(">\n");
    }

    public void popTag() {
        String topTag = this.tagStack.pop();
        if (this.currentTag != null) {
            this.s.append("/");
        } else {
            this.appendIndentation();
            this.s.append("</");
            this.s.append(topTag);
        }
        this.s.append(">\n");
        this.currentTag = null;
    }

    public void pushTag(@NonNull String tag) {
        if (this.currentTag != null) {
            this.s.append(">\n");
            this.currentTag = null;
        }
        this.appendIndentation();
        this.tagStack.push(tag);
        this.currentTag = tag;
        this.s.append("<" + tag);
    }

    public String toString() {
        return this.s.toString();
    }
}

