/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.utilities;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;

public class QVTbaseUtil {
    public static <T extends NamedElement> void addAllNamedElements(@NonNull EnvironmentView environmentView, @NonNull Iterable<T> namedElements) {
        String name = environmentView.getName();
        if (name != null) {
            for (NamedElement namedElement : namedElements) {
                if (namedElement == null || !name.equals(namedElement.getName())) continue;
                environmentView.addElement(name, (Element)namedElement);
            }
        } else {
            for (NamedElement namedElement : namedElements) {
                if (namedElement == null) continue;
                environmentView.addNamedElement(namedElement);
            }
        }
    }

    @NonNull
    public static Set<TypedModel> getAllTypedModels(@NonNull TypedModel typedModel) {
        HashSet<TypedModel> allTypedModels = new HashSet<TypedModel>();
        QVTbaseUtil.getAllTypedModelsInternal(allTypedModels, typedModel);
        return allTypedModels;
    }

    private static void getAllTypedModelsInternal(@NonNull Set<TypedModel> allTypedModels, @NonNull TypedModel typedModel) {
        if (allTypedModels.add(typedModel)) {
            for (TypedModel dependsOn : typedModel.getDependsOn()) {
                QVTbaseUtil.getAllTypedModelsInternal(allTypedModels, dependsOn);
            }
        }
    }

    @NonNull
    public static Set<Package> getAllUsedPackages(@NonNull Transformation transformation) {
        HashSet<Package> allPackages = new HashSet<Package>();
        for (TypedModel typedModel : transformation.getModelParameter()) {
            QVTbaseUtil.getAllUsedPackagesInternal(allPackages, typedModel);
        }
        return allPackages;
    }

    @NonNull
    public static Set<Package> getAllUsedPackages(@NonNull TypedModel typedModel) {
        HashSet<Package> allUsedPackages = new HashSet<Package>();
        QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, typedModel);
        return allUsedPackages;
    }

    private static void getAllUsedPackagesInternal(@NonNull Set<Package> allUsedPackages, @NonNull TypedModel typedModel) {
        QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, typedModel.getUsedPackage());
        for (TypedModel dependsOn : typedModel.getDependsOn()) {
            QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, dependsOn);
        }
    }

    private static void getAllUsedPackagesInternal(@NonNull Set<Package> allUsedPackages, @NonNull Iterable<Package> moreUsedPackages) {
        for (Package usedPackage : moreUsedPackages) {
            if (!allUsedPackages.add(usedPackage)) continue;
            QVTbaseUtil.getAllUsedPackagesInternal(allUsedPackages, usedPackage.getImportedPackages());
        }
    }

    @Nullable
    public static Domain getContainingDomain(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Domain) {
                return (Domain)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static BaseModel getContainingModel(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof BaseModel) {
                return (BaseModel)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Rule getContainingRule(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Rule) {
                return (Rule)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Nullable
    public static Transformation getContainingTransformation(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Transformation) {
                return (Transformation)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @NonNull
    public static Variable getContextVariable(@NonNull StandardLibraryInternal standardLibrary, @NonNull Transformation transformation) {
        Variable ownedContext = transformation.getOwnedContext();
        if (ownedContext == null) {
            ownedContext = PivotFactory.eINSTANCE.createVariable();
            ownedContext.setName("this");
            ownedContext.setType((Type)standardLibrary.getLibraryType("Transformation"));
            ownedContext.setIsRequired(true);
            transformation.setOwnedContext(ownedContext);
        }
        return ownedContext;
    }

    @NonNull
    public static Variable getContextVariable(@NonNull StandardLibraryInternal standardLibrary, @NonNull TypedModel typedModel) {
        Variable ownedContext = typedModel.getOwnedContext();
        if (ownedContext == null) {
            ownedContext = PivotFactory.eINSTANCE.createVariable();
            ownedContext.setName(typedModel.getName());
            ownedContext.setType((Type)standardLibrary.getLibraryType("Model"));
            ownedContext.setIsRequired(true);
            typedModel.setOwnedContext(ownedContext);
        }
        return ownedContext;
    }
}

