/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.pivot.qvtbase.evaluation.TransformationExecutor;
import org.eclipse.qvtd.pivot.qvtbase.evaluation.TypedModelInstance;

public abstract class AbstractTransformationExecutor
implements TransformationExecutor {
    @NonNull
    private static final List<Integer> EMPTY_INDEX_LIST = Collections.emptyList();
    @NonNull
    private static final List<EObject> EMPTY_EOBJECT_LIST = Collections.emptyList();
    @NonNull
    protected final Evaluator evaluator;
    @NonNull
    protected final IdResolver idResolver;
    @NonNull
    protected final Model[] models;
    @NonNull
    protected final Map<String, Integer> modelIndexes = new HashMap<String, Integer>();
    @Nullable
    private final PropertyId[] propertyIndex2propertyId;
    @Nullable
    private final Map<PropertyId, Integer> propertyId2propertyIndex;
    @Nullable
    private final EReference[] propertyIndex2eReference;
    @Nullable
    private final Map<EObject, EObject>[] object2oppositeObject;
    @Nullable
    private final Map<ClassId, Integer> classId2classIndex;
    @Nullable
    private final Map<ClassId, Set<Integer>> classId2classIndexes;

    protected AbstractTransformationExecutor(@NonNull Evaluator evaluator, @NonNull String[] modelNames, @Nullable PropertyId[] propertyIndex2propertyId, @Nullable ClassId[] classIndex2classId, @Nullable int[][] classIndex2allClassIndexes) {
        this.evaluator = evaluator;
        this.idResolver = evaluator.getIdResolver();
        this.models = new Model[modelNames.length];
        int i = 0;
        while (i < modelNames.length) {
            String modelName = modelNames[i];
            this.models[i] = new Model(modelName, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes);
            this.modelIndexes.put(modelName, i);
            ++i;
        }
        if (propertyIndex2propertyId != null) {
            int propertyIds = propertyIndex2propertyId.length;
            this.propertyIndex2propertyId = propertyIndex2propertyId;
            this.propertyId2propertyIndex = new HashMap<PropertyId, Integer>(propertyIds);
            this.propertyIndex2eReference = new EReference[propertyIds];
            int propertyIndex = 0;
            while (propertyIndex < propertyIds) {
                PropertyId propertyId = propertyIndex2propertyId[propertyIndex];
                this.propertyId2propertyIndex.put(propertyId, propertyIndex);
                ++propertyIndex;
            }
            HashMap[] object2oppositeObject = new HashMap[propertyIds];
            this.object2oppositeObject = object2oppositeObject;
            int i2 = 0;
            while (i2 < propertyIds) {
                object2oppositeObject[i2] = new HashMap();
                ++i2;
            }
        } else {
            this.propertyIndex2propertyId = null;
            this.propertyId2propertyIndex = null;
            this.propertyIndex2eReference = null;
            this.object2oppositeObject = null;
        }
        if (classIndex2classId != null) {
            assert (classIndex2allClassIndexes != null);
            int classIds = classIndex2classId.length;
            this.classId2classIndex = new HashMap<ClassId, Integer>(classIds);
            this.classId2classIndexes = new HashMap<ClassId, Set<Integer>>(classIds);
            int classIndex = 0;
            while (classIndex < classIds) {
                ClassId classId = classIndex2classId[classIndex];
                this.classId2classIndex.put(classId, classIndex);
                HashSet<Integer> superClassIndexes = new HashSet<Integer>();
                int[] nArray = classIndex2allClassIndexes[classIndex];
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int allClassIndex = nArray[n2];
                    superClassIndexes.add(allClassIndex);
                    ++n2;
                }
                this.classId2classIndexes.put(classId, superClassIndexes);
                ++classIndex;
            }
        } else {
            this.classId2classIndex = null;
            this.classId2classIndexes = null;
        }
    }

    @Override
    public void addRootObjects(@NonNull String modelName, @NonNull Iterable<? extends EObject> eRootObjects) {
        Integer modelIndex = this.modelIndexes.get(modelName);
        if (modelIndex == null) {
            throw new IllegalStateException("Unknown model name '" + modelName + "'");
        }
        this.models[modelIndex].addRootObjects(eRootObjects);
    }

    @NonNull
    public Set<EObject> get(@NonNull Class type) {
        return new HashSet<EObject>(this.models[0].getObjectsOfKind(type));
    }

    @NonNull
    private Set<Integer> getClassIndexes(@NonNull EClass eClass) {
        EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eClass.getEPackage());
        PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
        String className = (String)ClassUtil.nonNullEMF((Object)eClass.getName());
        ClassId classId = packageId.getClassId(className, eClass.getETypeParameters().size());
        assert (this.classId2classIndexes != null);
        Set<Integer> classIndexes = this.classId2classIndexes.get(classId);
        if (classIndexes == null) {
            classIndexes = new HashSet<Integer>();
            for (EClass eSuperClass : eClass.getESuperTypes()) {
                Set<Integer> partialResult = this.getClassIndexes(eSuperClass);
                classIndexes.addAll(partialResult);
            }
            assert (this.classId2classIndexes != null);
            this.classId2classIndexes.put(classId, classIndexes);
        }
        return classIndexes;
    }

    @NonNull
    private List<Integer> getOppositePropertyIndexes(@NonNull Map<EReference, Integer> eReference2propertyIndex, @NonNull EClass eClass) {
        List<Integer> propertyIndexes = null;
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (!(eStructuralFeature instanceof EReference)) continue;
            EReference eReference = (EReference)eStructuralFeature;
            Integer propertyIndex = eReference2propertyIndex.get(eReference);
            if (propertyIndex == null) {
                if (!(eReference.getEOpposite() != null || eReference.isDerived() || eReference.isTransient() || eReference.isVolatile())) {
                    EClass eContainingClass = eReference.getEContainingClass();
                    EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eContainingClass.getEPackage());
                    PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
                    String className = (String)ClassUtil.nonNullEMF((Object)eContainingClass.getName());
                    ClassId classId = packageId.getClassId(className, eContainingClass.getETypeParameters().size());
                    String propertyName = (String)ClassUtil.nonNullEMF((Object)eReference.getName());
                    PropertyId propertyId = classId.getPropertyId(propertyName);
                    assert (this.propertyId2propertyIndex != null);
                    propertyIndex = this.propertyId2propertyIndex.get(propertyId);
                }
                if (propertyIndex == null) {
                    propertyIndex = -1;
                }
                eReference2propertyIndex.put(eReference, propertyIndex);
            }
            if (propertyIndex < 0) continue;
            if (propertyIndexes == null) {
                propertyIndexes = new ArrayList<Integer>();
            }
            propertyIndexes.add(propertyIndex);
        }
        return propertyIndexes != null ? propertyIndexes : EMPTY_INDEX_LIST;
    }

    @Override
    @NonNull
    public Collection<EObject> getRootObjects(@NonNull String modelName) {
        Integer modelIndex = this.modelIndexes.get(modelName);
        if (modelIndex == null) {
            throw new IllegalStateException("Unknown model name '" + modelName + "'");
        }
        return this.models[modelIndex].getRootObjects();
    }

    protected class Model
    implements TypedModelInstance {
        @NonNull
        protected final String name;
        @Nullable
        private Set<EObject> allEObjects = null;
        @Nullable
        private List<EObject> rootEObjects = null;
        @Nullable
        private final Set<EObject>[] classIndex2objects;

        public Model(@Nullable String name, @Nullable PropertyId[] propertyIndex2propertyId, @Nullable ClassId[] classIndex2classId, int[][] classIndex2allClassIndexes) {
            this.name = name;
            if (classIndex2classId != null) {
                assert (classIndex2allClassIndexes != null);
                int classIds = classIndex2classId.length;
                HashSet[] classIndex2objects = new HashSet[classIds];
                this.classIndex2objects = classIndex2objects;
                int i = 0;
                while (i < classIds) {
                    classIndex2objects[i] = new HashSet();
                    ++i;
                }
            } else {
                this.classIndex2objects = null;
            }
        }

        private void accumulateEObject(@Nullable Map<EClass, Set<Integer>> eClass2allClassIndexes, @Nullable Map<EClass, List<Integer>> eClass2allPropertyIndexes, @Nullable Map<EReference, Integer> eReference2propertyIndex, @NonNull EObject eObject) {
            EClass eClass = (EClass)ClassUtil.nonNullEMF((Object)eObject.eClass());
            if (eClass2allClassIndexes != null) {
                Set allClassIndexes = eClass2allClassIndexes.get(eClass);
                if (allClassIndexes == null) {
                    allClassIndexes = AbstractTransformationExecutor.this.getClassIndexes(eClass);
                    eClass2allClassIndexes.put(eClass, allClassIndexes);
                }
                for (Integer classIndex : allClassIndexes) {
                    assert (this.classIndex2objects != null);
                    this.classIndex2objects[classIndex].add(eObject);
                }
            }
            if (eClass2allPropertyIndexes != null) {
                assert (eReference2propertyIndex != null);
                List allPropertyIndexes = eClass2allPropertyIndexes.get(eClass);
                if (allPropertyIndexes == null) {
                    allPropertyIndexes = AbstractTransformationExecutor.this.getOppositePropertyIndexes(eReference2propertyIndex, eClass);
                    eClass2allPropertyIndexes.put(eClass, allPropertyIndexes);
                }
                for (Integer propertyIndex : allPropertyIndexes) {
                    assert (AbstractTransformationExecutor.this.propertyIndex2eReference != null);
                    EReference eReference = AbstractTransformationExecutor.this.propertyIndex2eReference[propertyIndex];
                    if (eReference == null) {
                        assert (AbstractTransformationExecutor.this.propertyIndex2propertyId != null);
                        PropertyId propertyId = AbstractTransformationExecutor.this.propertyIndex2propertyId[propertyIndex];
                        eReference = (EReference)NameUtil.getENamedElement((Iterable)eClass.getEAllStructuralFeatures(), (String)propertyId.getName());
                    }
                    assert (AbstractTransformationExecutor.this.object2oppositeObject != null);
                    AbstractTransformationExecutor.this.object2oppositeObject[propertyIndex].put((EObject)eObject.eGet((EStructuralFeature)eReference), eObject);
                }
            }
        }

        public void add(@NonNull EObject eObject) {
            Set<EObject> allEObjects2 = this.allEObjects;
            if (allEObjects2 == null) {
                this.allEObjects = allEObjects2 = new HashSet<EObject>();
            }
            this.rootEObjects = null;
            allEObjects2.add(eObject);
        }

        public void addRootObjects(@NonNull Iterable<? extends EObject> eRootObjects) {
            List<EObject> rootEObjects2 = this.rootEObjects;
            if (rootEObjects2 == null) {
                this.rootEObjects = rootEObjects2 = new ArrayList<EObject>();
            }
            this.allEObjects = null;
            HashMap<EClass, Set<Integer>> eClass2allClassIndexes = null;
            HashMap<EClass, List<Integer>> eClass2allPropertyIndexes = null;
            HashMap<EReference, Integer> eReference2propertyIndex = null;
            if (AbstractTransformationExecutor.this.classId2classIndexes != null && this.classIndex2objects != null) {
                eClass2allClassIndexes = new HashMap<EClass, Set<Integer>>();
            }
            if (AbstractTransformationExecutor.this.propertyIndex2propertyId != null) {
                eClass2allPropertyIndexes = new HashMap<EClass, List<Integer>>();
                eReference2propertyIndex = new HashMap<EReference, Integer>();
            }
            for (EObject eObject : eRootObjects) {
                if (eObject == null) continue;
                rootEObjects2.add(eObject);
                if (eClass2allClassIndexes == null && eClass2allPropertyIndexes == null) continue;
                this.accumulateEObject(eClass2allClassIndexes, eClass2allPropertyIndexes, eReference2propertyIndex, eObject);
                TreeIterator tit = eObject.eAllContents();
                while (tit.hasNext()) {
                    EObject eObject2 = (EObject)tit.next();
                    if (eObject2 == null) continue;
                    this.accumulateEObject(eClass2allClassIndexes, eClass2allPropertyIndexes, eReference2propertyIndex, eObject2);
                }
            }
        }

        @Override
        @NonNull
        public Collection<EObject> getAllObjects() {
            Set<EObject> allEObjects2 = this.allEObjects;
            if (allEObjects2 == null) {
                this.allEObjects = allEObjects2 = new HashSet<EObject>();
                if (this.rootEObjects != null) {
                    for (EObject eRootObject : this.rootEObjects) {
                        allEObjects2.add(eRootObject);
                        TreeIterator tit = eRootObject.eAllContents();
                        while (tit.hasNext()) {
                            EObject eObject = (EObject)tit.next();
                            allEObjects2.add(eObject);
                        }
                    }
                }
            }
            return allEObjects2;
        }

        @Override
        @NonNull
        public Collection<EObject> getObjectsOfKind(@NonNull Class type) {
            Set<EObject> objects;
            Set<EObject>[] classIndex2objects2;
            TypeId classId;
            Integer classIndex;
            Map classId2classIndex2 = AbstractTransformationExecutor.this.classId2classIndex;
            if (classId2classIndex2 != null && (classIndex = (Integer)classId2classIndex2.get(classId = type.getTypeId())) != null && (classIndex2objects2 = this.classIndex2objects) != null && (objects = classIndex2objects2[classIndex]) != null) {
                return objects;
            }
            return EMPTY_EOBJECT_LIST;
        }

        @Override
        @NonNull
        public Collection<EObject> getObjectsOfType(@NonNull Class type) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NonNull
        public Collection<EObject> getRootObjects() {
            List<EObject> rootEObjects2 = this.rootEObjects;
            if (rootEObjects2 == null) {
                this.rootEObjects = rootEObjects2 = new ArrayList<EObject>();
                if (this.allEObjects != null) {
                    for (EObject eObject : this.allEObjects) {
                        if (eObject.eContainer() != null) continue;
                        rootEObjects2.add(eObject);
                    }
                }
            }
            return rootEObjects2;
        }

        public String toString() {
            return String.valueOf(this.name) + " " + (this.rootEObjects != null ? Integer.valueOf(this.rootEObjects.size()) : "null") + "/" + (this.allEObjects != null ? Integer.valueOf(this.allEObjects.size()) : "null");
        }

        @Override
        @NonNull
        public String getName() {
            return this.name;
        }
    }
}

