/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtimperative.utilities;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiPivotEvaluator;

public class QVTiXtextEvaluator
extends QVTiPivotEvaluator {
    @NonNull
    public static Transformation loadTransformation(@NonNull java.lang.Class<? extends Model> modelClass, @NonNull EnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        BaseCSResource xtextResource = (BaseCSResource)environmentFactory.getResourceSet().getResource(transformationURI, true);
        if (xtextResource == null) {
            throw new IOException("Failed to load '" + transformationURI + "'");
        }
        String csMessage = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)xtextResource.getErrors())), (String)("Failed to load '" + transformationURI + "'"), (String)"\n");
        if (csMessage != null) {
            throw new IOException(csMessage);
        }
        try {
            ASResource asResource = xtextResource.getASResource();
            String asMessage = PivotUtil.formatResourceDiagnostics((List)((List)ClassUtil.nonNullEMF((Object)asResource.getErrors())), (String)("Failed to load '" + asResource.getURI() + "'"), (String)"\n");
            if (asMessage != null) {
                throw new IOException(asMessage);
            }
            for (EObject eContent : asResource.getContents()) {
                if (!modelClass.isInstance(eContent)) continue;
                for (Package asPackage : ((Model)eContent).getOwnedPackages()) {
                    for (Class asClass : asPackage.getOwnedClasses()) {
                        if (!(asClass instanceof Transformation)) continue;
                        Transformation transformation = (Transformation)asClass;
                        return transformation;
                    }
                }
            }
        }
        finally {
            if (!keepDebug) {
                xtextResource.dispose();
            }
        }
        throw new IOException("Failed to locate a transformation in '" + transformationURI + "'");
    }

    public QVTiXtextEvaluator(@NonNull QVTiEnvironmentFactory envFactory, @NonNull URI transformationURI) throws IOException {
        super(envFactory, QVTiXtextEvaluator.loadTransformation(ImperativeModel.class, (EnvironmentFactory)envFactory, transformationURI, envFactory.keepDebug()));
    }

    protected QVTiXtextEvaluator(@NonNull QVTiEnvironmentFactory envFactory, @NonNull Transformation transformation) throws IOException {
        super(envFactory, transformation);
    }
}

