/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.analyzer.AnalysisVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.BoxingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.FieldingAnalyzer;
import org.eclipse.ocl.examples.codegen.java.CG2JavaPreVisitor;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.qvtd.codegen.qvti.QVTiAnalysisVisitor;
import org.eclipse.qvtd.codegen.qvti.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.QVTiBoxingAnalyzer;
import org.eclipse.qvtd.codegen.qvti.QVTiCG2JavaPreVisitor;
import org.eclipse.qvtd.codegen.qvti.QVTiCG2JavaVisitor;
import org.eclipse.qvtd.codegen.qvti.QVTiCG2StringVisitor;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.QVTiDependencyVisitor;
import org.eclipse.qvtd.codegen.qvti.QVTiFieldingAnalyzer;
import org.eclipse.qvtd.codegen.qvti.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvti.QVTiLocalContext;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;

public class QVTiCodeGenerator
extends JavaCodeGenerator {
    @NonNull
    protected final QVTiAnalyzer cgAnalyzer;
    @NonNull
    protected final Transformation transformation;
    private QVTiCG2JavaVisitor generator;
    private String javaSourceCode = null;

    public QVTiCodeGenerator(@NonNull MetaModelManager metaModelManager, @NonNull Transformation transformation) {
        super(metaModelManager);
        QVTiCG2StringVisitor.FACTORY.getClass();
        this.cgAnalyzer = new QVTiAnalyzer(this);
        this.transformation = transformation;
    }

    @NonNull
    public AnalysisVisitor createAnalysisVisitor() {
        return new QVTiAnalysisVisitor(this.cgAnalyzer);
    }

    @NonNull
    public BoxingAnalyzer createBoxingAnalyzer() {
        return new QVTiBoxingAnalyzer(this.cgAnalyzer);
    }

    @NonNull
    public CG2JavaPreVisitor createCG2JavaPreVisitor() {
        return new QVTiCG2JavaPreVisitor(this.getGlobalContext());
    }

    public DependencyVisitor createDependencyVisitor() {
        return new QVTiDependencyVisitor(this.cgAnalyzer, this.getGlobalContext());
    }

    public DependencyVisitor createDependencyVisitor(@NonNull JavaLocalContext localContext) {
        return new QVTiDependencyVisitor((QVTiLocalContext)localContext);
    }

    @NonNull
    public FieldingAnalyzer createFieldingAnalyzer() {
        return new QVTiFieldingAnalyzer(this.cgAnalyzer);
    }

    @NonNull
    protected QVTiGlobalContext createGlobalContext() {
        return new QVTiGlobalContext(this);
    }

    @NonNull
    protected QVTiCodeGenOptions createOptions() {
        return new QVTiCodeGenOptions();
    }

    @NonNull
    public String generateClassFile() {
        String javaSourceCode2 = this.javaSourceCode;
        if (javaSourceCode2 == null) {
            if (this.generator == null) {
                String packagePrefix = this.getOptions().getPackagePrefix();
                this.generator = new QVTiCG2JavaVisitor(this, this.transformation, packagePrefix, this.transformation.getName());
                this.generator.generate();
            }
            Set allImports = this.generator.getAllImports();
            Map long2ShortImportNames = ImportUtils.getLong2ShortImportNames((Iterable)allImports);
            this.javaSourceCode = javaSourceCode2 = ImportUtils.resolveImports((String)this.generator.toString(), (Map)long2ShortImportNames);
        }
        return javaSourceCode2;
    }

    @NonNull
    public QVTiAnalyzer getAnalyzer() {
        return this.cgAnalyzer;
    }

    @NonNull
    public QVTiGlobalContext getGlobalContext() {
        return (QVTiGlobalContext)super.getGlobalContext();
    }

    @NonNull
    public QVTiCodeGenOptions getOptions() {
        return (QVTiCodeGenOptions)super.getOptions();
    }

    @NonNull
    public String getQualifiedName() {
        String className = (String)DomainUtil.nonNullState((Object)this.transformation.getName());
        String packagePrefix = this.getOptions().getPackagePrefix();
        if (packagePrefix != null) {
            return String.valueOf(packagePrefix) + "." + className;
        }
        return className;
    }

    public void saveSourceFile(@NonNull String savePath) throws IOException {
        String javaCodeSource = this.generateClassFile();
        String qualifiedName = this.getQualifiedName();
        String fileName = String.valueOf(savePath) + qualifiedName.replace('.', '/') + ".java";
        FileWriter writer = new FileWriter(fileName);
        ((Writer)writer).append(javaCodeSource);
        ((Writer)writer).close();
    }
}

