/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.editor.Messages;
import org.eclipse.m2m.atl.adt.ui.text.atl.OpenDeclarationUtils;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Feature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.UnitType;
import org.eclipse.ui.texteditor.ITextEditor;

public class AtlElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof AtlEditor)) {
            return null;
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IRegion wordRegion = OpenDeclarationUtils.findWord(document, region.getOffset());
        if (wordRegion == null || wordRegion.getLength() == 0) {
            return null;
        }
        String currentLine = AtlEditor.getCurrentLine(document, wordRegion.getOffset());
        if (currentLine == null || currentLine.contains("--")) {
            return null;
        }
        try {
            Feature feature;
            Object declaration = OpenDeclarationUtils.getDeclaration((AtlEditor)textEditor, wordRegion.getOffset(), wordRegion.getLength());
            if (declaration instanceof EObject) {
                return new IHyperlink[]{new AtlElementHyperlink((AtlEditor)textEditor, null, wordRegion, (EObject)declaration)};
            }
            if (declaration instanceof Feature && (feature = (Feature)declaration).getDeclaration() != null) {
                return new IHyperlink[]{new AtlElementHyperlink((AtlEditor)textEditor, feature.getUnit(), wordRegion, feature.getDeclaration())};
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return null;
    }

    private class AtlElementHyperlink
    implements IHyperlink {
        private final IRegion hyperLinkRegion;
        private final EObject target;
        private final AtlEditor sourceEditor;
        private final UnitType unit;

        public AtlElementHyperlink(AtlEditor editor, UnitType unit, IRegion region, EObject linkTarget) {
            this.sourceEditor = editor;
            this.hyperLinkRegion = region;
            this.target = linkTarget;
            this.unit = unit;
        }

        public IRegion getHyperlinkRegion() {
            return this.hyperLinkRegion;
        }

        public String getHyperlinkText() {
            return String.valueOf(Messages.getString("AtlElementHyperLinkDetector.OPEN_DECLARATION")) + this.target;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            if (this.target != null) {
                try {
                    OpenDeclarationUtils.openDeclaration(this.unit, this.target, this.sourceEditor);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }
}

