/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoreService {
    private static final String LAUNCHERS_EXTENSION_POINT = "org.eclipse.m2m.atl.core.launcher";
    private static final String INJECTORS_EXTENSION_POINT = "org.eclipse.m2m.atl.core.injector";
    private static final String EXTRACTORS_EXTENSION_POINT = "org.eclipse.m2m.atl.core.extractor";
    private static final String MODELS_EXTENSION_POINT = "org.eclipse.m2m.atl.core.model";
    private static Map<String, Object> launcherRegistry = new HashMap<String, Object>();
    private static Map<String, Object> injectorRegistry = new HashMap<String, Object>();
    private static Map<String, Object> extractorRegistry = new HashMap<String, Object>();
    private static Map<String, Class<?>> factoryRegistry = new HashMap();

    private CoreService() {
    }

    private static void register(Map<String, Object> registry, String extensionName, Object value) {
        if (!registry.containsKey(extensionName)) {
            registry.put(extensionName, value);
        }
    }

    public static void registerLauncher(ILauncher launcher) {
        CoreService.register(launcherRegistry, launcher.getName(), launcher);
    }

    public static void registerInjector(String name, IInjector injector) {
        CoreService.register(injectorRegistry, name, injector);
    }

    public static void registerExtractor(String name, IExtractor extractor) {
        CoreService.register(extractorRegistry, name, extractor);
    }

    public static void registerFactory(String name, Class<?> factoryClass) {
        if (!factoryRegistry.containsKey(name)) {
            factoryRegistry.put(name, factoryClass);
        }
    }

    public static ModelFactory createModelFactory(String name) throws ATLCoreException {
        if (factoryRegistry.containsKey(name)) {
            try {
                return (ModelFactory)factoryRegistry.get(name).newInstance();
            }
            catch (IllegalAccessException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new ATLCoreException(e.getMessage(), e);
            }
        }
        return (ModelFactory)CoreService.getExtensionClass(MODELS_EXTENSION_POINT, "modelFactory", name);
    }

    private static Object getExtensionClass(String extensionId, String executableExtensionName, String extensionName, Map<String, Object> registry) throws ATLCoreException {
        if (registry.containsKey(extensionName)) {
            return registry.get(extensionName);
        }
        Object executable = CoreService.getExtensionClass(extensionId, executableExtensionName, extensionName);
        if (executable != null) {
            registry.put(extensionName, executable);
            return executable;
        }
        throw new ATLCoreException(String.valueOf(extensionId) + " " + extensionName + " not found, check the spelling or register it manually");
    }

    private static Object getExtensionClass(String extensionId, String executableExtensionName, String extensionName) throws ATLCoreException {
        if (Platform.isRunning()) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(extensionId).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (configElements[j].getAttribute("name").equals(extensionName)) {
                        Object executable;
                        try {
                            executable = configElements[j].createExecutableExtension(executableExtensionName);
                        }
                        catch (CoreException e) {
                            throw new ATLCoreException(e.getMessage(), e);
                        }
                        return executable;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static ILauncher getLauncher(String name) throws ATLCoreException {
        return (ILauncher)CoreService.getExtensionClass(LAUNCHERS_EXTENSION_POINT, "class", name, launcherRegistry);
    }

    public static IInjector getInjector(String name) throws ATLCoreException {
        return (IInjector)CoreService.getExtensionClass(INJECTORS_EXTENSION_POINT, "class", name, injectorRegistry);
    }

    public static IExtractor getExtractor(String name) throws ATLCoreException {
        return (IExtractor)CoreService.getExtensionClass(EXTRACTORS_EXTENSION_POINT, "class", name, extractorRegistry);
    }

    private static String[] getExtensionsNames(String extensionId) {
        ArrayList<String> launcherNames = new ArrayList<String>();
        if (Platform.isRunning()) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(extensionId).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    launcherNames.add(configElements[j].getAttribute("name"));
                    ++j;
                }
                ++i;
            }
        }
        return launcherNames.toArray(new String[0]);
    }

    public static String[] getLaunchersNames() {
        return CoreService.getExtensionsNames(LAUNCHERS_EXTENSION_POINT);
    }

    public static String[] getInjectorsNames() {
        return CoreService.getExtensionsNames(INJECTORS_EXTENSION_POINT);
    }

    public static String[] getExtractorsNames() {
        return CoreService.getExtensionsNames(EXTRACTORS_EXTENSION_POINT);
    }

    public static String[] getModelFactoriesNames() {
        return CoreService.getExtensionsNames(MODELS_EXTENSION_POINT);
    }

    public static Map<String, String> getLauncherOptions(String launcherName) {
        if (Platform.isRunning()) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(LAUNCHERS_EXTENSION_POINT).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    if (launcherName.equals(configElements[j].getAttribute("name"))) {
                        HashMap<String, String> optionsMap = new HashMap<String, String>();
                        IConfigurationElement[] options = configElements[j].getChildren("option");
                        int k = 0;
                        while (k < options.length) {
                            optionsMap.put(options[k].getAttribute("name"), options[k].getAttribute("description"));
                            ++k;
                        }
                        return optionsMap;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }
}

