/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.wizard.atlfile;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class AtlFileScreen
extends WizardPage {
    public static final String NAME = "NAME";
    public static final String TYPE = "TYPE";
    public static final String CONTAINER = "CONTAINER";
    public static final String IN = "IN";
    public static final String OUT = "OUT";
    public static final String LIB = "LIB";
    public static final String MODULE = "module";
    public static final String QUERY = "query";
    public static final String LIBRARY = "library";
    private ISelection selection;
    private Group groupHead;
    private Group groupIn;
    private Group groupOut;
    private Group groupLib;
    private Text textName;
    private Text textProject;
    private Combo comboType;
    private Table tableIn;
    private Table tableOut;
    private Table tableLib;

    public AtlFileScreen(ISelection selection) {
        super("ATL File Wizard");
        this.setTitle("ATL File Wizard");
        this.setDescription("");
        this.selection = selection;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        this.groupHead = new Group(container, 0);
        this.groupIn = new Group(container, 0);
        this.groupOut = new Group(container, 0);
        this.groupLib = new Group(container, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.groupHead.setLayout((Layout)layout);
        this.groupHead.setText("HEAD");
        this.groupHead.setLayoutData((Object)new GridData(768));
        new Label((Composite)this.groupHead, 0).setText("Container");
        this.textProject = new Text((Composite)this.groupHead, 2048);
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer selectionContainer = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.textProject.setText(selectionContainer.getFullPath().toOSString());
            }
        }
        this.textProject.setLayoutData((Object)new GridData(768));
        Button buttonBrowse = new Button((Composite)this.groupHead, 8);
        buttonBrowse.setText("Browse...");
        buttonBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AtlFileScreen.this.handleProjectBrowse();
            }
        });
        new Label((Composite)this.groupHead, 0).setText("ATL Module Name");
        this.textName = new Text((Composite)this.groupHead, 2048);
        this.textName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                AtlFileScreen.this.textNameKeyPressed(evt);
            }
        });
        GridData gdFilename = new GridData(768);
        gdFilename.horizontalSpan = 2;
        this.textName.setLayoutData((Object)gdFilename);
        new Label((Composite)this.groupHead, 0).setText("ATL File Type");
        this.comboType = new Combo((Composite)this.groupHead, 2056);
        this.comboType.setItems(new String[]{MODULE, LIBRARY, QUERY});
        this.comboType.setText(MODULE);
        GridData gdATLType = new GridData(768);
        gdATLType.horizontalSpan = 2;
        this.comboType.setLayoutData((Object)gdATLType);
        layout = new GridLayout();
        layout.numColumns = 5;
        this.groupIn.setLayout((Layout)layout);
        this.groupIn.setLayoutData((Object)new GridData(1808));
        this.groupIn.setText(IN);
        new Label((Composite)this.groupIn, 0).setText("Model");
        final Text inM1 = new Text((Composite)this.groupIn, 2048);
        inM1.setLayoutData((Object)new GridData(768));
        new Label((Composite)this.groupIn, 0).setText("Metamodel");
        final Text inM2 = new Text((Composite)this.groupIn, 2048);
        inM2.setLayoutData((Object)new GridData(768));
        final Button buttonIn = new Button((Composite)this.groupIn, 8);
        buttonIn.setText("ADD");
        buttonIn.setLayoutData((Object)new GridData(768));
        this.tableIn = new Table((Composite)this.groupIn, 0);
        GridData gdIn = new GridData(1808);
        gdIn.horizontalSpan = 5;
        this.tableIn.setLayoutData((Object)gdIn);
        this.tableIn.setLinesVisible(true);
        this.tableIn.setHeaderVisible(true);
        TableColumn tc = new TableColumn(this.tableIn, 0x1000000);
        tc.setText("Model");
        tc.setWidth(250);
        tc.setAlignment(0x1000000);
        tc = new TableColumn(this.tableIn, 0x1000000);
        tc.setText("Metamodel");
        tc.setWidth(250);
        tc.setAlignment(0x1000000);
        buttonIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AtlFileScreen.this.addTextTable(AtlFileScreen.this.tableIn, new String[]{inM1.getText(), inM2.getText()});
            }
        });
        layout = new GridLayout();
        layout.numColumns = 5;
        this.groupOut.setLayout((Layout)layout);
        this.groupOut.setLayoutData((Object)new GridData(1808));
        this.groupOut.setText(OUT);
        new Label((Composite)this.groupOut, 0).setText("Model");
        final Text outM1 = new Text((Composite)this.groupOut, 2048);
        outM1.setLayoutData((Object)new GridData(768));
        new Label((Composite)this.groupOut, 0).setText("Metamodel");
        final Text outM2 = new Text((Composite)this.groupOut, 2048);
        outM2.setLayoutData((Object)new GridData(768));
        final Button buttonOut = new Button((Composite)this.groupOut, 8);
        buttonOut.setText("ADD");
        buttonOut.setLayoutData((Object)new GridData(768));
        this.tableOut = new Table((Composite)this.groupOut, 0);
        GridData gdOut = new GridData(1808);
        gdOut.horizontalSpan = 5;
        this.tableOut.setLayoutData((Object)gdOut);
        this.tableOut.setLinesVisible(true);
        this.tableOut.setHeaderVisible(true);
        tc = new TableColumn(this.tableOut, 0x1000000);
        tc.setText("Model");
        tc.setWidth(250);
        tc.setAlignment(0x1000000);
        tc = new TableColumn(this.tableOut, 0x1000000);
        tc.setText("Metamodel");
        tc.setWidth(250);
        tc.setAlignment(0x1000000);
        buttonOut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AtlFileScreen.this.addTextTable(AtlFileScreen.this.tableOut, new String[]{outM1.getText(), outM2.getText()});
            }
        });
        layout = new GridLayout();
        layout.numColumns = 3;
        this.groupLib.setLayout((Layout)layout);
        this.groupLib.setLayoutData((Object)new GridData(1808));
        this.groupLib.setText(LIB);
        new Label((Composite)this.groupLib, 0).setText(LIB);
        final Text textLib = new Text((Composite)this.groupLib, 2048);
        textLib.setLayoutData((Object)new GridData(768));
        final Button buttonLib = new Button((Composite)this.groupLib, 8);
        buttonLib.setText("ADD");
        buttonLib.setLayoutData((Object)new GridData(768));
        this.tableLib = new Table((Composite)this.groupLib, 0);
        GridData gdLib = new GridData(1808);
        gdLib.horizontalSpan = 5;
        this.tableLib.setLayoutData((Object)gdLib);
        this.tableLib.setLinesVisible(true);
        this.tableLib.setHeaderVisible(true);
        tc = new TableColumn(this.tableLib, 0x1000000);
        tc.setText(LIB);
        tc.setWidth(500);
        tc.setAlignment(0x1000000);
        buttonLib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AtlFileScreen.this.addTextTable(AtlFileScreen.this.tableLib, new String[]{textLib.getText()});
            }
        });
        this.comboType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (AtlFileScreen.this.comboType.getText().equals(AtlFileScreen.MODULE)) {
                    AtlFileScreen.this.groupIn.setEnabled(true);
                    AtlFileScreen.this.setEnabled(AtlFileScreen.this.groupIn.getChildren(), true);
                    AtlFileScreen.this.groupOut.setEnabled(true);
                    AtlFileScreen.this.setEnabled(AtlFileScreen.this.groupOut.getChildren(), true);
                    AtlFileScreen.this.groupLib.setEnabled(true);
                    AtlFileScreen.this.setEnabled(AtlFileScreen.this.groupLib.getChildren(), true);
                } else if (AtlFileScreen.this.comboType.getText().equals(AtlFileScreen.LIBRARY)) {
                    AtlFileScreen.this.groupIn.setEnabled(false);
                    AtlFileScreen.this.setEnabled(AtlFileScreen.this.groupIn.getChildren(), false);
                    AtlFileScreen.this.groupOut.setEnabled(false);
                    AtlFileScreen.this.setEnabled(AtlFileScreen.this.groupOut.getChildren(), false);
                    AtlFileScreen.this.groupLib.setEnabled(false);
                    AtlFileScreen.this.setEnabled(AtlFileScreen.this.groupLib.getChildren(), false);
                } else if (AtlFileScreen.this.comboType.getText().equals(AtlFileScreen.QUERY)) {
                    AtlFileScreen.this.groupIn.setEnabled(false);
                    AtlFileScreen.this.setEnabled(AtlFileScreen.this.groupIn.getChildren(), false);
                    AtlFileScreen.this.groupOut.setEnabled(false);
                    AtlFileScreen.this.setEnabled(AtlFileScreen.this.groupOut.getChildren(), false);
                    AtlFileScreen.this.groupLib.setEnabled(true);
                    AtlFileScreen.this.setEnabled(AtlFileScreen.this.groupLib.getChildren(), true);
                }
            }
        });
        buttonIn.setEnabled(false);
        buttonOut.setEnabled(false);
        buttonLib.setEnabled(false);
        ModifyListener addInEnabler = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                buttonIn.setEnabled(inM1.getText().trim() != "" && inM2.getText().trim() != "");
            }
        };
        ModifyListener addOutEnabler = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                buttonOut.setEnabled(outM1.getText().trim() != "" && outM2.getText().trim() != "");
            }
        };
        ModifyListener addLibEnabler = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                buttonLib.setEnabled(textLib.getText().trim() != "");
            }
        };
        inM1.addModifyListener(addInEnabler);
        inM2.addModifyListener(addInEnabler);
        outM1.addModifyListener(addOutEnabler);
        outM2.addModifyListener(addOutEnabler);
        textLib.addModifyListener(addLibEnabler);
        container.layout();
        this.setControl((Control)container);
    }

    private void setEnabled(Control[] controlArray, boolean enabled) {
        int i = 0;
        while (i < controlArray.length) {
            controlArray[i].setEnabled(enabled);
            ++i;
        }
    }

    private void handleProjectBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select a container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.textProject.setText(((Path)result[0]).toOSString());
        }
    }

    private void addTextTable(Table tableParam, String[] itemAdded) {
        TableItem item = new TableItem(tableParam, 0);
        item.setText(itemAdded);
    }

    protected void textNameKeyPressed(KeyEvent evt) {
        if (this.textName.getText().equals("")) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public String getParameter(String parameter) {
        if (parameter.equals(NAME)) {
            return this.textName.getText();
        }
        if (parameter.equals(TYPE)) {
            return this.comboType.getText();
        }
        if (parameter.equals(CONTAINER)) {
            return this.textProject.getText();
        }
        if (parameter.equals(IN)) {
            String ret = "";
            int i = 0;
            while (i < this.tableIn.getItems().length) {
                if (i > 0) {
                    ret = String.valueOf(ret) + ", ";
                }
                ret = String.valueOf(ret) + this.tableIn.getItem(i).getText(0);
                ret = String.valueOf(ret) + " : ";
                ret = String.valueOf(ret) + this.tableIn.getItem(i).getText(1);
                ++i;
            }
            return ret;
        }
        if (parameter.equals(OUT)) {
            String ret = "";
            int i = 0;
            while (i < this.tableOut.getItems().length) {
                if (i > 0) {
                    ret = String.valueOf(ret) + ", ";
                }
                ret = String.valueOf(ret) + this.tableOut.getItem(i).getText(0);
                ret = String.valueOf(ret) + " : ";
                ret = String.valueOf(ret) + this.tableOut.getItem(i).getText(1);
                ++i;
            }
            return ret;
        }
        if (parameter.equals(LIB)) {
            String ret = "";
            int i = 0;
            while (i < this.tableLib.getItems().length) {
                ret = String.valueOf(ret) + "uses " + this.tableLib.getItem(i).getText(0) + ";\n";
                ++i;
            }
            return ret;
        }
        return null;
    }
}

