/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class AtlPreferenceStore
implements IPreferenceStore {
    public static final Descriptor BOOLEAN = new Descriptor();
    public static final Descriptor DOUBLE = new Descriptor();
    public static final Descriptor FLOAT = new Descriptor();
    public static final Descriptor INT = new Descriptor();
    public static final Descriptor LONG = new Descriptor();
    public static final Descriptor STRING = new Descriptor();
    private Key[] keys;
    private boolean needsSaving;
    private IPreferenceStore parent;
    private PropertyListener propertyListener;
    private IPreferenceStore store;

    public AtlPreferenceStore(IPreferenceStore parent, Key[] keys) {
        this.parent = parent;
        this.keys = keys;
        this.store = new PreferenceStore();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.store.addPropertyChangeListener(listener);
    }

    public boolean contains(String name) {
        return this.store.contains(name);
    }

    private Key findKey(String name) {
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].key.equals(name)) {
                return this.keys[i];
            }
            ++i;
        }
        return null;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.store.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public boolean getBoolean(String name) {
        return this.store.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.parent.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.parent.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.parent.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.parent.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.parent.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.parent.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.store.getDouble(name);
    }

    public float getFloat(String name) {
        return this.store.getFloat(name);
    }

    public int getInt(String name) {
        return this.store.getInt(name);
    }

    public long getLong(String name) {
        return this.store.getLong(name);
    }

    public String getString(String name) {
        return this.store.getString(name);
    }

    public boolean isDefault(String name) {
        return this.store.isDefault(name);
    }

    public void load() {
        int i = 0;
        while (i < this.keys.length) {
            this.setProperty(this.parent, this.keys[i], this.store);
            ++i;
        }
    }

    public boolean needsSaving() {
        return this.needsSaving;
    }

    public void propagate() {
        int i = 0;
        while (i < this.keys.length) {
            this.setProperty(this.store, this.keys[i], this.parent);
            ++i;
        }
    }

    public void putValue(String name, String value) {
        if (this.findKey(name) != null) {
            this.store.putValue(name, value);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.store.removePropertyChangeListener(listener);
    }

    public void setDefault(String name, boolean value) {
        if (this.findKey(name) != null) {
            this.store.setDefault(name, value);
        }
        this.needsSaving = true;
    }

    public void setDefault(String name, double value) {
        if (this.findKey(name) != null) {
            this.store.setDefault(name, value);
        }
        this.needsSaving = true;
    }

    public void setDefault(String name, float value) {
        if (this.findKey(name) != null) {
            this.store.setDefault(name, value);
        }
        this.needsSaving = true;
    }

    public void setDefault(String name, int value) {
        if (this.findKey(name) != null) {
            this.store.setDefault(name, value);
        }
        this.needsSaving = true;
    }

    public void setDefault(String name, long value) {
        if (this.findKey(name) != null) {
            this.store.setDefault(name, value);
        }
        this.needsSaving = true;
    }

    public void setDefault(String name, String value) {
        if (this.findKey(name) != null) {
            this.store.setDefault(name, value);
        }
        this.needsSaving = true;
    }

    private void setProperty(IPreferenceStore source, Key key, IPreferenceStore target) {
        Descriptor d = key.descriptor;
        if (BOOLEAN == d) {
            target.setValue(key.key, source.getBoolean(key.key));
        } else if (DOUBLE == d) {
            target.setValue(key.key, source.getDouble(key.key));
        } else if (FLOAT == d) {
            target.setValue(key.key, source.getFloat(key.key));
        } else if (INT == d) {
            target.setValue(key.key, source.getInt(key.key));
        } else if (LONG == d) {
            target.setValue(key.key, source.getLong(key.key));
        } else if (STRING == d) {
            target.setValue(key.key, source.getString(key.key));
        }
    }

    public void setToDefault(String name) {
        this.store.setToDefault(name);
        this.needsSaving = true;
    }

    public void setValue(String name, boolean value) {
        if (this.findKey(name) != null) {
            this.store.setValue(name, value);
        }
        this.needsSaving = true;
    }

    public void setValue(String name, double value) {
        if (this.findKey(name) != null) {
            this.store.setValue(name, value);
        }
        this.needsSaving = true;
    }

    public void setValue(String name, float value) {
        if (this.findKey(name) != null) {
            this.store.setValue(name, value);
        }
        this.needsSaving = true;
    }

    public void setValue(String name, int value) {
        if (this.findKey(name) != null) {
            this.store.setValue(name, value);
        }
        this.needsSaving = true;
    }

    public void setValue(String name, long value) {
        if (this.findKey(name) != null) {
            this.store.setValue(name, value);
        }
        this.needsSaving = true;
    }

    public void setValue(String name, String value) {
        if (this.findKey(name) != null) {
            this.store.setValue(name, value);
        }
        this.needsSaving = true;
    }

    public void start() {
        if (this.propertyListener == null) {
            this.propertyListener = new PropertyListener();
            this.parent.addPropertyChangeListener((IPropertyChangeListener)this.propertyListener);
        }
    }

    public void stop() {
        if (this.propertyListener != null) {
            this.parent.removePropertyChangeListener((IPropertyChangeListener)this.propertyListener);
            this.propertyListener = null;
        }
    }

    public static final class Descriptor {
    }

    public static class Key {
        Descriptor descriptor;
        String key;

        public Key(Descriptor descriptor, String key) {
            this.descriptor = descriptor;
            this.key = key;
        }
    }

    private class PropertyListener
    implements IPropertyChangeListener {
        private PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Key key = AtlPreferenceStore.this.findKey(event.getProperty());
            if (key != null) {
                AtlPreferenceStore.this.setProperty(AtlPreferenceStore.this.parent, key, AtlPreferenceStore.this.store);
            }
        }
    }
}

