/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.am3.dsls.km3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.atl.engine.extractors.ebnf.EBNFExtractor;
import org.atl.engine.injectors.ebnf.EBNFInjector2;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.atl.engine.AtlLauncher;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.MarkerMaker;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class KM3Projector {
    private static final boolean stopOnError = true;
    private URL MOF2KM3url;
    private URL KM32MOFurl;
    private URL EMF2KM3url;
    private URL KM3_tcs;
    private URL TCS;
    private URL KM32EMFurl;
    private URL KM3WFRurl;
    private AtlModelHandler emfamh;
    private ASMModel emfmm;
    private AtlModelHandler mdramh;
    private ASMModel mdrmm;
    private ASMModel pbmm;
    private ASMModel tcs;
    private ASMModel km3Tcs;
    private String mmName;
    private MarkerMaker markerMaker;
    private static KM3Projector km3Projector = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private KM3Projector() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmt.am3.dsls.km3.KM3Projector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.MOF2KM3url = clazz.getResource("resources/MOF2KM3.asm");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.gmt.am3.dsls.km3.KM3Projector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.KM32MOFurl = clazz2.getResource("resources/KM32MOF.asm");
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.gmt.am3.dsls.km3.KM3Projector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.EMF2KM3url = clazz3.getResource("resources/EMF2KM3.asm");
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.gmt.am3.dsls.km3.KM3Projector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.KM3_tcs = clazz4.getResource("resources/KM3-TCS.ecore");
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("org.eclipse.gmt.am3.dsls.km3.KM3Projector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.TCS = clazz5.getResource("resources/TCS.ecore");
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.gmt.am3.dsls.km3.KM3Projector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.KM32EMFurl = clazz6.getResource("resources/KM32EMF.asm");
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("org.eclipse.gmt.am3.dsls.km3.KM3Projector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.KM3WFRurl = clazz7.getResource("resources/KM3-WFR.asm");
        this.emfamh = null;
        this.mdramh = null;
        this.tcs = null;
        this.km3Tcs = null;
        this.mmName = "KM3";
    }

    protected void initEMF() {
        if (this.emfamh == null) {
            this.emfamh = AtlModelHandler.getDefault((String)"EMF");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmt.am3.dsls.km3.KM3Projector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL emfmmurl = clazz.getResource("resources/" + this.mmName + ".ecore");
            try {
                this.emfmm = this.emfamh.loadModel(this.mmName, this.emfamh.getMof(), emfmmurl.openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.pbmm = this.emfamh.getBuiltInMetaModel("Problem");
        this.markerMaker = new MarkerMaker();
    }

    protected void initMDR() {
        Class<?> clazz;
        if (this.mdramh == null) {
            this.mdramh = AtlModelHandler.getDefault((String)"MDR");
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmt.am3.dsls.km3.KM3Projector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL mdrmmurl = clazz.getResource("resources/" + this.mmName + ".xmi");
        try {
            this.mdrmm = this.mdramh.loadModel(this.mmName, this.mdramh.getMof(), mdrmmurl.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initEMF();
    }

    public static KM3Projector getKM3Projector() {
        if (km3Projector == null) {
            km3Projector = new KM3Projector();
        }
        return km3Projector;
    }

    public ASMModel getEMFKM3Metamodel() {
        this.initEMF();
        return this.emfmm;
    }

    public ASMModel getMDRKM3Metamodel() {
        this.initMDR();
        return this.mdrmm;
    }

    public ASMModel getKM3FromMOF14(ASMModel metamodel) {
        this.initMDR();
        ASMModel ret = null;
        HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
        models.put("MOF", this.mdramh.getMof());
        models.put("IN", metamodel);
        models.put("KM3", this.emfmm);
        ret = this.emfamh.newModel("OUT", "KM3FromMOF14", this.emfmm);
        models.put("OUT", ret);
        Map params = Collections.EMPTY_MAP;
        Map libs = Collections.EMPTY_MAP;
        AtlLauncher.getDefault().launch(this.MOF2KM3url, libs, models, params, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
        return ret;
    }

    public ASMModel getKM3FromEcore(ASMModel metamodel) {
        this.initEMF();
        ASMModel ret = null;
        HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
        models.put("MOF", this.emfamh.getMof());
        models.put("IN", metamodel);
        models.put("KM3", this.emfmm);
        ret = this.emfamh.newModel("OUT", "KM3FromEcore", this.emfmm);
        models.put("OUT", ret);
        Map params = Collections.EMPTY_MAP;
        Map libs = Collections.EMPTY_MAP;
        AtlLauncher.getDefault().launch(this.EMF2KM3url, libs, models, params, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
        return ret;
    }

    public String getStringFromKM3(ASMModel model) {
        String ret = null;
        try {
            if (this.km3Tcs == null) {
                this.tcs = this.emfamh.loadModel("TCS", this.emfamh.getMof(), this.TCS.openStream());
                this.km3Tcs = this.emfamh.loadModel("KM3.tcs", this.tcs, this.KM3_tcs.openStream());
            }
            EBNFExtractor ext = new EBNFExtractor();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("format", this.km3Tcs);
            params.put("indentString", "\t");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                ext.extract(model, (OutputStream)out, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ret = out.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ret;
    }

    public ASMModel getEMFKM3FromFile(IFile file) throws CoreException, IOException {
        this.initEMF();
        return this.getKM3FromFile(file, this.emfamh, this.emfmm);
    }

    public ASMModel getMDRKM3FromFile(IFile file) throws CoreException, IOException {
        this.initMDR();
        return this.getKM3FromFile(file, this.mdramh, this.mdrmm);
    }

    private ASMModel getKM3FromFile(IFile file, AtlModelHandler amh, ASMModel mm) throws CoreException, IOException {
        ASMModel ret = amh.newModel("IN", file.getLocationURI().toString(), mm);
        EBNFInjector2 ebnfi = new EBNFInjector2();
        InputStream in = file.getContents();
        ASMModel pbs = this.emfamh.newModel("pbs", "pbs", this.pbmm);
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("name", this.mmName);
        params.put("problems", pbs);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.atl.engine.injectors.ebnf.KM3_ANTLR3Lexer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        params.put("lexerClass", clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.atl.engine.injectors.ebnf.KM3_ANTLR3Parser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        params.put("parserClass", clazz2);
        ebnfi.inject(ret, in, params);
        in.close();
        int nbPbs = this.markerMaker.applyMarkers(file, pbs);
        if (nbPbs == 0) {
            HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
            models.put("KM3", mm);
            models.put("IN", ret);
            models.put("Problem", this.pbmm);
            models.put("OUT", pbs);
            params = Collections.EMPTY_MAP;
            Map libs = Collections.EMPTY_MAP;
            AtlLauncher.getDefault().launch(this.KM3WFRurl, libs, models, params, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
            nbPbs = this.markerMaker.applyMarkers(file, pbs);
        }
        if (nbPbs != 0) {
            ret = null;
        }
        return ret;
    }

    public ASMModel getEcoreFromKM3File(IFile file) throws CoreException, IOException {
        ASMModel ret = null;
        ASMModel model = this.getEMFKM3FromFile(file);
        if (model != null) {
            ret = this.getEcoreFromKM3(model);
        }
        return ret;
    }

    public ASMModel getEcoreFromKM3(ASMModel model) throws CoreException, IOException {
        this.initEMF();
        ASMModel ret = null;
        HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
        models.put("MOF", this.emfamh.getMof());
        models.put("KM3", this.emfmm);
        models.put("IN", model);
        ret = this.emfamh.newModel("OUT", "EcoreFromKM3", this.emfamh.getMof());
        models.put("OUT", ret);
        Map params = Collections.EMPTY_MAP;
        Map libs = Collections.EMPTY_MAP;
        AtlLauncher.getDefault().launch(this.KM32EMFurl, libs, models, params, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
        return ret;
    }

    public ASMModel getMOF14FromKM3File(IFile file) throws CoreException, IOException {
        ASMModel ret = null;
        ASMModel model = this.getEMFKM3FromFile(file);
        if (model != null) {
            ret = this.getMOF14FromKM3(model);
        }
        return ret;
    }

    public ASMModel getMOF14FromKM3(ASMModel model) throws CoreException, IOException {
        this.initMDR();
        ASMModel ret = null;
        HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
        models.put("MOF", this.mdramh.getMof());
        models.put("KM3", this.emfmm);
        models.put("IN", model);
        ret = this.mdramh.newModel("OUT", "MOF14FromKM3", this.mdramh.getMof());
        models.put("OUT", ret);
        Map params = Collections.EMPTY_MAP;
        Map libs = Collections.EMPTY_MAP;
        AtlLauncher.getDefault().launch(this.KM32MOFurl, libs, models, params, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
        return ret;
    }
}

