/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDF.java,v 1.1 2007/03/18 08:10:13 lzhang Exp $
 */
package org.eclipse.eodm.vocabulary;


/**
 * The RDF vocabulary. Refer to
 * http://www.w3.org/TR/2004/REC-rdf-syntax-grammar-20040210/#section-Namespace
 */
public class RDF {
    /** RDF namespace */
    public static final String NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    /**
     * The syntax names
     */
    public static final String S_RDF = "RDF";

    public static final String S_DESCRIPTION = "Description";

    public static final String S_ID = "ID";

    public static final String S_ABOUT = "about";

    public static final String S_PARSETYPE = "parseType";

    public static final String S_RESOURCE = "resource";

    public static final String S_LI = "li";

    public static final String S_NODEID = "nodeID";

    public static final String S_DATATYPE = "datatype";
    
    public static final String S_NIL = "nil";

    public static final String S_RDF_STR = NAMESPACE + S_RDF;

    public static final String S_DESCRIPTION_STR = NAMESPACE + S_DESCRIPTION;

    public static final String S_ID_STR = NAMESPACE + S_ID;

    public static final String S_ABOUT_STR = NAMESPACE + S_ABOUT;

    public static final String S_PARSETYPE_STR = NAMESPACE + S_PARSETYPE;

    public static final String S_RESOURCE_STR = NAMESPACE + S_RESOURCE;

    public static final String S_LI_STR = NAMESPACE + S_LI;

    public static final String S_NODEID_STR = NAMESPACE + S_NODEID;

    public static final String S_DATATYPE_STR = NAMESPACE + S_DATATYPE;
    
    public static final String S_NIL_STR = NAMESPACE + S_NIL ;

    /**
     * The class names
     */   
    public static final String C_SEQ = "Seq";

    public static final String C_BAG = "Bag";

    public static final String C_ALT = "Alt";

    public static final String C_STATEMENT = "Statement";

    public static final String C_PROPERTY = "Property";

    public static final String C_XMLLITERAL = "XMLLiteral";

    public static final String C_LIST = "List";

    public static final String C_SEQ_STR = NAMESPACE + C_SEQ;

    public static final String C_BAG_STR = NAMESPACE + C_BAG;

    public static final String C_ALT_STR = NAMESPACE + C_ALT;

    public static final String C_STATEMENT_STR = NAMESPACE + C_STATEMENT;

    public static final String C_PROPERTY_STR = NAMESPACE + C_PROPERTY;

    public static final String C_XMLLITERAL_STR = NAMESPACE + C_XMLLITERAL;

    public static final String C_LIST_STR = NAMESPACE + C_LIST;


    /**
     * The property names
     */
    public static final String P_SUBJECT = "subject";

    public static final String P_PREDICATE = "predicate";

    public static final String P_OBJECT = "object";

    public static final String P_TYPE = "type";

    public static final String P_VALUE = "value";

    public static final String P_FIRST = "first";

    public static final String P_REST = "rest";

    public static final String P_SUBJECT_STR = NAMESPACE + P_SUBJECT;

    public static final String P_PREDICATE_STR = NAMESPACE + P_PREDICATE;

    public static final String P_OBJECT_STR = NAMESPACE + P_OBJECT;

    public static final String P_TYPE_STR = NAMESPACE + P_TYPE;

    public static final String P_VALUE_STR = NAMESPACE + P_VALUE;

    public static final String P_FIRST_STR = NAMESPACE + P_FIRST;

    public static final String P_REST_STR = NAMESPACE + P_REST;

    public static final String[] ALL_RDF_PREDICATES_URIS = {
    		P_SUBJECT_STR, P_PREDICATE_STR, P_OBJECT_STR, P_TYPE_STR, P_VALUE_STR, P_FIRST_STR, P_REST_STR 
    };
    
    /**
     * Old terms rdf:aboutEach | rdf:aboutEachPrefix | rdf:bagID
     */
    public static final String P_ABOUTEACH = "aboutEach";

    public static final String p_ABOUTEACHPREFIX = "aboutEachPrefix";

    public static final String P_BAGID = "bagID";

    public static final String P_ABOUTEACH_STR = NAMESPACE + P_ABOUTEACH;

    public static final String P_ABOUTEACHPREFIX_STR = NAMESPACE
                                                       + p_ABOUTEACHPREFIX;

    public static final String P_BAGID_STR = NAMESPACE + P_BAGID;

}