/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLGraphIterator.java,v 1.2 2007/03/18 10:23:39 lzhang Exp $
 */
package org.eclipse.eodm.impl;

import java.util.Iterator;
import java.lang.UnsupportedOperationException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.impl.RDFGraphImpl;
import org.eclipse.eodm.util.OWLUtility;
import org.eclipse.eodm.util.Triple;
import org.eclipse.eodm.vocabulary.OWL;


public class OWLGraphIterator implements Iterator{

	protected RDFGraphImpl graph;
	protected Iterator entityIterator;
	protected InternalCore coreObject;
	protected int[] entityMark = new int[OWLUtility.getPredicates().size()+1];
	
	protected boolean isMarksEmpty()
	{
		for(int i=0;i<OWLUtility.getPredicates().size()+1;i++)
		{
			if(entityMark[i]>0)
			{
				return false;
			}
		}
		return true;
	}
	protected void calculateMarks(InternalCore coreObject)
	{
		for(int i=0;i<OWLUtility.getPredicates().size()+1;i++)
		{
			entityMark[i]=0;
		}
		for(int i=0;i<OWLUtility.getPredicates().size();i++)
		{
			String predicate = (String)OWLUtility.getPredicates().get(i);
			int featureId = OWLUtility.getFeatureIDbyPredicateURI(predicate);
			EStructuralFeature eStructuralFeature = EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureId);
			if(coreObject.eIsSet(eStructuralFeature))
			{
				if(eStructuralFeature.getUpperBound()==-1)
				{
					entityMark[i]=((EList)coreObject.eGet(eStructuralFeature)).size();
				}
				else
				{
					entityMark[i]=1;
				}
			}
			//System.out.println(coreObject.getURI()+": "+entityMark[i]);
		}
		
		entityMark[OWLUtility.getPredicates().size()]=coreObject.getCustomTriples().size();
	}
	public OWLGraphIterator(RDFGraph graph)
	{
		this.graph = (RDFGraphImpl)graph;
		this.entityIterator = this.graph.getEntityHashMap().keySet().iterator();
		if(entityIterator.hasNext())
		{
		    this.coreObject = (InternalCore)this.graph.getEntityHashMap().get(entityIterator.next());
		    this.calculateMarks(coreObject);
		}
		else
		{
			this.coreObject = null;
		}
	}
	public boolean hasNext()
	{
		if(this.coreObject==null)
		{
			return false;
		}
		else
		{
			
			if(!this.isMarksEmpty())
			{
				return true;
			}
			else
			{
				for(;entityIterator.hasNext();)
				{
					 this.coreObject = (InternalCore)this.graph.getEntityHashMap().get((String)entityIterator.next());
					 this.calculateMarks(coreObject);
					 if(!this.isMarksEmpty())
					 {
						 return true;
					 }
				}
				this.coreObject=null;
				return false;
			}
		}
	}
	public Object next()
	{
		
		if(!this.hasNext())
		{
			return null;
		}
		else
		{
			for(int i=0;i<OWLUtility.getPredicates().size();i++)
			{
				if(this.entityMark[i]>0)
				{
					Triple triple = new Triple();
					if(coreObject.getNodeID()!=null&&!coreObject.getNodeID().equals(""))
					{
						triple.setSubjectNodeID(coreObject.getNodeID());
					}
					else
					{
						triple.setSubjectURI(coreObject.getURI());
					}
					String predicate = (String)OWLUtility.getPredicates().get(i);
					triple.setPredicate(predicate);
					int featureId = OWLUtility.getFeatureIDbyPredicateURI(predicate);
					EStructuralFeature eStructuralFeature = EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureId);
					RDFSResource rdfsResource;
					if(eStructuralFeature.getUpperBound()==-1)
					{
						EList objectList = (EList)coreObject.eGet(eStructuralFeature);
						rdfsResource = (RDFSResource)objectList.get(entityMark[i]-1);
						entityMark[i]--;
					}
					else
					{
						rdfsResource = (RDFSResource)coreObject.eGet(eStructuralFeature);
						entityMark[i]=0;
					}
					if(rdfsResource.getNodeID()!=null&&!rdfsResource.getNodeID().equals(""))
				    {
				    	triple.setObjectNodeID(rdfsResource.getNodeID());
				    }
				    else 
				    	if(rdfsResource instanceof RDFSLiteral)
				    	{
				    		triple.setObjectLiteral((RDFSLiteral)rdfsResource);
				    	}
				    	else{
				    		triple.setObjectURI(rdfsResource.getURI());
				    	}

					if ( OWLUtility.ExtendedValuePred.contains( triple.getPredicate() ))
					{
						if(triple.getPredicate().startsWith(OWL.ALL_VALUES_FROM_URI))
			    		{
			    			triple.setPredicate(OWL.ALL_VALUES_FROM_URI);
			    		}
						else if(triple.getPredicate().startsWith(OWL.SOME_VALUES_FROM_URI))
			    		{
			    			triple.setPredicate(OWL.SOME_VALUES_FROM_URI);
			    		}
						else if(triple.getPredicate().startsWith(OWL.HAS_VALUE_URI))
			    		{
			    			triple.setPredicate(OWL.HAS_VALUE_URI);
			    		}
		    		}
				    return triple;
				}
			}
			Triple triple = (Triple)coreObject.getCustomTriples().get(entityMark[OWLUtility.getPredicates().size()]-1);
		    this.entityMark[OWLUtility.getPredicates().size()]--;
		    return triple;
		}
	}
			

	public void remove() throws UnsupportedOperationException
	{
		throw new UnsupportedOperationException();
	}
}
