/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.psf.ui;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterProjectsDialog
extends SelectionDialog {
    private final Map<String, List<String>> providersToProjects;
    private CheckboxTreeViewer treeViewer;

    public FilterProjectsDialog(Shell parentShell, Map<String, List<String>> providersToProjects) {
        super(parentShell);
        this.providersToProjects = providersToProjects;
    }

    public void create() {
        this.setTitle("Select the projects to import");
        super.create();
        this.getShell().setMinimumSize(400, 450);
        this.getShell().pack();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite self = new Composite(dialogArea, 32);
        self.setLayout((Layout)new GridLayout(1, true));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        Label description = new Label(self, 64);
        description.setText("Select the projects to import");
        Label warning = new Label(self, 64);
        warning.setText("Note: Depending on the provider, project names may not be accurate");
        Composite buttonsBar = new Composite(self, 0);
        buttonsBar.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        buttonsBar.setLayout((Layout)new FillLayout());
        Button selectAll = new Button(buttonsBar, 8);
        selectAll.setText("Select all");
        Button unselectAll = new Button(buttonsBar, 8);
        unselectAll.setText("Unselect all");
        this.treeViewer = new CheckboxTreeViewer(self);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setContentProvider((IContentProvider)new MapContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PSFLabelProvider());
        this.treeViewer.setInput(this.providersToProjects);
        for (String key : this.providersToProjects.keySet()) {
            this.treeViewer.setSubtreeChecked((Object)key, true);
        }
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilterProjectsDialog.this.treeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
                FilterProjectsDialog.this.computeGrayedRoots();
            }
        });
        selectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (String provider : FilterProjectsDialog.this.providersToProjects.keySet()) {
                    FilterProjectsDialog.this.treeViewer.setSubtreeChecked((Object)provider, true);
                    FilterProjectsDialog.this.computeGrayedRoots();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        unselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (String provider : FilterProjectsDialog.this.providersToProjects.keySet()) {
                    FilterProjectsDialog.this.treeViewer.setSubtreeChecked((Object)provider, false);
                    FilterProjectsDialog.this.computeGrayedRoots();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return dialogArea;
    }

    private void computeGrayedRoots() {
        block0: for (String provider : this.providersToProjects.keySet()) {
            boolean oneChecked = false;
            boolean oneUnchecked = false;
            for (String project : this.providersToProjects.get(provider)) {
                if (this.treeViewer.getChecked((Object)project)) {
                    oneChecked = true;
                } else {
                    oneUnchecked = true;
                }
                if (!oneChecked || !oneUnchecked) continue;
                this.treeViewer.setGrayChecked((Object)provider, true);
                continue block0;
            }
            this.treeViewer.setChecked((Object)provider, oneChecked);
            this.treeViewer.setGrayed((Object)provider, false);
        }
    }

    protected void okPressed() {
        Iterator<String> providerIterator = this.providersToProjects.keySet().iterator();
        while (providerIterator.hasNext()) {
            String provider = providerIterator.next();
            if (!this.treeViewer.getChecked((Object)provider)) {
                providerIterator.remove();
                continue;
            }
            if (!this.treeViewer.getGrayed((Object)provider)) continue;
            Iterator<String> projectIterator = this.providersToProjects.get(provider).iterator();
            while (projectIterator.hasNext()) {
                String project = projectIterator.next();
                if (this.treeViewer.getChecked((Object)project)) continue;
                projectIterator.remove();
            }
        }
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    public Map<String, List<String>> getFilteredProjects() {
        return this.providersToProjects;
    }

    public class MapContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).keySet().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String && FilterProjectsDialog.this.providersToProjects.containsKey(parentElement)) {
                return ((List)FilterProjectsDialog.this.providersToProjects.get(parentElement)).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return FilterProjectsDialog.this.providersToProjects.containsKey(element);
        }
    }

    public class PSFLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof String) {
                String ref = (String)element;
                char[] splitStrings = new char[]{'/', ',', '\\'};
                int lastIndex = -1;
                char[] cArray = splitStrings;
                int n = splitStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    char split = cArray[n2];
                    lastIndex = Math.max(lastIndex, ref.lastIndexOf(split));
                    ++n2;
                }
                if (lastIndex == -1) {
                    return ref;
                }
                return ref.substring(lastIndex + 1);
            }
            return super.getText(element);
        }
    }
}

