/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.OLDCreateGateViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.draw2d.routers.MessageRouter;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageDeleteEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.OLDSequenceGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageCreateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;

public class LifelineChildGraphicalNodeEditPolicy
extends OLDSequenceGraphicalNodeEditPolicy {
    private Polyline durationCreationFeedback = null;
    public static ConnectionRouter messageRouter = new MessageRouter();

    public Command getCommand(Request request) {
        if ("connection start".equals(request.getType())) {
            if (request instanceof CreateConnectionViewAndElementRequest) {
                return this.getConnectionAndRelationshipCreateCommand((CreateConnectionViewAndElementRequest)request);
            }
            if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
                return this.getUnspecifiedConnectionCreateCommand((CreateUnspecifiedTypeConnectionRequest)request);
            }
        } else if ("connection end".equals(request.getType())) {
            if (request instanceof CreateConnectionViewAndElementRequest) {
                return this.getConnectionAndRelationshipCompleteCommand((CreateConnectionViewAndElementRequest)request);
            }
            if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
                return this.getUnspecifiedConnectionCompleteCommand((CreateUnspecifiedTypeConnectionRequest)request);
            }
        }
        return super.getCommand(request);
    }

    private Command getUnspecifiedConnectionCreateCommand(CreateUnspecifiedTypeConnectionRequest request) {
        if (request.isDirectionReversed()) {
            return new Command(){

                public boolean canExecute() {
                    return true;
                }
            };
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Request individualRequest : request.getAllRequests()) {
            Command cmd = null;
            if (individualRequest instanceof CreateConnectionViewAndElementRequest) {
                cmd = this.getConnectionAndRelationshipCreateCommand((CreateConnectionViewAndElementRequest)individualRequest);
            } else if (individualRequest instanceof CreateConnectionViewRequest) {
                cmd = this.getConnectionCreateCommand((CreateConnectionRequest)((CreateConnectionViewRequest)individualRequest));
            }
            if (cmd == null || !cmd.canExecute()) continue;
            commands.add(cmd);
        }
        if (commands.isEmpty()) {
            return null;
        }
        return new Command(){};
    }

    @Override
    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Command command = super.getReconnectSourceCommand(request);
        if (command != null) {
            command = OccurrenceSpecificationMoveHelper.completeReconnectConnectionCommand(command, request, this.getConnectableEditPart());
            if (request.getConnectionEditPart() instanceof MessageCreateEditPart && request.getTarget() instanceof LifelineEditPart) {
                LifelineEditPart newSource = (LifelineEditPart)request.getTarget();
                OLDLifelineEditPart target = (OLDLifelineEditPart)request.getConnectionEditPart().getTarget();
                command = LifelineMessageCreateHelper.moveLifelineDown(command, target, newSource.getFigure().getBounds().getLocation().getCopy());
            }
        }
        return command;
    }

    @Override
    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command command = super.getReconnectTargetCommand(request);
        if (command != null) {
            command = OccurrenceSpecificationMoveHelper.completeReconnectConnectionCommand(command, request, this.getConnectableEditPart());
            if (request.getConnectionEditPart() instanceof MessageCreateEditPart && request.getTarget() instanceof LifelineEditPart) {
                command = LifelineMessageCreateHelper.reconnectMessageCreateTarget(request, command);
            }
            if (request.getConnectionEditPart() instanceof MessageDeleteEditPart) {
                boolean cfr_ignored_0 = request.getTarget() instanceof LifelineEditPart;
            }
        }
        return command;
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            Object initLocation;
            Object hintedType = ((CreateUnspecifiedTypeRequest)request).getElementTypes().get(0);
            CreateRequest req = null;
            if (UMLElementTypes.DurationConstraint_Shape.equals(hintedType)) {
                req = ((CreateUnspecifiedTypeRequest)request).getRequestForType(UMLElementTypes.DurationConstraint_Shape);
            } else if (UMLElementTypes.DurationObservation_Shape.equals(hintedType)) {
                req = ((CreateUnspecifiedTypeRequest)request).getRequestForType(UMLElementTypes.DurationObservation_Shape);
            }
            if (req != null && (initLocation = req.getExtendedData().get("Nearest occurrence specification location")) instanceof Point) {
                Point startPoint = ((Point)initLocation).getCopy();
                Point targetPoint = ((CreateUnspecifiedTypeRequest)request).getLocation().getCopy();
                this.getFeedbackLayer().translateToRelative((Translatable)startPoint);
                this.getFeedbackLayer().translateToRelative((Translatable)targetPoint);
                if (this.durationCreationFeedback == null) {
                    this.durationCreationFeedback = new Polyline();
                    this.durationCreationFeedback.setLineWidth(1);
                    this.durationCreationFeedback.setLineStyle(4);
                    this.durationCreationFeedback.setForegroundColor(((IGraphicalEditPart)this.getHost()).getFigure().getLocalForegroundColor());
                    this.addFeedback((IFigure)this.durationCreationFeedback);
                }
                this.durationCreationFeedback.setStart(startPoint);
                this.durationCreationFeedback.setEnd(targetPoint);
                return;
            }
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        super.eraseSourceFeedback(request);
        if (this.durationCreationFeedback != null) {
            this.removeFeedback((IFigure)this.durationCreationFeedback);
        }
        this.durationCreationFeedback = null;
    }

    @Override
    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest req) {
        return messageRouter;
    }

    @Override
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Command command = super.getConnectionCompleteCommand(request);
        if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest viewRequest = (CreateConnectionViewAndElementRequest)request;
            EditPart sourceEP = viewRequest.getSourceEditPart();
            EObject source = ViewUtil.resolveSemanticElement((View)((View)sourceEP.getModel()));
            String semanticHint = viewRequest.getConnectionViewAndElementDescriptor().getSemanticHint();
            if ((((IHintedType)UMLElementTypes.Message_AsynchEdge).getSemanticHint().equals(semanticHint) || ((IHintedType)UMLElementTypes.Message_ReplyEdge).getSemanticHint().equals(semanticHint)) && (source instanceof CombinedFragment || source instanceof Interaction || source instanceof InteractionUse)) {
                CreateConnectionViewRequest.ConnectionViewDescriptor edgeAdapter;
                IAdaptable elementAdapter;
                CompoundCommand cc = new CompoundCommand("Redirect to Gate");
                Point location = null;
                IGraphicalEditPart adapter = (IGraphicalEditPart)sourceEP.getAdapter(IGraphicalEditPart.class);
                if (adapter != null) {
                    Point sourceLocation = request.getLocation();
                    Object object = request.getExtendedData().get("Location of connection source point");
                    if (object instanceof Point) {
                        sourceLocation = (Point)object;
                    }
                    location = GateHelper.computeGateLocation(sourceLocation, adapter.getFigure(), null);
                }
                if ((elementAdapter = (edgeAdapter = viewRequest.getConnectionViewDescriptor()).getElementAdapter()) != null) {
                    IAdaptable gateAdapter = new IAdaptable(){

                        public Object getAdapter(Class adapter) {
                            Message message;
                            MessageEnd sendEvent;
                            if (Gate.class == adapter && (sendEvent = (message = (Message)elementAdapter.getAdapter(Message.class)).getSendEvent()) instanceof Gate) {
                                return sendEvent;
                            }
                            return null;
                        }
                    };
                    TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                    OLDCreateGateViewCommand createGateCommand = new OLDCreateGateViewCommand(editingDomain, (IAdaptable)sourceEP, location, gateAdapter);
                    cc.add((Command)new ICommandProxy((ICommand)createGateCommand));
                    SetConnectionEndsCommand resetSourceCommand = new SetConnectionEndsCommand(editingDomain, null);
                    resetSourceCommand.setEdgeAdaptor((IAdaptable)edgeAdapter);
                    resetSourceCommand.setNewSourceAdaptor(createGateCommand.getResult());
                    cc.add((Command)new ICommandProxy((ICommand)resetSourceCommand));
                    if (cc.canExecute()) {
                        command = command.chain((Command)cc);
                    }
                }
            }
        }
        return command;
    }
}

