/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.widgets.editors.AbstractMultipleValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.providers.TreeCollectionContentProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class MultipleValueEditor<T extends IElementSelector>
extends AbstractMultipleValueEditor<T> {
    private final int style;
    protected TreeViewer treeViewer;
    protected Tree tree;

    public MultipleValueEditor(Composite parent, int style, T selector, boolean ordered, boolean unique, String label) {
        super(parent, selector, ordered, unique, label);
        this.style = style;
        this.createContents();
    }

    public MultipleValueEditor(Composite parent, int style, T selector, boolean ordered) {
        this(parent, style, selector, ordered, false, null);
    }

    public MultipleValueEditor(Composite parent, int style, T selector) {
        this(parent, style, selector, false, false, null);
    }

    public MultipleValueEditor(Composite parent, int style, T selector, String label) {
        this(parent, style, selector, false, false, label);
    }

    public MultipleValueEditor(Composite parent, int style, T selector, boolean ordered, boolean unique, String label, int upperBound) {
        super(parent, selector, ordered, unique, label, upperBound);
        this.style = style;
        this.createContents();
    }

    @Override
    protected Control createContents(Composite parent) {
        this.tree = new Tree(parent, this.style | 2 | 0x200 | 0x100 | 0x800 | 0x10000);
        this.tree.addSelectionListener((SelectionListener)this);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)TreeCollectionContentProvider.instance);
        return this.tree;
    }

    @Override
    protected ISelectionProvider getSelectionProvider(Control contentControl) {
        return this.treeViewer;
    }

    @Override
    protected void setInput(IObservableList modelProperty) {
        this.treeViewer.setInput((Object)modelProperty);
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.treeViewer.setLabelProvider(labelProvider);
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.treeViewer.getLabelProvider();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    @Override
    public void dispose() {
        if (this.tree != null) {
            this.tree.removeSelectionListener((SelectionListener)this);
        }
        super.dispose();
    }

    @Override
    public void refreshValue() {
        this.treeViewer.refresh();
    }
}

