/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.Collections;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetMoveAllLineAtSamePositionCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.DisplayEvent;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IGrillingEditpolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

public class LifelineCreationEditPolicy
extends DefaultCreationEditPolicy
implements IGrillingEditpolicy {
    protected DisplayEvent displayEvent;

    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        DiagramEditPart diagramEditPart;
        GridManagementEditPolicy grid;
        if (request instanceof CreateViewAndElementRequest) {
            CreateViewAndElementRequest req = request;
            CreateViewAndElementRequest.ViewAndElementDescriptor descriptor = req.getViewAndElementDescriptor();
            IElementType elementType = (IElementType)descriptor.getElementAdapter().getAdapter(IElementType.class);
            if (this.isControlledByLifeline(elementType)) {
                CreateElementRequestAdapter requestAdapter = req.getViewAndElementDescriptor().getCreateElementRequestAdapter();
                CreateElementRequest createElementRequest = (CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class);
                View view = (View)this.getHost().getModel();
                EObject hostElement = ViewUtil.resolveSemanticElement((View)view);
                createElementRequest.setContainer(hostElement.eContainer());
                createElementRequest.setParameter("Element Covers this one", (Object)hostElement);
                createElementRequest.setParameter("PAPYRUS_SEQD_COVERED_LIFELINES", Collections.singleton(hostElement));
                MessageOccurrenceSpecification mos = this.displayEvent.getMessageEvent(this.getHostFigure().getParent().getParent(), request.getLocation());
                if (mos != null) {
                    createElementRequest.setParameter("REPLACE_EXECUTION_SPECIFICATION_START", (Object)mos);
                }
            } else if (ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.COMBINED_FRAGMENT_SHAPE) || ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.INTERACTION_USE_SHAPE)) {
                Rectangle boundsLifeline = this.getHostFigure().getBounds();
                Point pointCombinedFragment = req.getLocation();
                pointCombinedFragment.x += boundsLifeline.x;
                pointCombinedFragment.y += boundsLifeline.y;
                req.setLocation(pointCombinedFragment);
                return this.getHost().getParent().getCommand((Request)req);
            }
        }
        if ((grid = (GridManagementEditPolicy)(diagramEditPart = this.getDiagramEditPart(this.getHost())).getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT)) != null) {
            CompoundCommand cmd = new CompoundCommand();
            SetMoveAllLineAtSamePositionCommand setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, false);
            cmd.add((Command)setMoveAllLineAtSamePositionCommand);
            cmd.add(super.getCreateElementAndViewCommand(request));
            setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, true);
            cmd.add((Command)setMoveAllLineAtSamePositionCommand);
            return cmd;
        }
        return super.getCreateElementAndViewCommand(request);
    }

    protected ICommand getReparentCommand(IGraphicalEditPart gep) {
        LifelineEditPart parentLifeLine;
        if (gep instanceof AbstractExecutionSpecificationEditPart && (parentLifeLine = SequenceUtil.getParentLifelinePart((EditPart)gep)) != null && !((Object)((Object)parentLifeLine)).equals(this.getHost())) {
            return null;
        }
        return super.getReparentCommand(gep);
    }

    protected ICommand getReparentViewCommand(IGraphicalEditPart gep) {
        LifelineEditPart parentLifeLine;
        if (gep instanceof AbstractExecutionSpecificationEditPart && (parentLifeLine = SequenceUtil.getParentLifelinePart((EditPart)gep)) != null && !((Object)((Object)parentLifeLine)).equals(this.getHost())) {
            return null;
        }
        return super.getReparentViewCommand(gep);
    }

    protected boolean isControlledByLifeline(IElementType elementType) {
        boolean controlledByLifeline = false;
        if (ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.ACTION_EXECUTION_SPECIFICATION_SHAPE)) {
            controlledByLifeline = true;
        } else if (ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.BEHAVIOR_EXECUTION_SPECIFICATION_SHAPE)) {
            controlledByLifeline = true;
        } else if (ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.TIME_CONSTRAINT_SHAPE)) {
            controlledByLifeline = true;
        } else if (ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.TIME_OBSERVATION_SHAPE)) {
            controlledByLifeline = true;
        } else if (ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.STATE_INVARIANT_SHAPE)) {
            controlledByLifeline = true;
        } else if (ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.COMBINED_FRAGMENT_CO_REGION_SHAPE)) {
            controlledByLifeline = true;
        } else if (ElementUtil.isTypeOf((IElementType)elementType, (IElementType)UMLDIElementTypes.DURATION_CONSTRAINT_SHAPE)) {
            controlledByLifeline = true;
        }
        return controlledByLifeline;
    }

    public void setHost(EditPart host) {
        super.setHost(host);
        this.displayEvent = new DisplayEvent(this.getHost());
    }

    protected IFigure getHostFigure() {
        return ((GraphicalEditPart)this.getHost()).getContentPane();
    }
}

