/******************************************************************************
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/ 
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors: 
 *     committers of openArchitectureWare - Xpand language syntax
 *     Artem Tikhomirov (Borland) - LALR grammar
 *                                - Migration to OCL expressions
 *     Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *****************************************************************************/

package org.eclipse.papyrus.gmf.internal.xpand.parser;

public class XpandLexerprs implements lpg.runtime.ParseTable, XpandLexersym {
    public final static int ERROR_SYMBOL = 0;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 0;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 0;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 0;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 60;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 106;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 1021;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 6;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 368;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 49;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 155;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 369;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 0;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 106;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 107;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 652;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 653;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = false;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return XpandLexersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,1,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,1,0,0,0,0,0,
            0,0,0,1,1,1,0,1,0,0,
            0,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static byte prosthesesIndex[] = {0,
            18,22,23,21,20,25,26,48,31,49,
            13,28,33,4,16,35,6,7,15,19,
            27,32,43,2,3,5,8,9,10,11,
            12,14,17,24,29,30,34,36,37,38,
            39,40,41,42,44,45,46,47,1
        };
    };
    public final static byte prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static byte baseCheck[] = {0,
            1,3,3,3,1,2,2,1,1,5,
            1,1,1,1,1,1,1,1,1,1,
            2,2,2,1,1,1,1,2,1,1,
            1,2,1,1,1,1,2,1,1,2,
            2,3,2,2,0,1,2,2,2,1,
            2,3,2,3,3,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,2,
            1,2,2,2,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,2,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,2,1,2,
            0,1,2,2,1,3,1,1,1,1,
            1,1,1,3,0,1,2,2,2,3,
            1,2,1,1,3,0,2,1,1,1,
            1,1,0,1,12,0,2,3,4,5,
            6,7,8,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,2
        };
    };
    public final static byte baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static byte rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            24,24,24,24,24,24,24,24,24,24,
            24,24,24,24,24,24,24,24,24,24,
            24,24,24,24,24,24,24,24,24,24,
            24,24,24,24,24,17,24,18,26,27,
            27,27,29,29,29,29,30,30,28,28,
            11,11,32,19,19,19,5,5,5,5,
            5,4,4,4,4,2,2,2,2,2,
            2,2,2,2,2,2,2,2,2,2,
            2,2,2,2,2,2,2,2,2,2,
            2,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,1,1,1,
            1,1,1,1,1,1,1,20,20,31,
            31,25,25,25,25,34,34,34,34,34,
            34,34,34,34,34,34,34,34,34,34,
            34,34,34,34,34,34,34,34,34,34,
            34,34,34,34,34,6,6,6,6,6,
            6,6,6,6,6,6,6,6,6,6,
            6,6,6,6,6,6,6,6,6,6,
            6,6,6,6,7,7,7,7,7,7,
            7,7,7,7,7,7,7,7,7,7,
            7,7,7,7,7,7,7,7,7,7,
            7,7,21,21,12,12,35,35,35,35,
            9,15,15,15,15,33,33,33,33,33,
            33,33,33,36,36,36,36,22,22,22,
            22,22,13,13,13,13,13,37,37,16,
            16,14,14,24,24,24,24,24,13,13,
            13,22,22,22,24,38,38,28,24,24,
            24,24,24,24,24,24,39,39,41,41,
            41,41,41,40,40,24,42,42,42,42,
            42,42,42,42,44,44,8,8,8,8,
            8,8,8,8,8,8,23,23,23,23,
            23,23,45,45,45,45,45,45,46,46,
            46,46,46,46,47,47,47,47,47,47,
            48,48,48,48,48,48,10,10,10,10,
            10,10,10,10,10,10,10,10,10,10,
            10,10,10,10,10,10,10,43,43,2072,
            50,61,62,131,129,2282,133,61,62,132,
            452,1656,248,61,62,247,34,36,222,2466,
            251,101,1444,392,375,389,8,595,1155,2431,
            399,416,249,257,130,1642,6,7,1760,253,
            61,62,252,2398,51,224,2464,256,466,501,
            254,259,520,2460,477,1760,253,61,62,252,
            459,2365,224,2461,256,40,533,254,259,529,
            502,477,1760,253,61,62,252,209,2268,224,
            2467,256,2350,51,254,259,539,2434,477,1,
            232,61,62,231,234,233,1864,248,61,62,
            247,41,533,222,289,251,491,1968,253,61,
            62,252,2409,51,224,2462,256,249,258,254,
            260,1344,232,61,62,231,234,233,2470,285,
            287,2379,106,307,314,305,44,309,308,2483,
            304,2484,2178,244,61,62,243,2420,51,245,
            1643,522,1448,232,61,62,231,234,233,1652,
            211,307,314,2366,50,309,308,42,316,2432,
            317,2387,50,2485,413,567,297,230,226,314,
            307,314,482,298,309,308,2152,322,2067,323,
            417,307,314,2387,50,309,308,2463,328,2277,
            329,520,307,314,517,2278,309,308,2468,334,
            2489,335,623,307,314,2438,51,309,308,2252,
            316,653,317,653,299,1552,236,61,62,235,
            2387,50,1138,307,314,302,300,309,308,653,
            340,585,341,653,653,653,653,653,301,653,
            653,653,653,653,653,653,653,653,49,239,
            653,653,653,653,653,653,653,653,653,653,
            653,653,653,653,653,653,653,653,653,653,
            303,653,653
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,99,
            0,101,102,103,104,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,91,92,93,94,
            95,96,97,98,99,100,101,102,0,104,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,99,
            100,101,102,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,89,90,91,92,93,94,95,96,
            97,98,99,100,101,102,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,97,98,99,100,101,102,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,100,
            101,102,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,97,
            98,99,100,101,102,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,91,92,93,94,
            95,96,97,98,99,100,101,102,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,88,89,90,91,
            92,93,94,95,96,97,98,99,100,101,
            102,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,90,91,92,93,94,95,96,97,98,
            99,100,101,102,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,88,89,90,91,92,93,94,95,
            96,97,98,99,100,101,102,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,0,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,88,89,90,91,92,
            93,94,95,96,97,98,99,100,101,102,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,0,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,99,
            100,101,102,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,89,90,91,92,93,94,95,96,
            97,98,99,0,0,0,103,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,88,89,90,91,92,
            93,94,95,96,97,98,99,0,0,106,
            103,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,0,0,92,93,94,95,96,97,98,
            99,0,101,12,103,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,91,105,93,94,
            95,96,97,98,0,0,105,0,103,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,0,94,95,96,97,98,0,0,
            0,0,103,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,89,90,91,0,93,94,95,96,
            97,98,0,0,0,0,103,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,88,89,90,91,92,
            0,94,95,96,97,98,0,0,0,0,
            103,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,0,81,82,83,84,85,86,87,88,
            89,90,91,92,93,0,100,100,17,0,
            99,100,0,0,103,104,105,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,0,75,76,77,78,79,80,81,82,
            83,84,85,86,87,88,89,0,17,92,
            93,94,95,96,97,98,0,0,0,12,
            103,0,1,2,3,4,5,6,7,8,
            9,10,11,16,18,14,0,16,17,18,
            19,0,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,0,
            1,2,3,4,5,6,7,8,9,10,
            11,80,13,14,0,0,1,2,3,4,
            5,6,7,8,9,10,12,0,0,15,
            0,0,0,0,103,20,0,1,2,3,
            4,5,6,7,8,9,10,0,1,2,
            3,4,5,6,7,8,9,10,0,1,
            2,3,4,5,6,7,8,9,10,0,
            1,2,3,4,5,6,7,8,9,10,
            0,0,0,0,70,0,71,0,1,2,
            3,4,5,6,7,8,9,10,0,1,
            2,3,4,5,6,7,8,9,10,0,
            0,0,0,0,0,0,0,0,0,0,
            92,12,12,11,11,15,15,14,13,13,
            11,20,0,0,0,17,19,0,0,0,
            0,0,0,0,12,0,13,13,68,11,
            0,0,0,0,74,72,73,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            90,91,0,0,93,0,0,0,69,99,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,104,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            293,770,771,772,773,774,775,776,777,778,
            779,748,844,841,722,843,747,756,757,761,
            819,718,719,720,721,723,724,725,726,727,
            728,729,730,731,732,733,734,735,736,737,
            738,739,740,741,742,743,716,744,745,746,
            749,750,751,752,753,754,755,758,759,760,
            762,763,764,765,766,767,768,769,709,830,
            842,818,944,943,712,834,823,824,825,826,
            846,831,835,836,837,838,839,840,820,821,
            710,711,822,832,827,845,828,829,833,713,
            286,945,941,717,947,653,770,771,772,773,
            774,775,776,777,778,779,748,844,841,722,
            843,747,756,757,761,819,718,719,720,721,
            723,724,725,726,727,728,729,730,731,732,
            733,734,735,736,737,738,739,740,741,742,
            743,968,744,745,746,749,750,751,752,753,
            754,755,758,759,760,762,763,764,765,766,
            767,768,769,709,830,842,818,965,964,712,
            834,823,824,825,826,846,831,835,836,837,
            838,839,840,820,821,710,711,822,832,827,
            845,828,829,833,713,963,966,959,45,530,
            367,770,771,772,773,774,775,776,777,778,
            779,2056,844,841,722,843,972,974,971,973,
            819,718,719,720,721,723,724,725,726,727,
            728,729,730,731,732,733,734,735,736,737,
            738,739,740,741,742,743,968,999,1000,1001,
            1002,1003,1004,1005,1006,1007,1008,1009,1010,1011,
            1012,1013,1014,1015,1016,1017,1018,1019,709,830,
            842,818,965,964,712,834,823,824,825,826,
            846,831,835,836,837,838,839,840,820,821,
            710,711,822,832,827,845,828,829,833,713,
            963,966,959,653,770,771,772,773,774,775,
            776,777,778,779,977,844,841,722,843,978,
            980,560,979,819,718,719,720,721,723,724,
            725,726,727,728,729,730,731,732,733,734,
            735,736,737,738,739,740,741,742,743,968,
            999,1000,1001,1002,1003,1004,1005,1006,1007,1008,
            1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,
            1019,709,830,842,818,965,964,712,834,823,
            824,825,826,846,831,835,836,837,838,839,
            840,820,821,710,711,822,832,827,845,828,
            829,833,713,963,966,959,653,770,771,772,
            773,774,775,776,777,778,779,983,844,841,
            722,843,571,986,984,985,819,718,719,720,
            721,723,724,725,726,727,728,729,730,731,
            732,733,734,735,736,737,738,739,740,741,
            742,743,968,999,1000,1001,1002,1003,1004,1005,
            1006,1007,1008,1009,1010,1011,1012,1013,1014,1015,
            1016,1017,1018,1019,709,830,842,818,965,964,
            712,834,823,824,825,826,846,831,835,836,
            837,838,839,840,820,821,710,711,822,832,
            827,845,828,829,833,713,963,966,959,653,
            770,771,772,773,774,775,776,777,778,779,
            989,844,841,722,843,991,992,990,582,819,
            718,719,720,721,723,724,725,726,727,728,
            729,730,731,732,733,734,735,736,737,738,
            739,740,741,742,743,968,999,1000,1001,1002,
            1003,1004,1005,1006,1007,1008,1009,1010,1011,1012,
            1013,1014,1015,1016,1017,1018,1019,709,830,842,
            818,965,964,712,834,823,824,825,826,846,
            831,835,836,837,838,839,840,820,821,710,
            711,822,832,827,845,828,829,833,713,963,
            966,959,653,770,771,772,773,774,775,776,
            777,778,779,602,844,841,722,843,972,974,
            971,973,819,718,719,720,721,723,724,725,
            726,727,728,729,730,731,732,733,734,735,
            736,737,738,739,740,741,742,743,968,999,
            1000,1001,1002,1003,1004,1005,1006,1007,1008,1009,
            1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,
            709,830,842,818,965,964,712,834,823,824,
            825,826,846,831,835,836,837,838,839,840,
            820,821,710,711,822,832,827,845,828,829,
            833,713,963,966,959,653,549,549,549,549,
            549,549,549,549,549,549,2262,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,653,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,1747,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,653,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,1850,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,653,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,1953,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,653,770,771,
            772,773,774,775,776,777,778,779,995,844,
            841,722,843,997,296,996,998,819,718,719,
            720,721,723,724,725,726,727,728,729,730,
            731,732,733,734,735,736,737,738,739,740,
            741,742,743,968,999,1000,1001,1002,1003,1004,
            1005,1006,1007,1008,1009,1010,1011,1012,1013,1014,
            1015,1016,1017,1018,1019,709,830,842,818,965,
            964,712,834,823,824,825,826,846,831,835,
            836,837,838,839,840,820,821,710,711,822,
            832,827,845,828,829,833,713,963,966,959,
            367,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,653,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,549,549,549,549,549,549,549,
            549,549,549,653,770,771,772,773,774,775,
            776,777,778,779,748,844,841,722,843,747,
            756,757,761,819,718,719,720,721,723,724,
            725,726,727,728,729,730,731,732,733,734,
            735,736,737,738,739,740,741,742,743,716,
            744,745,746,749,750,751,752,753,754,755,
            758,759,760,762,763,764,765,766,767,768,
            769,709,830,842,818,696,699,712,834,823,
            824,825,826,846,831,835,836,837,838,839,
            840,820,821,710,711,822,832,827,845,828,
            829,833,713,653,653,653,717,653,770,771,
            772,773,774,775,776,777,778,779,748,844,
            841,722,843,747,756,757,761,819,718,719,
            720,721,723,724,725,726,727,728,729,730,
            731,732,733,734,735,736,737,738,739,740,
            741,742,743,716,744,745,746,749,750,751,
            752,753,754,755,758,759,760,762,763,764,
            765,766,767,768,769,709,830,842,818,663,
            700,712,834,823,824,825,826,846,831,835,
            836,837,838,839,840,820,821,710,711,822,
            832,827,845,828,829,833,713,653,653,652,
            717,9,770,771,772,773,774,775,776,777,
            778,779,748,815,812,722,814,747,756,757,
            761,789,718,719,720,721,723,724,725,726,
            727,728,729,730,731,732,733,734,735,736,
            737,738,739,740,741,742,743,716,744,745,
            746,749,750,751,752,753,754,755,758,759,
            760,762,763,764,765,766,767,768,769,890,
            801,813,788,790,891,893,805,794,795,796,
            797,817,802,806,807,808,809,810,811,791,
            792,265,653,793,803,798,816,799,800,804,
            894,653,895,935,717,275,770,771,772,773,
            774,775,776,777,778,779,748,872,869,722,
            871,747,756,757,761,848,718,719,720,721,
            723,724,725,726,727,728,729,730,731,732,
            733,734,735,736,737,738,739,740,741,742,
            743,716,744,745,746,749,750,751,752,753,
            754,755,758,759,760,762,763,764,765,766,
            767,768,769,903,860,870,847,849,852,924,
            862,853,854,855,856,874,861,863,864,865,
            866,867,868,850,851,925,926,657,876,857,
            873,858,859,512,653,653,656,653,717,261,
            770,771,772,773,774,775,776,777,778,779,
            748,872,869,722,871,747,756,757,761,848,
            718,719,720,721,723,724,725,726,727,728,
            729,730,731,732,733,734,735,736,737,738,
            739,740,741,742,743,716,744,745,746,749,
            750,751,752,753,754,755,758,759,760,762,
            763,764,765,766,767,768,769,908,860,870,
            847,849,852,921,862,853,854,855,856,874,
            861,863,864,865,866,867,868,850,851,922,
            923,878,653,857,873,858,859,512,653,653,
            653,653,717,276,770,771,772,773,774,775,
            776,777,778,779,748,872,869,722,871,747,
            756,757,761,848,718,719,720,721,723,724,
            725,726,727,728,729,730,731,732,733,734,
            735,736,737,738,739,740,741,742,743,716,
            744,745,746,749,750,751,752,753,754,755,
            758,759,760,762,763,764,765,766,767,768,
            769,903,860,870,847,849,852,924,862,853,
            854,855,856,874,861,863,864,865,866,867,
            868,850,851,925,926,653,876,857,873,858,
            859,512,653,653,653,653,717,262,770,771,
            772,773,774,775,776,777,778,779,748,872,
            869,722,871,747,756,757,761,848,718,719,
            720,721,723,724,725,726,727,728,729,730,
            731,732,733,734,735,736,737,738,739,740,
            741,742,743,716,744,745,746,749,750,751,
            752,753,754,755,758,759,760,762,763,764,
            765,766,767,768,769,908,860,870,847,849,
            852,921,862,853,854,855,856,874,861,863,
            864,865,866,867,868,850,851,922,923,878,
            653,857,873,858,859,512,653,108,653,653,
            717,653,770,771,772,773,774,775,776,777,
            778,779,748,673,450,722,433,747,756,757,
            498,485,718,719,720,721,723,724,725,726,
            727,728,729,730,731,732,733,734,735,736,
            737,738,739,740,741,742,743,716,744,745,
            746,749,750,751,752,753,754,755,758,759,
            760,762,763,764,765,766,767,768,769,709,
            423,431,448,457,667,712,682,405,936,408,
            934,653,686,679,680,677,678,920,683,669,
            670,710,711,381,442,653,398,556,558,653,
            713,391,653,653,717,937,425,653,770,771,
            772,773,774,775,776,777,778,779,748,872,
            869,722,871,747,756,757,761,848,718,719,
            720,721,723,724,725,726,727,728,729,730,
            731,732,733,734,735,736,737,738,739,740,
            741,742,743,716,744,745,746,749,750,751,
            752,753,754,755,758,759,760,762,763,764,
            765,766,767,768,769,899,860,870,847,849,
            852,653,862,853,854,855,856,874,861,863,
            864,865,866,867,868,850,851,12,948,880,
            881,857,873,858,859,882,653,653,653,917,
            717,1,770,771,772,773,774,775,776,777,
            778,779,748,578,575,722,653,747,756,757,
            761,653,718,719,720,721,723,724,725,726,
            727,728,729,730,731,732,733,734,735,736,
            737,738,739,740,741,742,743,716,744,745,
            746,749,750,751,752,753,754,755,758,759,
            760,762,763,764,765,766,767,768,769,38,
            770,771,772,773,774,775,776,777,778,779,
            780,787,3470,781,19,653,770,771,772,773,
            774,775,776,777,778,779,675,653,653,676,
            653,653,653,653,717,600,653,770,771,772,
            773,774,775,776,777,778,779,53,770,771,
            772,773,774,775,776,777,778,779,52,770,
            771,772,773,774,775,776,777,778,779,55,
            770,771,772,773,774,775,776,777,778,779,
            11,653,653,15,931,653,563,54,770,771,
            772,773,774,775,776,777,778,779,38,541,
            541,541,541,541,541,541,541,541,541,31,
            18,13,653,39,653,5,35,653,108,108,
            927,916,674,569,780,932,681,781,511,543,
            3490,701,32,35,37,3089,580,653,653,653,
            653,653,653,653,919,653,690,933,709,589,
            653,653,653,653,712,930,447,653,653,653,
            653,653,653,653,653,653,653,653,653,653,
            710,711,653,653,655,653,653,653,509,713,
            653,653,653,653,653,653,653,653,653,653,
            653,653,653,653,653,653,653,653,653,653,
            653,653,653,653,653,653,653,653,653,653,
            653,653,653,653,653,653,1021
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }
    public final int asb(int index) { return 0; }
    public final int asr(int index) { return 0; }
    public final int nasb(int index) { return 0; }
    public final int nasr(int index) { return 0; }
    public final int terminalIndex(int index) { return 0; }
    public final int nonterminalIndex(int index) { return 0; }
    public final int scopePrefix(int index) { return 0;}
    public final int scopeSuffix(int index) { return 0;}
    public final int scopeLhs(int index) { return 0;}
    public final int scopeLa(int index) { return 0;}
    public final int scopeStateSet(int index) { return 0;}
    public final int scopeRhs(int index) { return 0;}
    public final int scopeState(int index) { return 0;}
    public final int inSymb(int index) { return 0;}
    public final String name(int index) { return null; }
    public final int originalState(int state) { return 0; }
    public final int asi(int state) { return 0; }
    public final int nasi(int state) { return 0; }
    public final int inSymbol(int state) { return 0; }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
