/**
 * ﻿ * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.papyrus.gmf.gmfgraph.Alignment;
import org.eclipse.papyrus.gmf.gmfgraph.BasicFont;
import org.eclipse.papyrus.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.papyrus.gmf.gmfgraph.ChildAccess;
import org.eclipse.papyrus.gmf.gmfgraph.Color;
import org.eclipse.papyrus.gmf.gmfgraph.ConnectionFigure;
import org.eclipse.papyrus.gmf.gmfgraph.CustomFigure;
import org.eclipse.papyrus.gmf.gmfgraph.DecorationFigure;
import org.eclipse.papyrus.gmf.gmfgraph.Ellipse;
import org.eclipse.papyrus.gmf.gmfgraph.Figure;
import org.eclipse.papyrus.gmf.gmfgraph.FigureAccessor;
import org.eclipse.papyrus.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.papyrus.gmf.gmfgraph.FigureRef;
import org.eclipse.papyrus.gmf.gmfgraph.Label;
import org.eclipse.papyrus.gmf.gmfgraph.Polyline;
import org.eclipse.papyrus.gmf.gmfgraph.PolylineConnection;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.papyrus.gmf.gmfgraph.Rectangle;
import org.eclipse.papyrus.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.papyrus.gmf.gmfgraph.SVGProperty;
import org.eclipse.papyrus.gmf.gmfgraph.SVGPropertyType;
import org.eclipse.papyrus.gmf.gmfgraph.Shape;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Utils_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  public String compilationUnitName(final FigureDescriptor figure) {
    return StringExtensions.toFirstUpper(figure.getName());
  }
  
  public boolean hasSourceDecoration(final PolylineConnection figure) {
    DecorationFigure _sourceDecoration = figure.getSourceDecoration();
    return (!Objects.equal(null, _sourceDecoration));
  }
  
  public Iterable<String> requiredBundles(final Iterable<String> referencedBundles) {
    List<String> result = CollectionLiterals.<String>newLinkedList("org.eclipse.core.runtime", "org.eclipse.draw2d");
    boolean _isFullRuntime = this.isFullRuntime();
    if (_isFullRuntime) {
      result.add("org.eclipse.gmf.runtime.draw2d.ui");
    }
    Iterables.<String>addAll(result, referencedBundles);
    return IterableExtensions.<String>sort(result);
  }
  
  /**
   * XXX: [MG] As of 2013 only full runtime is supported
   */
  public boolean isFullRuntime() {
    return true;
  }
  
  public boolean hasTargetDecoration(final PolylineConnection figure) {
    DecorationFigure _targetDecoration = figure.getTargetDecoration();
    return (!Objects.equal(null, _targetDecoration));
  }
  
  protected boolean _needsField(final RealFigure figure) {
    return this.realFigureNeedsField(figure);
  }
  
  protected boolean _needsField(final CustomFigure figure) {
    return (this.customFigureNeedsField(figure) || this.realFigureNeedsField(figure));
  }
  
  public boolean customFigureNeedsField(final CustomFigure figure) {
    return (this.hasDescriptor(figure) && (!figure.getCustomChildren().isEmpty()));
  }
  
  public boolean realFigureNeedsField(final RealFigure figure) {
    return (this.hasDescriptor(figure) && IterableExtensions.<ChildAccess>exists(figure.getDescriptor().getAccessors(), new Function1<ChildAccess, Boolean>() {
      @Override
      public Boolean apply(final ChildAccess a) {
        Figure _figure = a.getFigure();
        return Boolean.valueOf(Objects.equal(_figure, figure));
      }
    }));
  }
  
  public boolean hasDescriptor(final RealFigure figure) {
    FigureDescriptor _descriptor = figure.getDescriptor();
    return (!Objects.equal(_descriptor, null));
  }
  
  public String figureVariableName(final RealFigure figure, final int count) {
    boolean _needsField = this.needsField(figure);
    if (_needsField) {
      return this.figureFieldName(figure);
    }
    String _xifexpression = null;
    boolean _nullOrSpaces = this._common_qvto.nullOrSpaces(figure.getName());
    if (_nullOrSpaces) {
      _xifexpression = this.variableNameStem(figure);
    } else {
      _xifexpression = StringExtensions.toFirstLower(figure.getName());
    }
    String base = _xifexpression;
    return (base + Integer.valueOf(count));
  }
  
  protected String _nameStem(final FigureRef xptSelf) {
    return this.variableNameStem(xptSelf.getFigure());
  }
  
  protected String _nameStem(final Figure xptSelf) {
    return this.variableNameStem(xptSelf);
  }
  
  protected String _variableNameStem(final Figure xptSelf) {
    return "fig";
  }
  
  protected String _variableNameStem(final RealFigure xptSelf) {
    return "fig";
  }
  
  protected String _variableNameStem(final Shape xptSelf) {
    return "shape";
  }
  
  protected String _variableNameStem(final Rectangle xptSelf) {
    return "rect";
  }
  
  protected String _variableNameStem(final RoundedRectangle xptSelf) {
    return "rrect";
  }
  
  protected String _variableNameStem(final Ellipse xptSelf) {
    return "elli";
  }
  
  protected String _variableNameStem(final Polyline xptSelf) {
    return "polyline";
  }
  
  protected String _variableNameStem(final Label xptSelf) {
    return "l";
  }
  
  protected String _variableNameStem(final DecorationFigure xptSelf) {
    return "dec";
  }
  
  protected String _variableNameStem(final ConnectionFigure xptSelf) {
    return "conn";
  }
  
  protected String _figureFieldName(final RealFigure xptSelf) {
    final Function1<ChildAccess, Boolean> _function = new Function1<ChildAccess, Boolean>() {
      @Override
      public Boolean apply(final ChildAccess a) {
        Figure _figure = a.getFigure();
        return Boolean.valueOf(Objects.equal(xptSelf, _figure));
      }
    };
    return this.figureFieldName(IterableExtensions.<ChildAccess>filter(xptSelf.getDescriptor().getAccessors(), _function));
  }
  
  protected String _figureFieldName(final ChildAccess xptSelf) {
    String _trimPrefixIfAny = this.trimPrefixIfAny(xptSelf.getAccessor(), "get");
    return ("f" + _trimPrefixIfAny);
  }
  
  protected String _figureFieldName(final CustomFigure xptSelf) {
    String _firstUpper = StringExtensions.toFirstUpper(xptSelf.getName());
    return ("my" + _firstUpper);
  }
  
  protected String _figureFieldName(final Iterable<ChildAccess> accesses) {
    final Function1<ChildAccess, String> _function = new Function1<ChildAccess, String>() {
      @Override
      public String apply(final ChildAccess x) {
        return Utils_qvto.this.figureFieldName(x);
      }
    };
    return IterableExtensions.<String>head(IterableExtensions.<ChildAccess, String>map(accesses, _function));
  }
  
  public String borderLayoutConstant(final BorderLayoutData layoutData) {
    String _switchResult = null;
    Alignment _alignment = layoutData.getAlignment();
    if (_alignment != null) {
      switch (_alignment) {
        case BEGINNING_LITERAL:
          String _xifexpression = null;
          boolean _isVertical = layoutData.isVertical();
          if (_isVertical) {
            _xifexpression = "TOP";
          } else {
            _xifexpression = "LEFT";
          }
          _switchResult = _xifexpression;
          break;
        case END_LITERAL:
          String _xifexpression_1 = null;
          boolean _isVertical_1 = layoutData.isVertical();
          if (_isVertical_1) {
            _xifexpression_1 = "BOTTOM";
          } else {
            _xifexpression_1 = "RIGHT";
          }
          _switchResult = _xifexpression_1;
          break;
        default:
          _switchResult = "CENTER";
          break;
      }
    } else {
      _switchResult = "CENTER";
    }
    return _switchResult;
  }
  
  public Iterable<FigureAccessor> allCustomAccessors(final FigureDescriptor fd) {
    final Function1<CustomFigure, EList<FigureAccessor>> _function = new Function1<CustomFigure, EList<FigureAccessor>>() {
      @Override
      public EList<FigureAccessor> apply(final CustomFigure cf) {
        return cf.getCustomChildren();
      }
    };
    return Iterables.<FigureAccessor>concat(IterableExtensions.<CustomFigure, EList<FigureAccessor>>map(this.filterCustom(CollectionLiterals.<Figure>newLinkedList(fd.getActualFigure())), _function));
  }
  
  public Iterable<CustomFigure> filterCustom(final Iterable<Figure> figures) {
    final LinkedList<CustomFigure> result = CollectionLiterals.<CustomFigure>newLinkedList();
    this.deepCollectCustom(figures, result);
    return result;
  }
  
  protected void deepCollectCustom(final Iterable<Figure> figures, final List<CustomFigure> acc) {
    boolean _isEmpty = IterableExtensions.isEmpty(figures);
    if (_isEmpty) {
      return;
    }
    Iterables.<CustomFigure>addAll(acc, Iterables.<CustomFigure>filter(figures, CustomFigure.class));
    final Function1<RealFigure, EList<Figure>> _function = new Function1<RealFigure, EList<Figure>>() {
      @Override
      public EList<Figure> apply(final RealFigure rf) {
        return rf.getChildren();
      }
    };
    this.deepCollectCustom(Iterables.<Figure>concat(IterableExtensions.<RealFigure, EList<Figure>>map(Iterables.<RealFigure>filter(figures, RealFigure.class), _function)), acc);
    final Function1<CustomFigure, EList<FigureAccessor>> _function_1 = new Function1<CustomFigure, EList<FigureAccessor>>() {
      @Override
      public EList<FigureAccessor> apply(final CustomFigure rf) {
        return rf.getCustomChildren();
      }
    };
    final Function1<FigureAccessor, RealFigure> _function_2 = new Function1<FigureAccessor, RealFigure>() {
      @Override
      public RealFigure apply(final FigureAccessor cc) {
        return cc.getTypedFigure();
      }
    };
    this.deepCollectCustom(Iterables.<Figure>filter(IterableExtensions.<FigureAccessor, RealFigure>map(Iterables.<FigureAccessor>concat(IterableExtensions.<CustomFigure, EList<FigureAccessor>>map(Iterables.<CustomFigure>filter(figures, CustomFigure.class), _function_1)), _function_2), Figure.class), acc);
  }
  
  public LinkedList<FigureAccessor> getCustomFigureChainFigureAccess(final ChildAccess it) {
    final LinkedList<FigureAccessor> result = CollectionLiterals.<FigureAccessor>newLinkedList();
    boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(it.getFigure(), CustomFigure.class);
    if (_oclIsKindOf) {
      Figure _figure = it.getFigure();
      CustomFigure cf = ((CustomFigure) _figure);
      while (this._common_qvto.oclIsKindOf(cf.eContainer(), FigureAccessor.class)) {
        {
          EObject _eContainer = cf.eContainer();
          result.push(((FigureAccessor) _eContainer));
          EObject _eContainer_1 = cf.eContainer().eContainer();
          cf = ((CustomFigure) _eContainer_1);
        }
      }
    }
    return result;
  }
  
  public String svgPropertyType(final SVGProperty p) {
    String _switchResult = null;
    SVGPropertyType _type = p.getType();
    if (_type != null) {
      switch (_type) {
        case COLOR:
          _switchResult = "org.eclipse.swt.graphics.Color";
          break;
        case FLOAT:
          _switchResult = "float";
          break;
        default:
          _switchResult = "String";
          break;
      }
    } else {
      _switchResult = "String";
    }
    return _switchResult;
  }
  
  @MetaDef
  public String fontVariableName(final BasicFont it, final String figureVarName) {
    String _upperCase = figureVarName.toUpperCase();
    return (_upperCase + "_FONT");
  }
  
  @MetaDef
  public String backgroundColorVariableName(final Color it, final String figureVarName) {
    String _upperCase = figureVarName.toUpperCase();
    return (_upperCase + "_BACK");
  }
  
  @MetaDef
  public String foregroundColorVariableName(final Color it, final String figureVarName) {
    String _upperCase = figureVarName.toUpperCase();
    return (_upperCase + "_FORE");
  }
  
  protected String trimPrefixIfAny(final String text, final String prefix) {
    String _xifexpression = null;
    if ((text.startsWith(prefix) && (text.length() > prefix.length()))) {
      _xifexpression = text.substring(prefix.length());
    } else {
      _xifexpression = text;
    }
    return _xifexpression;
  }
  
  public boolean needsField(final RealFigure figure) {
    if (figure instanceof CustomFigure) {
      return _needsField((CustomFigure)figure);
    } else if (figure != null) {
      return _needsField(figure);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(figure).toString());
    }
  }
  
  public String nameStem(final Figure xptSelf) {
    if (xptSelf instanceof FigureRef) {
      return _nameStem((FigureRef)xptSelf);
    } else if (xptSelf != null) {
      return _nameStem(xptSelf);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(xptSelf).toString());
    }
  }
  
  public String variableNameStem(final Figure xptSelf) {
    if (xptSelf instanceof Ellipse) {
      return _variableNameStem((Ellipse)xptSelf);
    } else if (xptSelf instanceof Polyline) {
      return _variableNameStem((Polyline)xptSelf);
    } else if (xptSelf instanceof Rectangle) {
      return _variableNameStem((Rectangle)xptSelf);
    } else if (xptSelf instanceof RoundedRectangle) {
      return _variableNameStem((RoundedRectangle)xptSelf);
    } else if (xptSelf instanceof ConnectionFigure) {
      return _variableNameStem((ConnectionFigure)xptSelf);
    } else if (xptSelf instanceof DecorationFigure) {
      return _variableNameStem((DecorationFigure)xptSelf);
    } else if (xptSelf instanceof Label) {
      return _variableNameStem((Label)xptSelf);
    } else if (xptSelf instanceof Shape) {
      return _variableNameStem((Shape)xptSelf);
    } else if (xptSelf instanceof RealFigure) {
      return _variableNameStem((RealFigure)xptSelf);
    } else if (xptSelf != null) {
      return _variableNameStem(xptSelf);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(xptSelf).toString());
    }
  }
  
  public String figureFieldName(final Object xptSelf) {
    if (xptSelf instanceof CustomFigure) {
      return _figureFieldName((CustomFigure)xptSelf);
    } else if (xptSelf instanceof RealFigure) {
      return _figureFieldName((RealFigure)xptSelf);
    } else if (xptSelf instanceof ChildAccess) {
      return _figureFieldName((ChildAccess)xptSelf);
    } else if (xptSelf instanceof Iterable) {
      return _figureFieldName((Iterable<ChildAccess>)xptSelf);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(xptSelf).toString());
    }
  }
}
