/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.papyrus.infra.nattable.utils.PasteModeEnumeration;

public class PasteEnablementStatus {
    private MultiStatus rowStatus;
    private MultiStatus columnStatus;

    public PasteEnablementStatus(MultiStatus columnStatus, MultiStatus rowStatus) {
        this.rowStatus = rowStatus;
        this.columnStatus = columnStatus;
    }

    public PasteModeEnumeration getPasteMode() {
        if (this.rowStatus == null && this.columnStatus == null) {
            return PasteModeEnumeration.PASTE_NO_CONFIGURATION;
        }
        if (this.rowStatus != null && this.columnStatus != null) {
            if (this.columnStatus.isOK() && this.rowStatus.isOK()) {
                return PasteModeEnumeration.PASTE_EOBJECT_ROW_OR_COLUMN;
            }
            if (this.columnStatus.isOK() && !this.rowStatus.isOK()) {
                return PasteModeEnumeration.PASTE_EOBJECT_COLUMN;
            }
            if (!this.columnStatus.isOK() && this.rowStatus.isOK()) {
                return PasteModeEnumeration.PASTE_EOBJECT_ROW;
            }
        }
        if (this.rowStatus != null && this.rowStatus.isOK() && this.columnStatus == null) {
            return PasteModeEnumeration.PASTE_EOBJECT_ROW;
        }
        if (this.columnStatus != null && this.rowStatus == null && this.columnStatus.isOK()) {
            return PasteModeEnumeration.PASTE_EOBJECT_COLUMN;
        }
        return PasteModeEnumeration.CANT_PASTE;
    }

    public MultiStatus getColumnStatus() {
        return this.columnStatus;
    }

    public MultiStatus getRowStatus() {
        return this.rowStatus;
    }
}

