/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrus.customization.properties.generation.generators.EcoreGenerator;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.ConstraintsFactory;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.ValueProperty;
import org.eclipse.papyrus.infra.constraints.environment.ConstraintType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.NameKind;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.SwitchingSourceTraceHelper;
import org.eclipse.uml2.common.util.UML2Util;

class ImplicitEcoreSourceTraceHelper
extends SwitchingSourceTraceHelper {
    private static final String EMF_INSTANCE_OF = "org.eclipse.papyrus.infra.constraints.constraints.EMFInstanceOfConstraint";
    private static final String PROPERTY_NS_URI = "nsUri";
    private static final String PROPERTY_CLASS_NAME = "className";
    private static final String ANNOTATION__REDEFINES = "redefines";

    ImplicitEcoreSourceTraceHelper() {
    }

    @Override
    public List<? extends EObject> getNestedPackages(EObject sourcePackage) {
        return sourcePackage instanceof EPackage ? ((EPackage)sourcePackage).getESubpackages() : null;
    }

    @Override
    public List<? extends EObject> getClasses(EObject sourcePackage) {
        return sourcePackage instanceof EPackage ? this.getEClasses((EPackage)sourcePackage) : null;
    }

    private List<EClass> getEClasses(EPackage ePackage) {
        return ePackage.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).collect(Collectors.toList());
    }

    @Override
    protected EObject getOwningPackage(EObject sourceElement) {
        return sourceElement instanceof EClassifier ? ((EClassifier)sourceElement).getEPackage() : (sourceElement instanceof EPackage ? ((EPackage)sourceElement).getESuperPackage() : null);
    }

    @Override
    protected EObject getClass(EObject sourcePackage, DataContextElement contextElement) {
        EClassifier result = sourcePackage instanceof EPackage ? ((EPackage)sourcePackage).getEClassifier(contextElement.getName()) : null;
        return result instanceof EClass ? result : null;
    }

    @Override
    public List<? extends EObject> getProperties(EObject sourceClass) {
        return sourceClass instanceof EClass ? ((EClass)sourceClass).getEStructuralFeatures() : null;
    }

    @Override
    public boolean isPropertyRedefinition(EObject sourceProperty) {
        EList redefinitions;
        EAnnotation redefinesAnnotation = sourceProperty instanceof EStructuralFeature ? ((EStructuralFeature)sourceProperty).getEAnnotation(ANNOTATION__REDEFINES) : null;
        EList eList = redefinitions = redefinesAnnotation == null ? ECollections.emptyEList() : redefinesAnnotation.getReferences();
        return !redefinitions.isEmpty() && redefinitions.get(0) instanceof EStructuralFeature;
    }

    @Override
    public List<? extends EObject> getSuperclasses(EObject sourceClass) {
        return sourceClass instanceof EClass ? ((EClass)sourceClass).getESuperTypes() : null;
    }

    @Override
    public ConstraintDescriptor createInstanceOfConstraint(EObject sourceClass) {
        SimpleConstraint result = null;
        if (sourceClass instanceof EClass) {
            result = this.getConstraintType(EMF_INSTANCE_OF).map(type -> {
                SimpleConstraint constraint = ConstraintsFactory.eINSTANCE.createSimpleConstraint();
                constraint.setConstraintType(type);
                this.setEClassifier(constraint, (EClass)sourceClass);
                return constraint;
            }).orElse(null);
        }
        return result;
    }

    @Override
    public boolean isInstanceOfConstraint(ConstraintDescriptor constraint) {
        return this.getConstraintType(constraint).map(ConstraintType::getConstraintClass).filter(EMF_INSTANCE_OF::equals).isPresent();
    }

    @Override
    public EObject resolveInstanceOfConstraintClass(ConstraintDescriptor constraint) {
        EObject result = null;
        if (this.isInstanceOfConstraint(constraint)) {
            result = this.asSimpleConstraint(constraint).map(simple -> {
                String nsURI = this.getValue((SimpleConstraint)simple, PROPERTY_NS_URI);
                String className = this.getValue((SimpleConstraint)simple, PROPERTY_CLASS_NAME);
                EPackage ePackage = EMFHelper.getResourceSet((EObject)simple).getPackageRegistry().getEPackage(nsURI);
                return ePackage == null ? null : ePackage.getEClassifier(className);
            }).orElse(null);
        }
        return result;
    }

    @Override
    public String getClassName(ConstraintDescriptor instanceOfConstraint) {
        return this.asSimpleConstraint(instanceOfConstraint).map(simple -> this.getValue((SimpleConstraint)simple, PROPERTY_CLASS_NAME)).orElse(null);
    }

    @Override
    public ValueProperty getClassNameProperty(ConstraintDescriptor instanceOfConstraint) {
        return this.asSimpleConstraint(instanceOfConstraint).map(simple -> this.getProperty((SimpleConstraint)simple, PROPERTY_CLASS_NAME)).orElse(null);
    }

    @Override
    public IGenerator createGenerator(EObject sourceClass) {
        EcoreGenerator result = null;
        if (sourceClass instanceof EClassifier) {
            result = new EcoreGenerator(sourceClass){
                {
                    this.ecorePackage = ((EClassifier)eObject).getEPackage();
                    this.listEPackages = Lists.newArrayList((Object[])new EPackage[]{this.ecorePackage});
                }
            };
        }
        return result;
    }

    @Override
    protected EObject getProperty(EObject class_, Property contextProperty) {
        return class_ instanceof EClass ? ((EClass)class_).getEStructuralFeature(contextProperty.getName()) : null;
    }

    @Override
    public String getName(EObject sourceElement, NameKind kind) {
        String result = null;
        if (sourceElement instanceof ENamedElement) {
            ENamedElement namedElement = (ENamedElement)sourceElement;
            switch (kind) {
                case QUALIFIED: {
                    result = UML2Util.getQualifiedName((ENamedElement)namedElement, (String)"::");
                    break;
                }
                default: {
                    result = namedElement.getName();
                }
            }
        }
        return result;
    }

    @Override
    public int getMultiplicity(EObject sourceProperty) {
        return sourceProperty instanceof ETypedElement ? ((ETypedElement)sourceProperty).getUpperBound() : DEFAULT_MULTIPLICITY;
    }

    @Override
    protected Switch<EObject> createConstraintsSwitch() {
        return new SwitchingSourceTraceHelper.ConstraintsDelegate(this){

            @Override
            protected EObject constraintSwitch(SimpleConstraint constraint, String constraintClass) {
                EObject result = null;
                switch (constraintClass) {
                    case "org.eclipse.papyrus.infra.constraints.constraints.EMFInstanceOfConstraint": {
                        result = ImplicitEcoreSourceTraceHelper.this.getEClassifier(constraint);
                    }
                }
                return result;
            }
        };
    }

    private EObject getEClassifier(SimpleConstraint constraint) {
        EObject result = null;
        String nsURI = this.getValue(constraint, PROPERTY_NS_URI);
        String className = this.getValue(constraint, PROPERTY_CLASS_NAME);
        if (nsURI != null && className != null) {
            EPackage ePackage = EMFHelper.getResourceSet((EObject)constraint).getPackageRegistry().getEPackage(nsURI);
            return ePackage != null ? ePackage.getEClassifier(className) : null;
        }
        return result;
    }

    private void setEClassifier(SimpleConstraint constraint, EClass eClass) {
        this.setValue(constraint, PROPERTY_NS_URI, eClass.getEPackage().getNsURI());
        this.setValue(constraint, PROPERTY_CLASS_NAME, eClass.getName());
    }
}

