/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CopyPasteUtil {
    public static final int DEFAULT_AVOID_SUPERPOSITION_Y = 10;
    public static final int DEFAULT_AVOID_SUPERPOSITION_X = 10;

    public static Point shiftLayout(Point point) {
        return new Point(point.x + 10, point.y + 10);
    }

    public static Point getCursorPosition(GraphicalEditPart targetEditPart) {
        Display display = Display.getDefault();
        org.eclipse.swt.graphics.Point cursorLocation = display.getCursorLocation();
        EditPartViewer viewer = targetEditPart.getViewer();
        Control control = viewer.getControl();
        org.eclipse.swt.graphics.Point point = control.toControl(cursorLocation);
        FigureCanvas figureCanvas = (FigureCanvas)control;
        Point location = figureCanvas.getViewport().getViewLocation();
        return new Point(point.x + location.x, point.y + location.y);
    }

    public static Collection<EObject> filterEObject(Collection<Object> collection) {
        ArrayList<EObject> eobjectList = new ArrayList<EObject>();
        for (Object object : collection) {
            if (!(object instanceof EObject)) continue;
            eobjectList.add((EObject)object);
        }
        return eobjectList;
    }

    public static Map<Object, EObject> transtypeCopier(EcoreUtil.Copier copier) {
        HashMap<Object, EObject> map = new HashMap<Object, EObject>();
        Set entrySet = copier.entrySet();
        for (Map.Entry entry : entrySet) {
            map.put(entry.getKey(), (EObject)entry.getValue());
        }
        return map;
    }

    public static GraphicalEditPart lookForTargetEditPart(GraphicalEditPart targetEditPart, View view) {
        List children = targetEditPart.getChildren();
        PreferencesHint prefs = ((IDiagramPreferenceSupport)targetEditPart.getRoot()).getPreferencesHint();
        CreateViewRequest request = new CreateViewRequest(view.getElement(), prefs);
        for (Object object : children) {
            GraphicalEditPart graphicalEditPart;
            Command command;
            if (!(object instanceof GraphicalEditPart) || (command = (graphicalEditPart = (GraphicalEditPart)object).getCommand((Request)request)) == null) continue;
            return graphicalEditPart;
        }
        return null;
    }

    public static Command lookForCommandInSubContainer(GraphicalEditPart targetEditPart, List<EObject> objectToDrop) {
        List children = targetEditPart.getChildren();
        DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
        for (Object object : children) {
            if (!(object instanceof GraphicalEditPart)) continue;
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)object;
            Point center = graphicalEditPart.getFigure().getBounds().getCenter();
            dropObjectsRequest.setLocation(center);
            dropObjectsRequest.setObjects(objectToDrop);
            Command command = graphicalEditPart.getCommand((Request)dropObjectsRequest);
            if (command == null) continue;
            return command;
        }
        return null;
    }

    public static Command lookForCommandInSubContainer(GraphicalEditPart targetEditPart, List<EObject> semanticObjects, Point newLocation) {
        List children = targetEditPart.getChildren();
        DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
        for (Object object : children) {
            if (!(object instanceof GraphicalEditPart)) continue;
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)object;
            dropObjectsRequest.setLocation(newLocation);
            dropObjectsRequest.setObjects(semanticObjects);
            Command command = graphicalEditPart.getCommand((Request)dropObjectsRequest);
            if (command == null) continue;
            return command;
        }
        return null;
    }
}

